/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.decoration.symbol;

import java.util.Objects;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.AbstractShadowable;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.MagneticBorder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.style.SName;

public class USymbolFolder
extends USymbol {
    private static final int marginTitleX1 = 3;
    private static final int marginTitleX2 = 3;
    private static final int marginTitleX3 = 7;
    private static final int marginTitleY0 = 0;
    private static final int marginTitleY1 = 3;
    private static final int marginTitleY2 = 3;
    private final SName sname;
    private final boolean showTitle;

    public USymbolFolder(SName sname, boolean showTitle) {
        this.showTitle = showTitle;
        this.sname = sname;
    }

    public String toString() {
        return super.toString() + " " + this.showTitle;
    }

    @Override
    public SName getSName() {
        return this.sname;
    }

    private void drawFolder(UGraphic ug, double width, double height, XDimension2D dimName, double shadowing, double roundCorner) {
        AbstractShadowable shape;
        double wtitle = this.getWTitle(width, dimName);
        double htitle = this.getHTitle(dimName);
        if (roundCorner == 0.0) {
            UPolygon poly = new UPolygon();
            poly.addPoint(0.0, 0.0);
            poly.addPoint(wtitle, 0.0);
            poly.addPoint(wtitle + 7.0, htitle);
            poly.addPoint(width, htitle);
            poly.addPoint(width, height);
            poly.addPoint(0.0, height);
            poly.addPoint(0.0, 0.0);
            shape = poly;
        } else {
            UPath path = UPath.none();
            path.moveTo(roundCorner / 2.0, 0.0);
            path.lineTo(wtitle - roundCorner / 2.0, 0.0);
            path.arcTo(new XPoint2D(wtitle, roundCorner / 2.0), roundCorner / 2.0 * 1.5, 0.0, 1.0);
            path.lineTo(wtitle + 7.0, htitle);
            path.lineTo(width - roundCorner / 2.0, htitle);
            path.arcTo(new XPoint2D(width, htitle + roundCorner / 2.0), roundCorner / 2.0, 0.0, 1.0);
            path.lineTo(width, height - roundCorner / 2.0);
            path.arcTo(new XPoint2D(width - roundCorner / 2.0, height), roundCorner / 2.0, 0.0, 1.0);
            path.lineTo(roundCorner / 2.0, height);
            path.arcTo(new XPoint2D(0.0, height - roundCorner / 2.0), roundCorner / 2.0, 0.0, 1.0);
            path.lineTo(0.0, roundCorner / 2.0);
            path.arcTo(new XPoint2D(roundCorner / 2.0, 0.0), roundCorner / 2.0, 0.0, 1.0);
            path.closePath();
            shape = path;
        }
        shape.setDeltaShadow(shadowing);
        ug.draw(shape);
        ug.apply(UTranslate.dy(htitle)).draw(ULine.hline(wtitle + 7.0));
    }

    private double getWTitle(double width, XDimension2D dimTitle) {
        double wtitle = dimTitle.getWidth() == 0.0 ? Math.max(30.0, width / 4.0) : dimTitle.getWidth() + 3.0 + 3.0;
        return wtitle;
    }

    private double getHTitle(XDimension2D dimTitle) {
        double htitle = dimTitle.getWidth() == 0.0 ? 10.0 : dimTitle.getHeight() + 3.0 + 3.0;
        return htitle;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 20.0, 13.0, 10.0);
    }

    @Override
    public TextBlock asSmall(final TextBlock title, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        Objects.requireNonNull(title);
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = symbolContext.apply(ug);
                XDimension2D dimTitle = this.getDimTitle(ug.getStringBounder());
                USymbolFolder.this.drawFolder(ug, dim.getWidth(), dim.getHeight(), dimTitle, symbolContext.getDeltaShadow(), symbolContext.getRoundCorner());
                USymbol.Margin margin = USymbolFolder.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                if (USymbolFolder.this.showTitle) {
                    title.drawU(ug.apply(new UTranslate(4.0, 3.0)));
                }
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1() + dimTitle.getHeight())));
            }

            private XDimension2D getDimTitle(StringBounder stringBounder) {
                return USymbolFolder.this.showTitle ? title.calculateDimension(stringBounder) : new XDimension2D(40.0, 15.0);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimName = this.getDimTitle(stringBounder);
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolFolder.this.getMargin().addDimension(dimName.mergeTB(dimStereo, dimLabel));
            }

            @Override
            public MagneticBorder getMagneticBorder() {
                return new MagneticBorder(){

                    @Override
                    public UTranslate getForceAt(StringBounder stringBounder, XPoint2D position) {
                        XDimension2D dim = this.calculateDimension(stringBounder);
                        XDimension2D dimTitle = this.getDimTitle(stringBounder);
                        double wtitle = USymbolFolder.this.getWTitle(dim.getWidth(), dimTitle);
                        double htitle = USymbolFolder.this.getHTitle(dimTitle);
                        if (position.getX() >= wtitle && position.getY() >= 0.0 && position.getY() <= htitle) {
                            return new UTranslate(0.0, htitle);
                        }
                        if (position.getY() <= 0.0 && position.getX() >= wtitle + 7.0) {
                            return new UTranslate(0.0, htitle);
                        }
                        if (position.getY() <= 0.0 && position.getX() >= wtitle - 7.0) {
                            double delta = position.getX() - (wtitle - 7.0);
                            double how = delta / 14.0;
                            return new UTranslate(0.0, htitle * how);
                        }
                        return UTranslate.none();
                    }
                };
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                StringBounder stringBounder = ug.getStringBounder();
                XDimension2D dim = this.calculateDimension(stringBounder);
                ug = symbolContext.apply(ug);
                XDimension2D dimTitle = title.calculateDimension(stringBounder);
                USymbolFolder.this.drawFolder(ug, dim.getWidth(), dim.getHeight(), dimTitle, symbolContext.getDeltaShadow(), symbolContext.getRoundCorner());
                title.drawU(ug.apply(new UTranslate(4.0, 2.0)));
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(4.0 + posStereo, 2.0 + USymbolFolder.this.getHTitle(dimTitle))));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }

            @Override
            public MagneticBorder getMagneticBorder() {
                return new MagneticBorder(){

                    @Override
                    public UTranslate getForceAt(StringBounder stringBounder, XPoint2D position) {
                        XDimension2D dim = this.calculateDimension(stringBounder);
                        XDimension2D dimTitle = title.calculateDimension(stringBounder);
                        double wtitle = USymbolFolder.this.getWTitle(dim.getWidth(), dimTitle);
                        double htitle = USymbolFolder.this.getHTitle(dimTitle);
                        if (position.getX() >= wtitle && position.getY() >= 0.0 && position.getY() <= htitle) {
                            return new UTranslate(0.0, htitle);
                        }
                        if (position.getY() <= 0.0 && position.getX() >= wtitle + 7.0) {
                            return new UTranslate(0.0, htitle);
                        }
                        if (position.getY() <= 0.0 && position.getX() >= wtitle - 7.0) {
                            double delta = position.getX() - (wtitle - 7.0);
                            double how = delta / 14.0;
                            return new UTranslate(0.0, htitle * how);
                        }
                        return UTranslate.none();
                    }
                };
            }
        };
    }
}

