# tewhatuora.fhir.nz-shared-digital-health-record#1.0.0: NZ Shared Digital Health Record API

## Pages

* [](index.md)
* [Compliance Requirements - for Systems Sharing Data](compliance-requirements.md)
* [Use cases](use-cases.md)
* [Test Data](test-data.md)
* [Consent based access control](consent-based-access.md)
* [API Docs](api.md)
* [Data Models](data-models.md)
* [FHIR Artifacts](artifacts.md)

## Resources

### CodeSystems

* [NZ-specific terminology for Shared Digital Health Records](CodeSystem-nz-sdhr-codesystem.md)
* [SDHR Codes where the appropriate code is not known or can not be determined.](CodeSystem-sdhr-other-codes.md)
* [SDHR Specific Outcome Codes](CodeSystem-sdhr-outcome-codes.md)
* [SDHR Participation Reason Codes](CodeSystem-sdhr-participation-reason.md)

### ValueSets

* [ValueSet for AllergyIntolerance Code](ValueSet-sdhr-allergyintolerance-code-valueset.md)
* [ValueSet for AllergyIntolerance Manifestation](ValueSet-sdhr-allergyintolerance-manifestation-valueset.md)
* [ValueSet for AllergyIntolerance Severity](ValueSet-sdhr-allergyintolerance-severity-valueset.md)
* [ValueSet for SDHR Participation Reason](ValueSet-sdhr-participation-reason-valueset.md)
* [ValueSet for SDHR Resource Tags](ValueSet-sdhr-resource-tags-valueset.md)

### Resource Profiles

* [SDHRAllergyIntolerance](StructureDefinition-SDHRAllergyIntolerance.md)
* [Batch Bundle with a Single Patient](StructureDefinition-SDHRBatchBundle.md)
* [SDHRCondition](StructureDefinition-SDHRCondition.md)
* [SDHRConsent](StructureDefinition-SDHRConsent.md)
* [SDHRObservation](StructureDefinition-SDHRObservation.md)

### Extensions

* [Facility Participation](StructureDefinition-facility-participation-extension.md)
* [Client Last Updated](StructureDefinition-hnz-sdhr-client-last-updated-extension.md)
* [HNZ SDHR Highlighted](StructureDefinition-hnz-sdhr-highlighted-extension.md)

### CapabilityStatements

* [NZ Shared Digital Health Record API](CapabilityStatement-SDHRCapabilityStatement.md)

### ImplementationGuides

* [NZ Shared Digital Health Record API](index.md)

### OperationDefinitions

* [HNZParticipate](OperationDefinition-SDHRHNZParticipateOperation.md)
* [Participate](OperationDefinition-SDHRParticipateOperation.md)

### SearchParameters

* [ConditionHighlighted](SearchParameter-condition-highlighted.md)
* [ConditionLongTermCondition](SearchParameter-condition-long-term-condition.md)

### Examples

* [AllergyIntoleranceExample (AllergyIntolerance)](AllergyIntolerance-AllergyIntoleranceExample.md)
* [AllergyIntoleranceExample2 (AllergyIntolerance)](AllergyIntolerance-AllergyIntoleranceExample2.md)
* [Batch-example (Bundle)](Bundle-Batch-example.md)
* [SearchConditionResponseExample (Bundle)](Bundle-SearchConditionResponseExample.md)
* [SearchConfidentialRecordsResponseExample (Bundle)](Bundle-SearchConfidentialRecordsResponseExample.md)
* [SearchExactMatchRecordWithheldExample (Bundle)](Bundle-SearchExactMatchRecordWithheldExample.md)
* [SearchWithRecordsWithheldExample (Bundle)](Bundle-SearchWithRecordsWithheldExample.md)
* [ConditionHypertensionExample (Condition)](Condition-ConditionHypertensionExample.md)
* [ConditionRespiratoryExample (Condition)](Condition-ConditionRespiratoryExample.md)
* [ConsentExample (Consent)](Consent-ConsentExample.md)
* [ConsentExampleRecordsWithheld (Consent)](Consent-ConsentExampleRecordsWithheld.md)
* [ConsentFacilityDenyExample (Consent)](Consent-ConsentFacilityDenyExample.md)
* [ConsentHNZDenyExample (Consent)](Consent-ConsentHNZDenyExample.md)
* [ConsentMultiFacilityExample (Consent)](Consent-ConsentMultiFacilityExample.md)
* [ObservationVitalSignsExample (Observation)](Observation-ObservationVitalSignsExample.md)
* [APIError-Confidential (OperationOutcome)](OperationOutcome-APIError-Confidential.md)
* [APIError-Unauthorised (OperationOutcome)](OperationOutcome-APIError-Unauthorised.md)
* [OperationOutcomeFacilityDenyExample (OperationOutcome)](OperationOutcome-OperationOutcomeFacilityDenyExample.md)
* [OperationOutcomeFacilityLocked (OperationOutcome)](OperationOutcome-OperationOutcomeFacilityLocked.md)
* [OperationOutcomeFacilityUnknown (OperationOutcome)](OperationOutcome-OperationOutcomeFacilityUnknown.md)
* [OperationOutcomeGlobalDenyExample (OperationOutcome)](OperationOutcome-OperationOutcomeGlobalDenyExample.md)
* [OperationOutcomeParticipateInvalidPatient (OperationOutcome)](OperationOutcome-OperationOutcomeParticipateInvalidPatient.md)
* [OperationOutcomeParticipateMissingReason (OperationOutcome)](OperationOutcome-OperationOutcomeParticipateMissingReason.md)
* [OperationOutcomeParticipatePreferencesNotKnown (OperationOutcome)](OperationOutcome-OperationOutcomeParticipatePreferencesNotKnown.md)
* [OperationOutcomeParticipateSuccess (OperationOutcome)](OperationOutcome-OperationOutcomeParticipateSuccess.md)
* [OperationOutcomePatientLocked (OperationOutcome)](OperationOutcome-OperationOutcomePatientLocked.md)
* [OperationOutcomeRateLimitExceeded (OperationOutcome)](OperationOutcome-OperationOutcomeRateLimitExceeded.md)
* [OperationOutcomeRecordsWithheldAtSource (OperationOutcome)](OperationOutcome-OperationOutcomeRecordsWithheldAtSource.md)
* [ParametersDoNotParticipate (Parameters)](Parameters-ParametersDoNotParticipate.md)
* [ParametersHNZParticipateOptIn (Parameters)](Parameters-ParametersHNZParticipateOptIn.md)
* [ParametersHNZParticipateOptOut (Parameters)](Parameters-ParametersHNZParticipateOptOut.md)
* [ParametersParticipate (Parameters)](Parameters-ParametersParticipate.md)
* [ParametersParticipateRecordReleased (Parameters)](Parameters-ParametersParticipateRecordReleased.md)
* [ParametersParticipateRecordWithheld (Parameters)](Parameters-ParametersParticipateRecordWithheld.md)
