# Compliance Requirements - for Systems Sharing Data - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* **Compliance Requirements - for Systems Sharing Data**

## Compliance Requirements - for Systems Sharing Data

### Important information about Compliance requirements

#### Use cases & the two step accreditation process

These compliance requirements are for data source systems integrating with the Shared Digital Health Record to share data. In the first instance this is limited to Practice Management Systems (PMS). They do not cover the compliance tests for systems (including PMSs) that use SDHR APIs to fetch and display data for a clinical user to view. Requirements for those systems are covered separately.

![](flow.png)

Fig 1: Applications are assessed separately for their compliance with requirements to share and view SDHR information.

#### Bulk acquisition design

There are two designs for the initial bulk acquisition of historical data from a facility when it first is connected to SDHR. These are referred to as either the Push-based or the Pull-based;

* **Pull-based** is where SHDR performs and initial bulk data load for a facility on the behalf of an application
* **Push-based** is where the application is in control of the request and uses a bulk API

Each digital subscriber will only use one of these. If a requirement is intended to apply specifically to either Push-based or Pull-based, then this will be denoted in the requirements table. It is not intended that an application need comply with both designs.

There may be some requirements that are not appropriate for every application. In this situation, provide a **written statement** for why the requirement does apply and/or a justification for an alternative outcome.

![](components.png)

Fig 2. Data acquisition solution components

#### Types of Evidence

For each requirement, please provide appropriate evidence as per the guidance below.

| | |
| :--- | :--- |
| **HNZ test scenario** | A test scenario, and sample data, will be provided by an HNZ tester, run by vendor, and the output will be provided. Please use the SDHR UAT environment to create the relevant test data to complete each test. |
| **Design & Test evidence from the Vendor** | Please provide suitable evidence of vendor design and testing, showing that the application meets the expected outcome, including:* Test output
* Screenshots, or other evidence of input values within the application,
* Screenshots or extracts of log files, or other evidence of the expected outcome values within the application,
* If appropriate, a video recording of the scenario may be provided instead of screenshots, 
* Please the SDHR UAT environment to create the relevant test data to complete each scenario. 
 |
| **Attestation** | A statement and explanation for how the application meets the requirement. Please also supply available evidence to support your statement such as* A business process or SOP,
* Screenshots, or other evidence of the inputs & expected outcomes within the application, 
* If appropriate, a video recording of the scenario may be provided instead of screenshots. 
 |

### Support for these compliance requirements

The SDHR team will assess your responses and discuss with you if any further clarification is needed.

### Compliance requirements

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| 1. 
 | The application****does not implement the ability to browse or persist data from SDHR that it does not already hold locally (this capability requires separate compliance testing)**Please Note**: HNZ expects to use monitoring-based controls to ensure that the applications that are only accredited for sharing data to SDHR are not accessing data for reasons other than record management. | N/A | The vendor confirms this requirement is met | Mandatory | Attestation from vendor that they are not using the application to surface SDHR data to end users |
| 1. 
 | The application does not modify records in SDHR that it does not already hold locally (for example, only records created in the application, or imported as part of a patient transfer, should be modified). | N/A | The vendor confirms this requirement is met | Mandatory | Attestation from vendor that they are not using the application to change records that are not mastered at that practice |
| 1. 
 | The application adequately handles rate limits enforced by the SDHR API, and implements queuing, exponential backoff, and retries if the limit is breached. | The application receives a HTTP 429 error code when calling the SDHR API | Subsequent requests to SDHR are delayed until the rate limit expires. | Recommended | Design and test output from vendor showing that they are adhering to the prescribed rate limits and handling retries |
| 1. 
 | The application adequately handles error codes and responses from the SDHR API[See here for the list of error codes for Update or Create (POST or PUT) Operation Statuses](https://fhir-ig.digital.health.nz/sdhr/CapabilityStatement-SDHRCapabilityStatement.html#update-or-create-post-or-put-operation-statuses) | The application receives a HTTP 4XX error code when calling the SDHR API | The error is logged and there is monitoring & alerting in place for elevated or unusual error rates. | Mandatory | Design and test output from vendor showing error handling |
| It is possible to distinguish errors that require investigation from errors that are expected due to known factors. | Mandatory | Design and test output from vendor showing error handling | | | |
| Information can be provided to HNZ on request to support diagnostics, including the x-correlation-id header | Mandatory | Design and test output from vendor showing error handling | | | |
| 1. 
 | The application ensures requests are delivered if a transient error message is received from the SDHR API[See here for the list of error codes for Update or Create (POST or PUT) Operation Statuses](https://fhir-ig.digital.health.nz/sdhr/CapabilityStatement-SDHRCapabilityStatement.html#update-or-create-post-or-put-operation-statuses) | The application receives a HTTP 5XX response that indicates a transient error has occurred (for example, the request was well formed but the server was unable to process it). | The request is retried if the response indicates the error is transient. | Mandatory | Design and test output from vendor showing error handling |
| Information can be provided to HNZ on request to support diagnostics, including the x-correlation-id header | Mandatory | Design and test output from vendor showing error handling | | | |
| 1. 
 | The application ensures that requests to create or update records are re-attempted as soon as SDHR is available after facility load is complete. | The application receives a HTTP “sdhr-facility-locked" operation outcome error when calling the SDHR API informing the application that the facility FHIR resources are in-use by SDHR | Subsequent attempts to create or update SDHR resources for the facility are queued and re-tried. | Mandatory | Design and test output from vendor |
| 1. 
 | The application ensures that requests to create or update records for a patient are re-attempted after****SDHR has re-loaded history for that patient who has re-opted to share history | The application receives a HTTP “sdhr-patient-locked" operation outcome error when calling the SDHR API informing the application that the facility FHIR Resources are in-use by SDHR | Subsequent attempts to create or update SDHR resources for the patient are queued and re-tried | Mandatory | Design and test output from vendor |
| 1. 
 | Where an application loads patient history and real time data concurrently, the application ensures that real time latest data is not overwritten by historical data | History for the patient is loaded for the first time or when patient re-opting is recorded in the PMS AND at the same time the same records are being updated in SDHR in real time | Real time data is not superseded by earlier history records | Mandatory | Design and test output from vendor |
| 1. 
 | Where the application batches records for creation or updating in SDHR, the application ensures that only the records that are rejected by SDHR are resent (and not the whole batch). This is to avoid the creation of duplicates. | SDHR rejects some records in a batch | Only the rejected records are resent and received by SDHR | Mandatory | Design and test output from vendor |
| 1. 
 | The application supports the user to correctly identify and associate the appropriate NHI for the patient before information is sent to SDHR.Please note: HNZ have process controls to ensure practices are correctly using NHIs to identify patients. | The end user is entering or locating an NHI for a patient | Demonstrate user interface workflow / validation for NHI inputs.All records have a valid NHI.It is not possible to associate a non-existent or invalid NHI to a patient.NHI numbers are not shared by more than one person. | Mandatory | Attestation and business process from vendor, e.g. system controls, screenshots, NHI lookup, etc |
| 1. 
 | The application subscribes to the outcome of NHI linking operations and applies the results to any applicable NHI held in the local patient record. | The existing NHI on a patient record is linked to another NHI by HNZ (e.g. HNZ identify the person has two NHI numbers). | The application subscribes to the results of the linking operation and updates the patient to use the Master NHI number. | Recommended | Attestation and business process from vendor, e.g. system controls, screenshots, NHI lookup, etc |
| 1. 
 | The application correctly specifies the system-context request header with appropriate values | The application makes a request to the SDHR API | The request includes the system-context header.The header properties are set according to the values specified in the FHIR IG, including the HPI Facility ID of the physical location where the record was sourced from. | Mandatory | Test scenarios from HNZ tester run by vendor and output provided |
| The request does not include the user-context header. | Mandatory | Test scenarios from HNZ tester run by vendor and output provided | | | |
| 1. 
 | The application correctly manages**Condition**and**Observation**resources if they are marked as**confidential**/sensitive. | A local record that maps to a**Condition**or**Observation**resource that has been marked as confidential is created. | The application does not create the corresponding**Condition**or**Observation**resource in SDHR. | Mandatory | Test scenarios from HNZ tester run by vendor and output provided |
| The application calls the $participate operation with the NHI, Facility ID, resource type, local record ID, and reason code “sdhr-record-withheld”. | Mandatory | Test scenarios from HNZ tester run by vendor and output provided | | | |
| A local record that maps to a**Condition**or**Observation**resource that has previously been shared with SDHR is marked as confidential. | The application updates the record in SDHR to set the meta.security attribute to RESTRICTED. | Mandatory | Test scenarios from HNZ tester run by vendor and output provided | | |
| The application calls the $participate operation with the NHI, Facility ID, resource type, local record ID, and reason code “sdhr-record-withheld”. | Mandatory | Test scenarios from HNZ tester run by vendor and output provided | | | |
| 1. 
 | When accommodating**Facility level participation**, the application correctly manages the patient non-participation preference for a given facility | A patient has chosen to not participate in SDHR data sharing at a given facility | The application has a setting to record this preference for that all enrolled patients at that facility | Mandatory | Attestation and business process from vendor |
| For applications using**pull-based**bulk upload, SDHR internally calls the $participate operation with the NHI, Facility ID and sets the participationIndicator of false | Mandatory | Test scenarios from HNZ tester run by vendor and output provided | | | |
| The application immediately prevents any local records for that patient being sent to SDHR.For**push-based**bulk uploads, and all other types of changes to local records, the application calls the $participate operation with the NHI, Facility ID and a participationIndicator of false | | | | | |
| A patient who has previously opted out decides to opt back in to SDHR data sharing at a given facility | The application calls the $participate operation with the NHI, Facility ID and a participationIndicator of true. | Mandatory | Test scenarios from HNZ tester run by vendor and output provided | | |
| For applications using a**pull-based**uploads, SDHR initiates a load of the individuals history. | Mandatory | Test scenarios from HNZ tester run by vendor and output provided | | | |
| For applications using**push-based**uploads, the application triggers a historic load of local records for the given patient at that facility. | Mandatory | Test scenarios from HNZ tester run by vendor and output provided | | | |
| The application, at the earliest practical time*, resumes sending new and changed local records to SDHR for that patient.*Please note resumption should be in line with the outcomes of SSD-7 and SSD-8. | Mandatory | Test scenarios from HNZ tester run by vendor and output provided | | | |
| 1. 
 | When accommodating**Global participation (opt out),**the application correctly handles patient non-participation choices, for patients who choose to opt out of SDHR entirely (via HNZ opt out channel) | A patient has chosen to not participate in SDHR data sharing at a national levelZMW9001 or ZMW9009 can be used as the NHI in UAT for this scenario. | The application does not interpret the Global Deny OperationOutcome as applying to the facility opt out preference (i.e. the facility opt out setting is not changed as a result) | Mandatory | Test scenarios from HNZ tester run by vendor and output provided |
| The application does not cache or otherwise retain the result of a Global Deny OperationOutcome and use it to prevent future Resources being sent to SDHR | Mandatory | Test scenarios from HNZ tester run by vendor and output provided | | | |
| The application does not attempt to retry sending a Resource to SDHR after receiving a Global Deny OperationOutcome for that Resource | Mandatory | Test scenarios from HNZ tester run by vendor and output provided | | | |
| 1. 
 | When accommodating**Global participation (opt back in),**the application has a mechanism to receive a notification from HNZ when a patient chooses to opt back into SDHR, to initiate a bulk load of that patient’s information from their enrolled practice | A patient who has previously chosen to opt-out via the HNZ opt out channel, chooses to opt back in again via HNZ. | The application implements an API endpoint to trigger a bulk historic load for an enrolled patient (preferred)ORThe application provider has a manual process (e.g. via email or service desk) to trigger a bulk historic load for an enrolled patient (not preferred) | Mandatory | Test scenarios from HNZ tester run by vendor and output provided |
| **Onboarding facilities and historic bulk load** | | | | | |
| 1. 
 | The application does not send any information to SDHR until formal authorisation is received via a signed Information Sharing Agreement, and the facility has had adequate time to notify patients. | A facility has not yet opted in to participate in SDHR data sharing.A facility has not yet completed the notification process for enrolled patients. | No information from that facility will be shared with SDHR. | Mandatory | Design and test output from vendor |
| 1. 
 | The application supports sending a historic bulk load of information for only enrolled patients who have not opted out as part of the initial onboarding process. | A facility has chosen to participate in SDHR data sharing.An ISA and Acquisition Schedule has been signed that includes that facility | The application allows local records from that facility to be sent to SDHR. | Mandatory | Design and test output from vendor |
| 1. 
 | The application restricts the historic bulk load of information to only those patients that are enrolled at that facility. | Notification to commence the historic load of information from that facility has been given | The application restricts the historic load to only patients who are enrolled at that facility.Unenrolled patient history is not loaded. | Mandatory | Design and test output from vendor |
| 1. 
 | The application does not apply time limits for which local records are included in the historic bulk load. | The historic bulk load for a given facility has been triggered | The application shares all local records that map to the**AllergyIntolerance**,**Condition,**and**Observation**resources in SDHR | Mandatory | Design and test output from vendor |
| 1. 
 | The application excludes Condition and Observation resources marked as confidential from the historic bulk load | The historic bulk load for a given facility has been triggered, and a local record that maps to a Condition or Observation has been marked as confidential | The application does not create a Condition or Observation resource in SDHR for that local record. | Mandatory | Design and test output from vendor |
| 1. 
 | The application ensures the correct HPI Facility ID is used in the meta.source attribute on each resource | A record is created for a patient visiting a given physical practice/clinic with a HPI Facility ID | The meta.source attribute in the SDHR resource is the Facility ID that represents the HPI Facility identifier for the facility where the record is being sourced. | Mandatory | Design and test output from vendor |
| 1. 
 | The application creates or updates records in SDHR as close to real-time as practical | A new local record is created in the application | The new record is available in SDHR promptly, 95thpercentile are received within 5 minutes | Recommended | Design and test output from vendor |
| An existing local record is changed in the application | The updated record is available in SDHR promptly, 95thpercentile are received within 5 minutes, or sooner, as close to real time as possible. | Recommended | Design and test output from vendor | | |
| 1. 
 | The application only sends records to SDHR if the patient has a valid and active NHI | A new local record is created in the application for a patient without an NHI associated | The application does not send the record to SDHR as the NHI is missing | Mandatory | Attestation and business process from vendor, e.g. system controls, screenshots, NHI lookup, etc |
| A new local record is created in the application for a patient with an invalid NHI (e.g. invalid check digit) | The application does not send the record to SDHR as the NHI is not in the valid format. | Mandatory | Attestation and business process from vendor, e.g. system controls, screenshots, NHI lookup, etc | | |
| A new local record is created in the application for a patient with a correctly formatted NHI that does not exist in the NHI system (e.g. valid check digit but is unassigned) | The application does not send the record to SDHR as the NHI does not exist. | Mandatory | Attestation and business process from vendor, e.g. system controls, screenshots, NHI lookup, etc | | |
| 1. 
 | The application ensures that if a patient NHI changes, all records in SDHR for that patient at that facility are updated to the new NHI | A patient has a given NHIRecords for that patient have been created in SDHR with that NHI.The NHI on the patient record changes. | The application updates the NHI on every previously shared record for that patient at that facility. | Mandatory | Design and test output from vendor |
| 1. 
 | The application ensures that if a practitioner HPI identifier changes, all records in SDHR for that practitioner at that facility are updated to the new identifier | A practitioner has a given CPNResources that reference that practitioner CPN have been shared with SDHRThe CPN on the practitioner record changes. | The application updates the CPN on every previously shared record for that practitioner at that facility. | Mandatory | Design and test output from vendor |
| 1. 
 | The application can create a new**Resource**in SDHR from a local record | A local record that maps to the**Resource**created in the application. | The application does a POST to create the**Resource**in SDHR. | Mandatory | Design and test evidence from vendor |
| The attributes from the local record map to the SDHR**Resource**definition | Mandatory | Design and test evidence from vendor | | | |
| The attributes use the preferred bindings outlined in the FHIR IG | Recommended | Design and Test evidence from vendor | | | |
| 1. 
 | The application can update an existing SDHR**Resource**from a local record, including merging any changes made to the SDHR record with the local record | A local record that has previously been created in SDHR is modified in the application. | The application does a GET for the**Resource**using the SDHR_ID of the record (preferred)ORThe application does a SEARCH for the**Resource**using the local identifier(s) for the record to obtain the SDHR_ID | Recommended | Design and Test evidence from vendor |
| **Optional**The SDHR copy of the record also has modifications that do not exist in the local record. | The application mergesany changed attributes of the SDHR**Resource**with the local record.The local record is updated with these changes. | | | | |
| The application PUTs a new version of the**Resource**based on the local record. | Mandatory | Design and Test evidence from vendor | | | |
| 1. 
 | The application retains the SDHR_ID provided by SDHR when a local record is created or updated. | A new record is created in SDHR and a SDHR_ID is generated for that resource | The application retains the SDHR_ID provided in the SDHR API response and maintains it locally. | Mandatory | Design and Test Output showing “SDHR Resource_ID” is recorded in the PMS |
| The application is able to supply the SDHR_ID for subsequent reads or writes to that record. | Mandatory | Design and Test Output showing “SDHR_Resource_ID” remains constant | | | |
| 1. 
 | The application takes all practical steps to avoid creating system-generated duplicate records | A local record is created in the application from a source that is not user input | The application uses identifying attributes of the local record (e.g., the Facility ID, local record IDs, patient NHI, and resource type) to SEARCH if the record already exists in SDHR.If the record already exists in SDHR, the application retains the SDHR_ID (per SSD-25).If no matches are found the application creates the record (per SSD-23) | Mandatory | Attestation to ensure duplicates are not created as part of an edit/update |
| 1. 
 | The application includes the SDHR_ID in exports of local records to another system (e.g. a patient transfer to another practice) | Local records that have previously been shared with SDHR are being transferred to another system | The SDHR_ID for each record is included in the exported file or data structure in a way that allows the receiving system to determine which records have been sent to SDHR previously. | Recommended | Design and Test output showing the SDHR ID is transferred as part of the GP2GP transfer |
| 1. 
 | The application uses the SDHR_ID, if present, to identify existing records that are imported from another system (e.g. a patient transfer from another practice). | Records are being imported from an export provided by an external system, and some of those records include a SDHR_ID | The application imports the SDHR_ID and stores it alongside the local records per SSD-25. | Recommended | Desing and Test output showing the SDHR ID is accepted |
| 1. 
 | The application can create a new**Condition**resource in SDHR from a local record | A local record that maps to the Condition**Resource**is created in the application. | As Per SSD-27 | Mandatory | Design and Test output from vendor |
| 1. 
 | The application can update an existing**Condition**resource and the resulting SDHR record reflects the changes made in the PMS | A local record that has previously been created in SDHR is modified in the application. | As Per SSD-28 | Mandatory | Design and Test output from vendor |
| 1. 
 | The application creates and updates active and inactive**Condition**resources in SDHR.The bulk historic load should not include records that are already hard or soft deleted. | A local record that maps to the**Condition**resource with a status of active is created or updated | The application creates a new**Condition**resource or updates the corresponding**Condition**resource in SDHR. | Mandatory | Design and Test output from vendor |
| A local record that maps to the Condition resource with a status of inactive is created or updated | | | | | |
| **Observation Resources** | | | | | |
| 1. 
 | The application can create a new**Observation**resource in SDHR from a local record | A local record that maps to the Observation**Resource**is created in the application. | As Per SSD-27 | Mandatory | Design and Test output from vendor |
| 1. 
 | The application can update an existing**Observation**resource and the resulting SDHR record reflects the changes made in the PMS | A local record that has previously been created in SDHR is modified in the application. | As Per SSD-28 | Mandatory | Design and Test output from vendor |
| **Allergies & Intolerances Resources** | | | | | |
| 1. 
 | The application can create a new**AllergyIntolerance**resource in SDHR from a local record | A local record that maps to the A&I**Resource**is created in the application. | As Per SSD-27 | Mandatory | Design and Test output from vendor |
| 1. 
 | The application can update an existing**AllergyIntolerance**resource and the resulting SDHR record reflects the changes made in the PMS | A local record that has previously been created in SDHR is modified in the application. | As Per SSD-28 | Mandatory | Design and Test output from vendor |
| 1. 
 | The application creates and updates active and inactive**AllergyIntolerance**resources in SDHR.The bulk historic load should not include records that are already hard or soft deleted. | A local record that maps to the**AllergyIntolerance**resource with a status of active is created or updated | The application creates a new**AllergyIntolerance**resource or updates the corresponding**AllergyIntolerance**resource in SDHR. | Mandatory | Design and Test output from vendor |
| A local record that maps to the**AllergyIntolerance**resource with a status of inactive is created or updated | | | | | |

