# FHIR Artifacts - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* **FHIR Artifacts**

## FHIR Artifacts

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [NZ Shared Digital Health Record API](CapabilityStatement-SDHRCapabilityStatement.md) | NZ Shared Digital Health Record API Capability Statement |

### Behavior: Operation Definitions 

These are custom operations that can be supported by and/or invoked by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [SDHRHNZParticipateOperation](OperationDefinition-SDHRHNZParticipateOperation.md) | This operation allows a patient to choose to participate in the Shared Digital Health Record service via HNZ assisted channels. This operation should only be used by HNZ channels.Scenarios where this operation might be used include:* A patient has opted in to the Shared Digital Health Record service by contacting Health NZ via appropriate digital or assisted channels.
* A patient chooses not to participate in the Shared Digital Health Record service and informs Health NZ of this choice via appropriate digital or assisted channels.
For example payloads that might be used with this operation see:* [Parameters resource for total non-participation](./Parameters-ParametersHNZParticipateOptOut.md) : This example shows how to indicate that a patient does not wish to participate in the Shared Digital Health Record service (has opted out).
* [Parameters resource for participation](./Parameters-ParametersHNZParticipateOptIn.md) : This example shows how to indicate that a patient wishes to participate in the Shared Digital Health Record service.
To make a request to this operation the API Consumer must POST a`Parameters`payload to the operation URL (e.g.`POST https://api.sdhr.digital.health.nz/s2s/$hnz-participate`).The operation is idempotent, meaning that multiple requests with the same parameters will have the same effect as a single request. The operation is expected to be called by a Health NZ channel system on behalf of the patient, and the patient must be identified by their NHI. The operation will return an OperationOutcome resource indicating the result of the operation. |
| [SDHRParticipateOperation](OperationDefinition-SDHRParticipateOperation.md) | This operation allows a patient to choose to participate in the Shared Digital Health Record service. This operation should be used by data providers in the Shared Digital Health Record ecosystem such as Patient Management Systems (PMS) or Electronic Health Record (EHR) systems. It can be used to indicate whether the patient wishes to participate, whether any resources are withheld, and the reason for participation. The scope of this operation is the API consumer - e.g. an HPI Facility where patient data is held.Scenarios where this operation might be used include:* A patient has opted in to the Shared Digital Health Record service and appropriate data will be shared from the data holder to the service.
* A patient chooses not to participate in the Shared Digital Health Record service and informs their healthcare provider of this choice.
* A patient has one or more confidential records, held at their healthcare provider, that are withheld from the service.
* A patient has previously withheld records but has now released them to the Shared Digital Health Record service.
For example payloads that might be used with this operation see:* [Parameters resource for total non-participation](./Parameters-ParametersDoNotParticipate.md) : This example shows how to indicate that a patient does not wish to participate in the Shared Digital Health Record service (has opted out).
* [Parameters resource for participation](./Parameters-ParametersParticipate.md) : This example shows how to indicate that a patient wishes to participate in the Shared Digital Health Record service, where previously opted out (opt-in).
* [Parameters resource for partial participation with withheld records](./Parameters-ParametersParticipateRecordWithheld.md) : This example shows how to indicate that a patient has some confidential records that are withheld from the Shared Digital Health Record service.
* [Parameters resource for releasing withheld records](./Parameters-ParametersParticipateRecordReleased.md) : This example shows how to indicate that a patient has previously withheld records but has now released them to the Shared Digital Health Record service.
To make a request to this operation the API Consumer must POST a`Parameters`payload to the operation URL (e.g.`POST https://api.sdhr.digital.health.nz/s2s/$participate`).The operation is idempotent, meaning that multiple requests with the same parameters will have the same effect as a single request. The operation is expected to be called by a healthcare provider on behalf of the patient, and the patient must be identified by their NHI. The operation will return an OperationOutcome resource indicating the result of the operation. |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [condition-highlighted](SearchParameter-condition-highlighted.md) | Search for conditions flagged as highlighted in the SDHRCondition profile |
| [condition-long-term-condition](SearchParameter-condition-long-term-condition.md) | Search for conditions marked as long term in the SDHRCondition profile |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Batch Bundle with a Single Patient](StructureDefinition-SDHRBatchBundle.md) | SDHR allows Bundle posts with the following restrictions:* The Bundle type must be `batch` (transactions are not supported).
* All Patient references in the Bundle must target a single Patient.
* The Bundle must not contain any $participate or $hnz-participate requests.
 |
| [SDHRAllergyIntolerance](StructureDefinition-SDHRAllergyIntolerance.md) | AllergyIntolerance FHIR resource for Shared Digital Health Record |
| [SDHRCondition](StructureDefinition-SDHRCondition.md) | Condition resource to record problems and conditions affecting a person |
| [SDHRConsent](StructureDefinition-SDHRConsent.md) | Consent resource created to reflect a patient's preferences with regard to sharing their information with authorised health workers via the shared digital health record service. Note that this is a protected resource and scopes required to manage this resource are not provisioned to most API consumers. A patient's participation preferences should be managed by the[Participate Operation](./OperationDefinition-SDHRParticipateOperation.md). For more details on the participate operation see[SDHR Custom Operations](./api.md#sdhr-custom-operations). |
| [SDHRObservation](StructureDefinition-SDHRObservation.md) | A Shared Digital Health Record Observation. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Client Last Updated](StructureDefinition-hnz-sdhr-client-last-updated-extension.md) | Extension to record the last time a resource was updated by the source system. When consuming applications are writing data to the SDHR API they can use this extension to record the`LastUpdated`timestamp in their system |
| [Facility Participation](StructureDefinition-facility-participation-extension.md) | Indicates whether the patient has opted out or opted in to participation at the facility. If opted out, no records will be shared from that facility. |
| [HNZ SDHR Highlighted](StructureDefinition-hnz-sdhr-highlighted-extension.md) | Extension to indicate that a resource should be highlighted in the user interface. This is used to indicate that the resource is important and should be highlighted in a user interface. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [ValueSet for AllergyIntolerance Code](ValueSet-sdhr-allergyintolerance-code-valueset.md) | A ValueSet containing all codes from the AllergyIntolerance Code system. |
| [ValueSet for AllergyIntolerance Manifestation](ValueSet-sdhr-allergyintolerance-manifestation-valueset.md) | A ValueSet containing all codes from the AllergyIntolerance Manifestation system. |
| [ValueSet for AllergyIntolerance Severity](ValueSet-sdhr-allergyintolerance-severity-valueset.md) | A ValueSet containing all codes from the AllergyIntolerance Severity system. |
| [ValueSet for SDHR Participation Reason](ValueSet-sdhr-participation-reason-valueset.md) | A ValueSet containing all codes from the SDHR Participation Reason system. |
| [ValueSet for SDHR Resource Tags](ValueSet-sdhr-resource-tags-valueset.md) | A ValueSet containing all codes from the SDHR Resource Tags system. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [NZ-specific terminology for Shared Digital Health Records](CodeSystem-nz-sdhr-codesystem.md) | This system defines standard codes used throughout this Implementation Guide for New Zealand Shared Digital Health Records |
| [SDHR Codes where the appropriate code is not known or can not be determined.](CodeSystem-sdhr-other-codes.md) | This code system is used when the appropriate code is not known or can not be determined. |
| [SDHR Participation Reason Codes](CodeSystem-sdhr-participation-reason.md) | This code system defines the reasons for a patient to participate in the Shared Digital Health Record service. |
| [SDHR Specific Outcome Codes](CodeSystem-sdhr-outcome-codes.md) | This code system defines standard OperationOucome codes used throughout this Implementation Guide for New Zealand Shared Digital Health Records |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [APIError-Confidential](OperationOutcome-APIError-Confidential.md) | Example OperationOutcome API response, returned when a resource has been flagged as confidential, and so cannot be accessed. |
| [APIError-Unauthorised](OperationOutcome-APIError-Unauthorised.md) | Access to Shared Digital Health Records is**restricted**.<br> This API validates information that is provided by the API Consumer in their`Request-Context`header. The API Consumer must also provide an appropriate OAuth 2.0 Bearer token in the`Authorization`header containing scopes appropriate for the resource being accessed. The API Consumer must be registered with the Shared Digital Health Record API. |
| [AllergyIntoleranceExample](AllergyIntolerance-AllergyIntoleranceExample.md) | An example payload for a Primary Care AllergyIntolerance resource indicating an allergy to Penicillin, with a confidentiality of restricted. |
| [AllergyIntoleranceExample2](AllergyIntolerance-AllergyIntoleranceExample2.md) | An example payload for a Primary Care AllergyIntolerance resource indicating an allergy to Cashew nuts |
| [Batch-example](Bundle-Batch-example.md) |  |
| [ConditionHypertensionExample](Condition-ConditionHypertensionExample.md) | Example Hypertension Condition |
| [ConditionRespiratoryExample](Condition-ConditionRespiratoryExample.md) | Example Respiratory Condition |
| [ConsentExample](Consent-ConsentExample.md) | Consent example submitted to allow a patient to opt in to sharing their information, originating from a practice management system |
| [ConsentExampleRecordsWithheld](Consent-ConsentExampleRecordsWithheld.md) | Consent example to allow a patient to opt in to sharing their information, while withholding some records from the service |
| [ConsentFacilityDenyExample](Consent-ConsentFacilityDenyExample.md) | Consent example submitted to allow a patient to opt out of sharing their information. This example shows a Consent resource created as the result of an HNZ opt out. |
| [ConsentHNZDenyExample](Consent-ConsentHNZDenyExample.md) | Consent example submitted to allow a patient to opt out of sharing their information. This example shows a Consent resource created as the result of an HNZ opt out. |
| [ConsentMultiFacilityExample](Consent-ConsentMultiFacilityExample.md) | Consent example illustrating a patient stating participation preferences forsharing their information with SDHR at multiple facilities. |
| [ObservationVitalSignsExample](Observation-ObservationVitalSignsExample.md) | An example SDHR Vital Signs Observation |
| [OperationOutcomeFacilityDenyExample](OperationOutcome-OperationOutcomeFacilityDenyExample.md) | Example OperationOutcome for a request where the patient has opted out of participating in the shared digital health record service for a specific facility. |
| [OperationOutcomeFacilityLocked](OperationOutcome-OperationOutcomeFacilityLocked.md) | This outcome message will be returned in a special case where a facility has been`locked`due to a background load process where the SDHR service is performing a historic record load for a practice. A typical scenario where this would occur would be where a practice has 'onboarded' to the SDHR service and SDHR is sourcing historic records for consented patients. If a data holder receives this outcome when loading records they should queue the failed records and retry after a delay. |
| [OperationOutcomeFacilityUnknown](OperationOutcome-OperationOutcomeFacilityUnknown.md) | This outcome message will be returned where a facility is not yet onboarded to SDHR. |
| [OperationOutcomeGlobalDenyExample](OperationOutcome-OperationOutcomeGlobalDenyExample.md) | Example OperationOutcome for a request where the patient has opted out of participating in the shared digital health record service. |
| [OperationOutcomeParticipateInvalidPatient](OperationOutcome-OperationOutcomeParticipateInvalidPatient.md) | Example OperationOutcome for an invalid patient participation operation indicating that the patient parameter is invalid. |
| [OperationOutcomeParticipateMissingReason](OperationOutcome-OperationOutcomeParticipateMissingReason.md) | Example OperationOutcome for a missing reason code in the Participate operation indicating that the reason for participation status is required. |
| [OperationOutcomeParticipatePreferencesNotKnown](OperationOutcome-OperationOutcomeParticipatePreferencesNotKnown.md) | Example OperationOutcome where a patient has not indicated their participation preferences for the Shared Digital Health Record service. |
| [OperationOutcomeParticipateSuccess](OperationOutcome-OperationOutcomeParticipateSuccess.md) | Example OperationOutcome for a successful participation operation indicating that the patient's participation status was successfully recorded. |
| [OperationOutcomePatientLocked](OperationOutcome-OperationOutcomePatientLocked.md) | This outcome message will be returned in a special case where a patient record has been`locked`due to a background load process where the SDHR service is performing a historic record load for a patient. A typical scenario where this would occur would be where a practice has 'onboarded' to the SDHR service and SDHR is sourcing historic records for a patient who has contented to participation. If a data holder receives this outcome when loading records they should queue the failed record(s) and retry after a delay. |
| [OperationOutcomeRateLimitExceeded](OperationOutcome-OperationOutcomeRateLimitExceeded.md) | This outcome message will be returned where an API Consumer has exceeded the allocated rate limit. |
| [OperationOutcomeRecordsWithheldAtSource](OperationOutcome-OperationOutcomeRecordsWithheldAtSource.md) | Example OperationOutcome when a patient has withheld records at source. |
| [ParametersDoNotParticipate](Parameters-ParametersDoNotParticipate.md) | Example parameters content to POST to the Participate operation where a patient does not wish to participate in the Shared Digital Health Record service. |
| [ParametersHNZParticipateOptIn](Parameters-ParametersHNZParticipateOptIn.md) | Example parameters content to POST to the HNZ Participate (`$hnz-participate`) operation where a patient elects to participate in the Shared Digital Health Record service by using an appropriate HNZ digital or assisted channel. |
| [ParametersHNZParticipateOptOut](Parameters-ParametersHNZParticipateOptOut.md) | Example parameters content to POST to the HNZ Participate (`$hnz-participate`) operation where a patient elects not to participate in the Shared Digital Health Record service by using an appropriate HNZ digital or assisted channel. |
| [ParametersParticipate](Parameters-ParametersParticipate.md) | Example parameters content to POST to the Participate operation where a patient wishes to participate in the Shared Digital Health Record service. |
| [ParametersParticipateRecordReleased](Parameters-ParametersParticipateRecordReleased.md) | Example parameters content to POST to the Participate operation where a patient has individual records that are no longer withheld. |
| [ParametersParticipateRecordWithheld](Parameters-ParametersParticipateRecordWithheld.md) | Example parameters content to POST to the Participate operation where a patient has individual records that are withheld - e.g. records marked as`Confidential`. |
| [SearchConditionResponseExample](Bundle-SearchConditionResponseExample.md) | Example of a search response for a condition search. In this case the search response returns one result using the search parameters`code`and`subject`.`GET /Condition?subject=https://api.hip.digital.health.nz/fhir/Patient/ZKC7284&amp;code=http://snomed.info/sct%7C38341003` |
| [SearchConfidentialRecordsResponseExample](Bundle-SearchConfidentialRecordsResponseExample.md) | Example of a searchset API response for an AllergyIntolerance resource search. In this case, the search response returns one entry item, with a total count of 2. This is because the API will not return the confidential record. The redacted security label is applied to the Bundle response, to indicate that confidential records have been removed from the result set. See the[API documentation](./api.md#sdhr-confidential-record-api-behaviour)for more information. |
| [SearchExactMatchRecordWithheldExample](Bundle-SearchExactMatchRecordWithheldExample.md) | Example of a searchset API response for an Condition resource search where the patient has withheld records at their PMS. In this case, the server does not have the record but the parameters supplied in the search mean we are able to uniquely match to a single record that has been withheld using the $participate operation. The search response returns zero entries`'total':0`. The response includes an entry which is an`OperationOutcome`resource indicating that records were withheld at source. This is indicated by the`search.mode`being set to`outcome`for the`OperationOutcome`entry. |
| [SearchWithRecordsWithheldExample](Bundle-SearchWithRecordsWithheldExample.md) | Example of a searchset API response for an Condition resource search where the patient has withheld records at their PMS. In this case, the search response returns one entry`'total':1`. The response also includes an entry which is an`OperationOutcome`resource indicating that some records were withheld at source. This is indicated by the`search.mode`being set to`outcome`for the`OperationOutcome`entry. |

