# API Docs - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* **API Docs**

## API Docs

# API Documentation

The SDHR API is comprised of multiple FHIR resources. This page provides technical guidance for applicaiton developers who wish to integrate their applications with the Shared Digital Health Record APIs

| | |
| :--- | :--- |
| [API Capability Statement](./CapabilityStatement-SDHRCapabilityStatement.md) | FHIR API Capability Statement. Developers should review this to understand the available API interactions and request requirements such as the Request-Context header |
| [API Artifacts](./artifacts.md) | List of FHIR Artifacts for this API |
| [OpenAPI Specification](https://fhir-ig.digital.health.nz/openapi/index.html?urls.primaryName=Shared+Digital+Health+Record+FHIR+API) | Machine readable OpenAPI specification for this API |
| [Participate Operation](./OperationDefinition-SDHRParticipateOperation.md) | Custom operation designed to capture participation information from API Consumers e.g. Patient Management Systems |

## Logical View

## API Search Behaviour

The Shared Digital Health Record FHIR API supports the [FHIR search pattern](https://hl7.org/fhir/R4B/search.html).

You can see the supported search parameters for this API in the [API Capability Statement](./CapabilityStatement-SDHRCapabilityStatement.md#resourcesCap1)

See below for some example search queries.

### Search for Conditions by Patient and Source

This query will return all Condition resources for a given `Patient` and `meta.source`.

`GET /Condition?patient=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284&_source=https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ111-A`

### Search for Resources by Patient and Identifier

In this API `identifier` can be used to track source system unique identifiers. This should enable systems such as Patient Management Systems to track the provenance of resources. There is no limit on the number of identifiers that a resource can contain.

> Request`Condition`resources for a specific identifier`GET Condition?patient=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284&identifier=38cb6f26-9534-46e5-b659-536992faf0cc`

> Request`Condition`resources for a specific identifier AND system,`GET /Condition?patient=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284&identifier=https://some.local.system/ehr-key%7Cd2ed3bc7-da4a-45b8-ae3f-82176f5c64a4`

## SDHR Resource updates

This section describes the process of SDHR API Consumer system interacting with the SDHR FHIR server to update existing resources.

### GET before PUT

To maintain data integrity, API Consumers authorized to make updates to resources must use a "GET before PUT" approach. By always fetching the current state of a resource before attempting an update, you ensure that the modifications reflect the most accurate and recent information, without overwriting updates which may have been made by other API Consumers.

### Searching for resources before update

The SDHR API reflects the FHIR Search parameters which are documented in the [Server Capability Statement](./CapabilityStatement-SDHRCapabilityStatement.md) and well as a direct HTTP GET for a resource.

#### Case 1: The SDHR Server assigned resource ID is known by the API Consumer

In this scenario, an HTTP GET for the resource can be made to retrieve the resource: `GET /Condition/{serverResourceId}`.

Once the update has been made, the resource can be updated in the SDHR Server by using an HTTP PUT to the resource: `PUT /Condition/{serverResourceId}`

#### Case 2: The SDHR Server assigned resource ID is unknown by the API Consumer

In this scenario, a FHIR Search must be used with search parameters available to the API Consumer, as the server resource ID cannot be used for a direct HTTP GET.

**Option 1: FHIR Search by local PMS identifier, stored as a FHIR Identifier**

To improve accuracy in this process, API Consumers who submit or update records may append an identifier known to them to the shared record. This may be a representation or a copy of a local identifier used within the local PMS system. When a local identifier is stored, a FHIR Search using an identifier search parameter can be used to retrieve a record.

**Option 2: FHIR Search using resource search parameters**

When a local identifier is not submitted to a resource, the search parameters for each resource must be used, which are documented in the [Server Capability Statement](./CapabilityStatement-SDHRCapabilityStatement.md). This will return a FHIR Bundle which may contain multiple records which must be handled by the API Consumer.

## SDHR Custom Operations

The SDHR service includes the following FHIR custom operations

### Participate Operation

This operation is designed to enable API Consumers such as PMS systems to notify the SDHR service that a patient has withheld records from the service. To call the operation a `POST` request is made to the base API with a `Parameters` payload. e.g.

### Example Participation Flows

\

### Testing the $participate Operation

Most API consumers will have a credential that can be issued a scope that enables them to call the `$participate` operation. API consumers will not have access to the `$hnz-participate` operation so we have set up some NHIs in the UAT environmentto allow you to test outcome handling when a patient has opted out globally via an HNZ channel. ALL requests using these NHIs should fail with a 403 http response and an `OperationOutcome` containing the code `sdhr-participation-status-denied`

| | |
| :--- | :--- |
| ZMW9001 | Opted out`hnzParticipationIndicator:false` |
| ZMW9009 | Opted out`hnzParticipationIndicator:false` |

## SDHR Confidential Record API behaviour

When a record is created or updated to be marked as confidential using [FHIR Security labels](https://build.fhir.org/security-labels.html), read or search operations that would return the record will result in no access to the record.

When the data sensitivity tags using the confidentiality system `http://terminology.hl7.org/CodeSystem/v3-Confidentiality` are be applied to any SDHR resource, by adding the tag in the resource `meta.security` array, the API will use the follow behaviours when the resources are subject to FHIR API Requests.

The behaviours are valid for resources containing an security label using the `http://terminology.hl7.org/CodeSystem/v3-Confidentiality` `system` and `R` (Restricted) or `V` (Very Restricted). SDHR resources which do not contain this confidentiality tag will not be subject to these behaviours.

## Sample confidential resource

#### FHIR Search example

`GET /AllergyIntolerance?patient=https%3A%2F%2Fapi.hip.digital.health.nz%2Ffhir%2Fnhi%2Fv1%2FPatient%2FZKC7284`

Response status: `200`

Response body:

In this request example, a request is made to return AllergyIntolerance resources for a patient using FHIR Search. As a confidential resource was matched with this search, the search result set has been redacted due to confidentiality tags on the resource, resulting in the `meta.security` `REDACTED` tag being added to the search result `Bundle`. This indicates to the API Consumer that some portion of the searchset has been filtered due to confidentiality and not included in the content returned. The `total` within the response reflects the total of resources before filtering occurs.

#### FHIR Search Example Where Matched Records Are Withheld

In the following search the parameters below are supplied

*  

| | |
| :--- | :--- |
| `patient` | [https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC4633](https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC4633) |

 
*  

| | |
| :--- | :--- |
| `source` | [https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ111-A](https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ111-A) |

 
*  

| | |
| :--- | :--- |
| `identifier` | 6b8a6cc1-612f-456e-89df-9fbcd753acb2 |

 

`GET /Condition?patient=https%3A%2F%2Fapi.hip.digital.health.nz%2Ffhir%2Fnhi%2Fv1%2FPatient%2FZKC4633&_source=https%3A%2F%2Fapi.hip.digital.health.nz%2Ffhir%2Fhpi%2Fv1%2FLocation%2FF38006-B&identifier=6b8a6cc1-612f-456e-89df-9fbcd753acb2`

In this example the spplied parameters are an exact match for a singe record that has been indicated as wiithheld by the source system. in this scenario the server does not have the record however it is able to uniquely match to a record that has been withheld using the [$participate operation](./OperationDefinition-SDHRParticipateOperation.md)

The search response will contain an `OperationOutcome` with `"mode":"outcome"` as below

[See example details](./Bundle-SearchExactMatchRecordWithheldExample.md)

#### FHIR read, vread example

`GET /AllergyIntolerance/{id}`

Response status: `403`

Response body:

In this example, a request is made to a single resource which contains a confidentiality flag. This returns a 403 error.

