# ValueSet for AllergyIntolerance Manifestation - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **ValueSet for AllergyIntolerance Manifestation**

## ValueSet: ValueSet for AllergyIntolerance Manifestation 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/ValueSet/sdhr-allergyintolerance-manifestation-valueset | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:SDHRAllergyIntoleranceManifestationValueSet |

 
A ValueSet containing all codes from the AllergyIntolerance Manifestation system. 

 **References** 

* [SDHRAllergyIntolerance](StructureDefinition-SDHRAllergyIntolerance.md)

### Logical Definition (CLD)

* Include codes from[`http://snomed.info/sct`](http://www.snomed.org/)version Not Stated (use latest from terminology server) where concept is-a 281647001 (Adverse reactions)

 

### Expansion

Expansion from tx.fhir.org based on SNOMED CT International edition 01-Feb 2025

This value set has >1000 codes in it. In order to keep the publication size manageable, only a selection (1000 codes) of the whole set of codes is shown

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "sdhr-allergyintolerance-manifestation-valueset",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/ValueSet/sdhr-allergyintolerance-manifestation-valueset",
  "version" : "1.0.0",
  "name" : "SDHRAllergyIntoleranceManifestationValueSet",
  "title" : "ValueSet for AllergyIntolerance Manifestation",
  "status" : "active",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A ValueSet containing all codes from the AllergyIntolerance Manifestation system.",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "281647001"
          }
        ]
      }
    ]
  }
}

```
