# ValueSet for AllergyIntolerance Code - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **ValueSet for AllergyIntolerance Code**

## ValueSet: ValueSet for AllergyIntolerance Code 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/ValueSet/sdhr-allergyintolerance-code-valueset | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:SDHRAllergyIntoleranceCodeValueSet |

 
A ValueSet containing all codes from the AllergyIntolerance Code system. 

 **References** 

* [SDHRAllergyIntolerance](StructureDefinition-SDHRAllergyIntolerance.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Import all the codes that are contained in [AllergyIntolerance Substance/Product, Condition and Negation Codes](http://hl7.org/fhir/R4/valueset-allergyintolerance-code.html)
* Include all codes defined in `https://standards.digital.health.nz/ns/nzmt-type-code`version Not Stated (use latest from terminology server)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "sdhr-allergyintolerance-code-valueset",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/ValueSet/sdhr-allergyintolerance-code-valueset",
  "version" : "1.0.0",
  "name" : "SDHRAllergyIntoleranceCodeValueSet",
  "title" : "ValueSet for AllergyIntolerance Code",
  "status" : "active",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A ValueSet containing all codes from the AllergyIntolerance Code system.",
  "compose" : {
    "include" : [
      {
        "valueSet" : ["http://hl7.org/fhir/ValueSet/allergyintolerance-code"]
      },
      {
        "system" : "https://standards.digital.health.nz/ns/nzmt-type-code"
      }
    ]
  }
}

```
