# SDHRObservation - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **SDHRObservation**

## Resource Profile: SDHRObservation 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRObservation | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:SDHRObservation |

 
A Shared Digital Health Record Observation. 

**Usages:**

* Examples for this Profile: [Observation/ObservationVitalSignsExample](Observation-ObservationVitalSignsExample.md)
* CapabilityStatements using this Profile: [NZ Shared Digital Health Record API](CapabilityStatement-SDHRCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tewhatuora.fhir.nz-shared-digital-health-record|current/StructureDefinition/SDHRObservation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SDHRObservation.csv), [Excel](StructureDefinition-SDHRObservation.xlsx), [Schematron](StructureDefinition-SDHRObservation.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDHRObservation",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRObservation",
  "version" : "1.0.0",
  "name" : "SDHRObservation",
  "status" : "active",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A Shared Digital Health Record Observation.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.meta",
        "path" : "Observation.meta",
        "min" : 1
      },
      {
        "id" : "Observation.meta.source",
        "path" : "Observation.meta.source",
        "short" : "Captures the source of the record - please see description for details",
        "definition" : "Captures the source of the record. This must contain the HPIFacilityID\n                            e.g. https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ111-A",
        "min" : 1,
        "constraint" : [
          {
            "key" : "hpi-location-url-format",
            "severity" : "error",
            "human" : "Reference must be an HPI Location URL with format https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ111-A",
            "expression" : "matches('^https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F[A-Za-z0-9]{2}[0-9]{3}-[A-Za-z0-9]$')",
            "source" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRObservation"
          }
        ]
      },
      {
        "id" : "Observation.meta.profile",
        "path" : "Observation.meta.profile",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.meta.tag",
        "path" : "Observation.meta.tag",
        "short" : "Tag the resource with a code to indicate usability components of the resource",
        "definition" : "Tag the resource with a code to indicate usability components of the resource. This is used to indicate that the resource is important and, for example, should be highlighted in a user interface.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://fhir-ig.digital.health.nz/sdhr/ValueSet/sdhr-resource-tags-valueset"
        }
      },
      {
        "id" : "Observation.contained",
        "path" : "Observation.contained",
        "max" : "0"
      },
      {
        "id" : "Observation.extension",
        "path" : "Observation.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.extension:ClientLastUpdated",
        "path" : "Observation.extension",
        "sliceName" : "ClientLastUpdated",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-client-last-updated-extension"
            ]
          }
        ]
      },
      {
        "id" : "Observation.modifierExtension",
        "path" : "Observation.modifierExtension",
        "max" : "0"
      },
      {
        "id" : "Observation.identifier",
        "path" : "Observation.identifier",
        "short" : "A local identifier MUST be added to this section. If used, system MUST be specified.",
        "definition" : "A local identifier MUST be added to this section. This can be used to correlate the SDHR resource with a local system identifier to perform updates.",
        "min" : 1
      },
      {
        "id" : "Observation.identifier.use",
        "path" : "Observation.identifier.use",
        "short" : "The local identifier use SHOULD be set to secondary, where the SDHR resource id is considered the primary identifier."
      },
      {
        "id" : "Observation.identifier.system",
        "path" : "Observation.identifier.system",
        "short" : "System for the local identifier. This MUST be consistent per PMS/Health Application",
        "min" : 1,
        "example" : [
          {
            "label" : "Local Identifier System",
            "valueUri" : "https://fhir.example.co.nz"
          }
        ]
      },
      {
        "id" : "Observation.identifier.value",
        "path" : "Observation.identifier.value",
        "short" : "The actual local identifier value, e.g. ec2d6cad-1e19-46ee-accf-dc460a680710",
        "min" : 1,
        "example" : [
          {
            "label" : "Local Identifier Value",
            "valueString" : "ec2d6cad-1e19-46ee-accf-dc460a680710"
          }
        ]
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "Observation code. Note that when the observation is an individual observation (singular) LOINC should be used. If, however, the Observation is a grouping (e.g. vital-signs) the code can be from SNOMED CT e.g. `122869004`. See https://fhir-ig.digital.health.nz/sdhr/Observation-ObservationVitalSignsExample.html for example",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-codes"
        }
      },
      {
        "id" : "Observation.code.coding.userSelected",
        "path" : "Observation.code.coding.userSelected",
        "short" : "Indicates that the value has been selected by a system user",
        "definition" : "This field is used to maintain the code as selected by the source systems end user. For example, where a patient management system uses local codes or a non-common code set to record a substance or allergen this field indicates that the value is as selected by the system user. Some level of clinical interpretation may be required."
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Patient"]
          }
        ]
      },
      {
        "id" : "Observation.subject.reference",
        "path" : "Observation.subject.reference",
        "short" : "Must be an absolute URL reference to the patient on the NHI system. See constraints for details.",
        "min" : 1,
        "constraint" : [
          {
            "key" : "nhi-url-format",
            "severity" : "error",
            "human" : "Reference must be an NHI Patient URL with format https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZZZ1111 or ZZZ11AA",
            "expression" : "matches('^https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/[A-Z]{3}([0-9]{4}|[0-9]{2}[A-Z]{2})$')",
            "source" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRObservation"
          }
        ]
      },
      {
        "id" : "Observation.subject.type",
        "path" : "Observation.subject.type",
        "min" : 1,
        "patternUri" : "Patient"
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "min" : 1
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "short" : "Preferred - an HPI Practitioner URL with format https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/11AAAA"
      },
      {
        "id" : "Observation.component.code",
        "path" : "Observation.component.code",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-codes"
        }
      },
      {
        "id" : "Observation.component.code.coding.userSelected",
        "path" : "Observation.component.code.coding.userSelected",
        "short" : "Indicates that the value has been selected by a system user",
        "definition" : "This field is used to maintain the code as selected by the source systems end user. For example, where a patient management system uses local codes or a non-common code set to record a substance or allergen this field indicates that the value is as selected by the system user. Some level of clinical interpretation may be required."
      }
    ]
  }
}

```
