# SDHRCondition - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **SDHRCondition**

## Resource Profile: SDHRCondition 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRCondition | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:SDHRCondition |

 
Condition resource to record problems and conditions affecting a person 

**Usages:**

* Examples for this Profile: [Condition/ConditionHypertensionExample](Condition-ConditionHypertensionExample.md) and [Condition/ConditionRespiratoryExample](Condition-ConditionRespiratoryExample.md)
* CapabilityStatements using this Profile: [NZ Shared Digital Health Record API](CapabilityStatement-SDHRCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tewhatuora.fhir.nz-shared-digital-health-record|current/StructureDefinition/SDHRCondition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SDHRCondition.csv), [Excel](StructureDefinition-SDHRCondition.xlsx), [Schematron](StructureDefinition-SDHRCondition.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDHRCondition",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRCondition",
  "version" : "1.0.0",
  "name" : "SDHRCondition",
  "status" : "active",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Condition resource to record problems and conditions affecting a person",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://hl7.org.nz/fhir/StructureDefinition/NzCondition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition",
        "path" : "Condition"
      },
      {
        "id" : "Condition.meta",
        "path" : "Condition.meta",
        "min" : 1
      },
      {
        "id" : "Condition.meta.source",
        "path" : "Condition.meta.source",
        "short" : "Captures the source of the record - please see description for details",
        "definition" : "Captures the source of the record. This must contain the HPIFacilityID\n                            e.g. https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ111-A",
        "min" : 1,
        "constraint" : [
          {
            "key" : "hpi-location-url-format",
            "severity" : "error",
            "human" : "Reference must be an HPI Location URL with format https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ111-A",
            "expression" : "matches('^https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F[A-Za-z0-9]{2}[0-9]{3}-[A-Za-z0-9]$')",
            "source" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRCondition"
          }
        ]
      },
      {
        "id" : "Condition.meta.profile",
        "path" : "Condition.meta.profile",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Condition.meta.tag",
        "path" : "Condition.meta.tag",
        "short" : "Tag the resource with a code to indicate usability components of the resource",
        "definition" : "Tag the resource with a code to indicate usability components of the resource. This is used to indicate that the resource is important and, for example, should be highlighted in a user interface.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://fhir-ig.digital.health.nz/sdhr/ValueSet/sdhr-resource-tags-valueset"
        }
      },
      {
        "id" : "Condition.contained",
        "path" : "Condition.contained",
        "max" : "0"
      },
      {
        "id" : "Condition.extension:ClientLastUpdated",
        "path" : "Condition.extension",
        "sliceName" : "ClientLastUpdated",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-client-last-updated-extension"
            ]
          }
        ]
      },
      {
        "id" : "Condition.extension:Highlighted",
        "path" : "Condition.extension",
        "sliceName" : "Highlighted",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-highlighted-extension"
            ]
          }
        ]
      },
      {
        "id" : "Condition.modifierExtension",
        "path" : "Condition.modifierExtension",
        "max" : "0"
      },
      {
        "id" : "Condition.identifier",
        "path" : "Condition.identifier",
        "short" : "A local identifier MUST be added to this section. If used, system MUST be specified.",
        "definition" : "A local identifier MUST be added to this section. This can be used to correlate the SDHR resource with a local system identifier to perform updates.",
        "min" : 1
      },
      {
        "id" : "Condition.identifier.use",
        "path" : "Condition.identifier.use",
        "short" : "The local identifier use SHOULD be set to secondary, where the SDHR resource id is considered the primary identifier."
      },
      {
        "id" : "Condition.identifier.system",
        "path" : "Condition.identifier.system",
        "short" : "System for the local identifier. This MUST be consistent per PMS/Health Application",
        "min" : 1,
        "example" : [
          {
            "label" : "Local Identifier System",
            "valueUri" : "https://fhir.example.co.nz"
          }
        ]
      },
      {
        "id" : "Condition.identifier.value",
        "path" : "Condition.identifier.value",
        "short" : "The actual local identifier value, e.g. ec2d6cad-1e19-46ee-accf-dc460a680710",
        "min" : 1,
        "example" : [
          {
            "label" : "Local Identifier Value",
            "valueString" : "ec2d6cad-1e19-46ee-accf-dc460a680710"
          }
        ]
      },
      {
        "id" : "Condition.code",
        "path" : "Condition.code",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-code"
        }
      },
      {
        "id" : "Condition.code.coding.userSelected",
        "path" : "Condition.code.coding.userSelected",
        "short" : "Indicates that the value has been selected by a system user",
        "definition" : "This field is used to maintain the code as selected by the source systems end user. For example, where a patient management system uses local codes or a non-common code set to record a substance or allergen this field indicates that the value is as selected by the system user. Some level of clinical interpretation may be required."
      },
      {
        "id" : "Condition.subject",
        "path" : "Condition.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Patient"]
          }
        ]
      },
      {
        "id" : "Condition.subject.reference",
        "path" : "Condition.subject.reference",
        "short" : "Must be an absolute URL reference to the patient on the NHI system. See constraints for details.",
        "min" : 1,
        "constraint" : [
          {
            "key" : "nhi-url-format",
            "severity" : "error",
            "human" : "Reference must be an NHI Patient URL with format https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZZZ1111 or ZZZ11AA",
            "expression" : "matches('^https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/[A-Z]{3}([0-9]{4}|[0-9]{2}[A-Z]{2})$')",
            "source" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRCondition"
          }
        ]
      },
      {
        "id" : "Condition.subject.type",
        "path" : "Condition.subject.type",
        "min" : 1,
        "patternUri" : "Patient"
      },
      {
        "id" : "Condition.onset[x]",
        "path" : "Condition.onset[x]",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Condition.recorder",
        "path" : "Condition.recorder",
        "short" : "Preferred - an HPI Practitioner URL with format https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/11AAAA"
      },
      {
        "id" : "Condition.asserter",
        "path" : "Condition.asserter",
        "short" : "Preferred - an HPI Practitioner URL with format https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/11AAAA"
      }
    ]
  }
}

```
