# SDHRAllergyIntolerance - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **SDHRAllergyIntolerance**

## Resource Profile: SDHRAllergyIntolerance 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRAllergyIntolerance | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:SDHRAllergyIntolerance |

 
AllergyIntolerance FHIR resource for Shared Digital Health Record 

**Usages:**

* Examples for this Profile: [AllergyIntolerance/AllergyIntoleranceExample](AllergyIntolerance-AllergyIntoleranceExample.md) and [AllergyIntolerance/AllergyIntoleranceExample2](AllergyIntolerance-AllergyIntoleranceExample2.md)
* CapabilityStatements using this Profile: [NZ Shared Digital Health Record API](CapabilityStatement-SDHRCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tewhatuora.fhir.nz-shared-digital-health-record|current/StructureDefinition/SDHRAllergyIntolerance)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SDHRAllergyIntolerance.csv), [Excel](StructureDefinition-SDHRAllergyIntolerance.xlsx), [Schematron](StructureDefinition-SDHRAllergyIntolerance.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDHRAllergyIntolerance",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRAllergyIntolerance",
  "version" : "1.0.0",
  "name" : "SDHRAllergyIntolerance",
  "status" : "active",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "AllergyIntolerance FHIR resource for Shared Digital Health Record",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AllergyIntolerance",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/AllergyIntolerance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AllergyIntolerance",
        "path" : "AllergyIntolerance",
        "constraint" : [
          {
            "key" : "code-or-note-required",
            "severity" : "error",
            "human" : "The AllergyIntolerance resource must have at least one of 'code' or 'note'.",
            "expression" : "(code.exists() or note.exists())",
            "source" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRAllergyIntolerance"
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.meta",
        "path" : "AllergyIntolerance.meta",
        "min" : 1
      },
      {
        "id" : "AllergyIntolerance.meta.source",
        "path" : "AllergyIntolerance.meta.source",
        "short" : "Captures the source of the record - please see description for details",
        "definition" : "Captures the source of the record. This must contain the HPIFacilityID\n                            e.g. https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ111-A",
        "min" : 1,
        "constraint" : [
          {
            "key" : "hpi-location-url-format",
            "severity" : "error",
            "human" : "Reference must be an HPI Location URL with format https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ111-A",
            "expression" : "matches('^https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F[A-Za-z0-9]{2}[0-9]{3}-[A-Za-z0-9]$')",
            "source" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRAllergyIntolerance"
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.meta.profile",
        "path" : "AllergyIntolerance.meta.profile",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "AllergyIntolerance.meta.tag",
        "path" : "AllergyIntolerance.meta.tag",
        "short" : "Tag the resource with a code to indicate usability components of the resource",
        "definition" : "Tag the resource with a code to indicate usability components of the resource. This is used to indicate that the resource is important and, for example, should be highlighted in a user interface.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://fhir-ig.digital.health.nz/sdhr/ValueSet/sdhr-resource-tags-valueset"
        }
      },
      {
        "id" : "AllergyIntolerance.implicitRules",
        "path" : "AllergyIntolerance.implicitRules",
        "max" : "0"
      },
      {
        "id" : "AllergyIntolerance.language",
        "path" : "AllergyIntolerance.language",
        "max" : "0"
      },
      {
        "id" : "AllergyIntolerance.contained",
        "path" : "AllergyIntolerance.contained",
        "max" : "0"
      },
      {
        "id" : "AllergyIntolerance.extension",
        "path" : "AllergyIntolerance.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "AllergyIntolerance.extension:ClientLastUpdated",
        "path" : "AllergyIntolerance.extension",
        "sliceName" : "ClientLastUpdated",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-client-last-updated-extension"
            ]
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.modifierExtension",
        "path" : "AllergyIntolerance.modifierExtension",
        "max" : "0"
      },
      {
        "id" : "AllergyIntolerance.identifier",
        "path" : "AllergyIntolerance.identifier",
        "short" : "A local identifier MUST be added to this section. If used, system MUST be specified.",
        "definition" : "A local identifier MUST be added to this section. This can be used to correlate the SDHR resource with a local system identifier to perform updates.",
        "min" : 1
      },
      {
        "id" : "AllergyIntolerance.identifier.use",
        "path" : "AllergyIntolerance.identifier.use",
        "short" : "The local identifier use SHOULD be set to secondary, where the SDHR resource id is considered the primary identifier."
      },
      {
        "id" : "AllergyIntolerance.identifier.system",
        "path" : "AllergyIntolerance.identifier.system",
        "short" : "System for the local identifier. This MUST be consistent per PMS/Health Application",
        "min" : 1,
        "example" : [
          {
            "label" : "Local Identifier System",
            "valueUri" : "https://fhir.example.co.nz"
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.identifier.value",
        "path" : "AllergyIntolerance.identifier.value",
        "short" : "The actual local identifier value, e.g. ec2d6cad-1e19-46ee-accf-dc460a680710",
        "min" : 1,
        "example" : [
          {
            "label" : "Local Identifier Value",
            "valueString" : "ec2d6cad-1e19-46ee-accf-dc460a680710"
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.code",
        "path" : "AllergyIntolerance.code",
        "short" : "Preferred - a SNOMED CT code or a NZMT code. When the intolerance is referring to a medication please use the NZMT codeset. When referring to another supstance, food etc. please use SNOMED.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://fhir-ig.digital.health.nz/sdhr/ValueSet/sdhr-allergyintolerance-code-valueset"
        }
      },
      {
        "id" : "AllergyIntolerance.code.coding.userSelected",
        "path" : "AllergyIntolerance.code.coding.userSelected",
        "short" : "Indicates that the value has been selected by a system user",
        "definition" : "This field is used to maintain the code as selected by the source systems end user. For example, where a patient management system uses local codes or a non-common code set to record a substance or allergen this field indicates that the value is as selected by the system user. Some level of clinical interpretation may be required."
      },
      {
        "id" : "AllergyIntolerance.patient.reference",
        "path" : "AllergyIntolerance.patient.reference",
        "short" : "Must be an absolute URL reference to the patient on the NHI system. See constraints for details.",
        "min" : 1,
        "constraint" : [
          {
            "key" : "nhi-url-format",
            "severity" : "error",
            "human" : "Reference must be an NHI Patient URL with format https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZZZ1111 or ZZZ11AA",
            "expression" : "matches('^https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/[A-Z]{3}([0-9]{4}|[0-9]{2}[A-Z]{2})$')",
            "source" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRAllergyIntolerance"
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.patient.type",
        "path" : "AllergyIntolerance.patient.type",
        "min" : 1,
        "patternUri" : "Patient"
      },
      {
        "id" : "AllergyIntolerance.recorder",
        "path" : "AllergyIntolerance.recorder",
        "short" : "Preferred - an HPI Practitioner URL with format https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/11AAAA"
      },
      {
        "id" : "AllergyIntolerance.asserter",
        "path" : "AllergyIntolerance.asserter",
        "short" : "Preferred - an HPI Practitioner URL with format https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/11AAAA"
      },
      {
        "id" : "AllergyIntolerance.reaction.manifestation",
        "path" : "AllergyIntolerance.reaction.manifestation",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://fhir-ig.digital.health.nz/sdhr/ValueSet/sdhr-allergyintolerance-manifestation-valueset"
        }
      }
    ]
  }
}

```
