# NZ Shared Digital Health Record API - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **NZ Shared Digital Health Record API**

## CapabilityStatement: NZ Shared Digital Health Record API 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/CapabilityStatement/SDHRCapabilityStatement | *Version*:1.0.0 |
| Draft as of 2024-04-15 | *Computable Name*:SDHRCapabilityStatement |

 
NZ Shared Digital Health Record API Capability Statement 

 [Raw OpenAPI-Swagger Definition file](SDHRCapabilityStatement.openapi.json) | [Download](SDHRCapabilityStatement.openapi.json) 

Profile: [Capability Statement profile for use with the Health New Zealand Te Whatu Ora OpenAPI spec converter](file:///home/runner/work/fhir-ig-builder/fhir-ig-builder/hnz-digital-tooling/output/StructureDefinition-hnz-capability-statement.html)

## NZ Shared Digital Health Record API

* Implementation Guide Version: 1.0.0 
* FHIR Version: 4.0.1 
* Supported Formats: `application/fhir+json`
* Published on: 2024-04-15 01:15:23+0000 
* Published by: Health New Zealand 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

## FHIR RESTful Capabilities

### Mode: server

### Request-Context custom header

All FHIR API requests MUST include the HNZ request context **custom header** which supplies identifiers for the health user and organisation, or system behind the API request.

This context is supplied using the 'Request-Context' custom HTTP header in the form of a base64-encoded JSON object. The value of the header has differing forms based on the type of request being made, namely whether it is in a user context (e.g. a clinical user searching for patient records), or a system context (e.g. a system submitting data to the API in a bulk load scenario).

#### Requests with user context

| | | |
| :--- | :--- | :--- |
| `userIdentifier` | Yes | The userid of the user as authenticated by the PMS/health application |
| `secondaryIdentifier` | Yes | The secondary identifier for the user - this**MUST**be the end users Common Person Number (aka HPI Practitioner identifier) of the practitioner using the application where available. Otherwise, any secondary identifier that is held for the user |
| `purposeOfUse` | Yes | One of [ "PATRQT", "POPHLTH", "TREAT", "ETREAT", "PUBHLTH", "RECORDMGT" ]. For descriptions of the values, see[Audit Events](https://fhir-ig.digital.health.nz/auditevents/ValueSet-purposeofuse.html) |
| `userFullName` | Yes | Full name of the user of the PMS/health application. |
| `userRole` | Yes | Role of the user of the PMS/health application. Set to`"PROV"`(Provider) or`"PAT"`(Patient) |
| `orgIdentifier` | Yes | The HPI Organisation Number (aka HPI Organisation identifier) for the organisation in which the API consumer application is deployed |
| `facilityIdentifier` | Yes | The HPI Facility identifier for the facility where the record is being sourced / accessed. |

#### Requests with system context

| | | |
| :--- | :--- | :--- |
| `userIdentifier` | Yes | The oAuth clientId of the system submitting data to the API |
| `purposeOfUse` | Yes | [ "RECORDMGT" ]. For descriptions of the values, see[Audit Events](https://fhir-ig.digital.health.nz/auditevents/ValueSet-purposeofuse.html) |
| `userFullName` | Yes | Name of the PMS/health application. |
| `userRole` | Yes | Role of the PMS/health application. Set to`"110150"`(Application) |
| `orgIdentifier` | Yes | The HPI Organisation Number (aka HPI Organisation identifier) for the organisation in which the API consumer application is deployed |
| `facilityIdentifier` | Yes | HPI identifier for the facility where the user is located |

A schema definition and examples for `Request-Context` can be [found here](https://github.com/tewhatuora/schemas/blob/main/json-schema/Request-Context.json)

#### Example Request-Context Header Payload for a clinical user searching for a patient's Conditions

**Base64 Encoded**

```
ewogICJ1c2VySWRlbnRpZmllciI6ICJwbXMtaWQtMTIzIiwKICAidXNlclJvbGUiOiAiUFJPViIsCiAgInNlY29uZGFyeUlkZW50aWZpZXIiOiB7CiAgICAidXNlIjogIm9mZmljaWFsIiwKICAgICJzeXN0ZW0iOiAiaHR0cHM6Ly9zdGFuZGFyZHMuZGlnaXRhbC5oZWFsdGgubnovbnMvaHBpLXBlcnNvbi1pZCIsCiAgICAidmFsdWUiOiAiOTlaWlpTIgogIH0sCiAgInB1cnBvc2VPZlVzZSI6IFsKICAgICJQT1BITFRIIgogIF0sCiAgInVzZXJGdWxsTmFtZSI6ICJCZXZlcmx5IENydXNoZXIiLAogICJvcmdJZGVudGlmaWVyIjogIkcwMDAwMS1HIiwKICAiZmFjaWxpdHlJZGVudGlmaWVyIjogIkZaWjk5OS1CIgp9

```

**Decoded JSON**

```
{
  "userIdentifier": "pms-id-123",
  "userRole": "PROV",
  "secondaryIdentifier": {
    "use": "official",
    "system": "https://standards.digital.health.nz/ns/hpi-person-id",
    "value": "99ZZZS"
  },
  "purposeOfUse": [
    "POPHLTH"
  ],
  "userFullName": "Beverly Crusher",
  "orgIdentifier": "G00001-G",
  "facilityIdentifier": "FZZ999-B"
}

```

#### Example Request-Context Header Payload for a system submitting data to the API, where there is no end user

**Base64 Encoded**

```
ewogICAgInVzZXJJZGVudGlmaWVyIjogIjFiODIwMGQ3LTNhOGMtNGZiNi04ZTVjLWNlYzQ1NDA5OTlkNSIsCiAgICAidXNlclJvbGUiOiAiMTEwMTUwIiwKICAgICJwdXJwb3NlT2ZVc2UiOiBbCiAgICAgICAgIlJFQ09SRE1HVCIKICAgIF0sCiAgICAidXNlckZ1bGxOYW1lIjogIlNhbXBsZSBQTVMgSW50ZWdyYXRpb24gQXBwbGljYXRpb24iLAogICAgIm9yZ0lkZW50aWZpZXIiOiAiRzAwMDAxLUciLAogICAgImZhY2lsaXR5SWRlbnRpZmllciI6ICJGWlo5OTktQiIKfQ==

```

**Decoded JSON**

```
{
    "userIdentifier": "1b8200d7-3a8c-4fb6-8e5c-cec4540999d5",
    "userRole": "110150",
    "purposeOfUse": [
        "RECORDMGT"
    ],
    "userFullName": "Sample PMS Integration Application",
    "orgIdentifier": "G00001-G",
    "facilityIdentifier": "FZZ999-B"
}

```

### Mandatory search parameters

All FHIR API search requests must include the HNZ mandatory search parameters. These are listed in the Combined Search Parameters section of each resource below.

### Error status codes

#### Read (GET) Operation Statuses

| | | |
| :--- | :--- | :--- |
| 200 | OK | The request was successful, and the response body contains the representation requested |
| 302 | FOUND | A common redirect response; you can GET the representation at the URI in the Location response header |
| 304 | NOT MODIFIED | Your client's cached version of the representation is still up to date |
| 400 | BAD REQUEST | Missing or bad`Request-Context`custom header; FHIR request payload does not validate against Implementation Guide |
| 401 | UNAUTHORIZED | The supplied credentials, if any, are not sufficient to access the resource |
| 403 | FORBIDDEN | Insufficient privilege to access the requested FHIR resource/operation |
| 404 | NOT FOUND | The requested representation was not found. Retrying this request is unlikely to be successful |
| 429 | TOO MANY REQUESTS | Your application is sending too many simultaneous requests |
| 500 | SERVER ERROR | An internal server error prevented return of the representation response |
| 503 | SERVICE UNAVAILABLE | We are temporarily unable to return the representation. Please wait and try again later |

#### Search (GET) Operation Statuses

| | | | |
| :--- | :--- | :--- | :--- |
| 200 | OK | Yes, When there are additional messages about a match result | The request was successful, and the response body contains the representation requested |
| 302 | FOUND | No | A common redirect response; you can GET the representation at the URI in the Location response header |
| 400 | BAD REQUEST | Yes | Missing or bad`Request-Context`custom header;<br>FHIR request payload does not validate against Implementation Guide |
| 401 | UNAUTHORIZED | Yes | The supplied credentials, if any, are not sufficient to access the resource |
| 403 | FORBIDDEN | Yes | Insufficient privilege to access the requested FHIR resource/operation. See[OperationOutcome-APIError-Unauthorised](./OperationOutcome-APIError-Unauthorised.md) |
| 429 | TOO MANY REQUESTS | No | Your application is sending too many simultaneous requests |
| 500 | SERVER ERROR | No | An internal server error prevented return of the representation response |
| 503 | SERVICE UNAVAILABLE | No | The server is temporarily unable to return the representation. Please wait and try again later |

#### Update or Create (POST or PUT) Operation Statuses

| | | | |
| :--- | :--- | :--- | :--- |
| 200 | OK | Yes, When there are additional messages about an operation | The request was successful, and the response body contains the representation requested |
| 201 | CREATED | No | The request was successful, and the response body contains the representation created |
| 400 | BAD REQUEST | Yes | Missing or bad`Request-Context`custom header;<br>FHIR request payload does not validate against Implementation Guide |
| 401 | UNAUTHORIZED | Yes | The supplied credentials, if any, are not sufficient to access the resource |
| 403 | FORBIDDEN | Yes | Insufficient privilege to access the requested FHIR resource/operation. See[OperationOutcome-APIError-Unauthorised](./OperationOutcome-APIError-Unauthorised.md) |
| 429 | TOO MANY REQUESTS | Yes | Your application is sending too many simultaneous requests |
| 500 | SERVER ERROR | Yes | An internal server error prevented return of the representation response |
| 503 | SERVICE UNAVAILABLE | No | The server is temporarily unable to return the representation. Please wait and try again later |

### Non existent API endpoints

When a consumer attempts to call a non-existent API end point, respond with a **501 Not Implemented** status code.

### API Rate Limits

API rate limiting is enforced on a per client basis, and the status of the rate limit is communicated via the following HTTP response headers:

| | |
| :--- | :--- |
| x-ratelimit-remaining | The amount of available quota |
| x-ratelimit-limit | The maximum available requests per window |
| x-ratelimit-reset | The remaining time, in milliseconds, until a new window starts |

The API client **MUST** monitor these headers and ensure that they do not exceed the quota expressed in the `x-ratelimit-limit` header before the time window expressed in `x-ratelimit-reset`. If the rate limit is exceeded, the API will respond with a **429 Too Many Requests** status code and the [Rate Limit OperationOutcome](./OperationOutcome-OperationOutcomeRateLimitExceeded.json.md).

| | |
| :--- | :--- |
| SDHR Gold | 400 requests per second, per client |
| SDHR Silver | 50 requests per second, per client |
| SDHR Bronze | 10 requests per second, per client |

Where the rate limit is exceeded as part of normal operations, the API client can request an increased quota by contacting the SDHR service desk portal.

**Security**

Enable CORS: yes

Security services supported:
`SMART-on-FHIR`

> 

OAuth 2.0 - Client Credential flow.


**Summary of System-wide Interactions**

* Supports the `search-system`interaction.
* Supports the `transaction`interaction.
* Supports the `batch`interaction.

Summary of System-wide Operations


### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [AllergyIntolerance](#AllergyIntolerance1-1) | [https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRAllergyIntolerance](StructureDefinition-SDHRAllergyIntolerance.md) | y | y | y | y | y | patient, category, clinical-status, code, identifier, recorder, severity, _lastUpdated, patient |  |  |  |
| [Condition](#Condition1-2) | [https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRCondition](StructureDefinition-SDHRCondition.md) | y | y | y | y | y | patient, category, code, encounter, identifier, onset-date, severity, subject, highlighted, long-term-condition, _lastUpdated, patient | `Condition:encounter` |  |  |
| [Observation](#Observation1-3) | [https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRObservation](StructureDefinition-SDHRObservation.md) | y | y | y | y | y | patient, category, code, date, encounter, identifier, performer, status, subject, value-concept, value-date, value-quantity, value-string, _lastUpdated, patient |  |  |  |

-------

#### Resource Conformance: supported AllergyIntolerance

Base System Profile

[SDHRAllergyIntolerance](StructureDefinition-SDHRAllergyIntolerance.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* Supports `read`, `create`, `update`, `search-type`, `delete`.

Documentation
> 

Note that the supported interactions of the API will vary per API Consumer, depending on the consuming system's role.


Search Parameters


Combined Search Parameters


#### Resource Conformance: supported Condition

Base System Profile

[SDHRCondition](StructureDefinition-SDHRCondition.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* Supports `read`, `create`, `update`, `search-type`, `delete`.

Documentation
> 

Note that the supported interactions of the API will vary per API Consumer, depending on the consuming system's role.


Search Parameters


Combined Search Parameters


#### Resource Conformance: supported Observation

Base System Profile

[SDHRObservation](StructureDefinition-SDHRObservation.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* Supports `read`, `create`, `update`, `search-type`, `delete`.

Documentation
> 

Note that the supported interactions of the API will vary per API Consumer, depending on the consuming system's role.


Search Parameters


Combined Search Parameters




## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "SDHRCapabilityStatement",
  "meta" : {
    "profile" : [
      "https://fhir-ig.digital.health.nz/hnz-digital-tooling/StructureDefinition/hnz-capability-statement"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "licenseURL",
          "valueUri" : "https://www.tewhatuora.govt.nz/assets/Our-health-system/Digital-health/Digital-Service-Hub/API-Access-and-Use-Agreement.docx"
        },
        {
          "url" : "externalDocs",
          "valueUri" : "https://fhir-ig.digital.health.nz/sdhr"
        },
        {
          "url" : "licenseName",
          "valueString" : "Health New Zealand Digital Services Hub API Access and Use Agreement"
        },
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueString" : "X-Correlation-Id"
                },
                {
                  "url" : "value",
                  "valueUri" : "https://raw.githubusercontent.com/tewhatuora/schemas/main/shared-care/Correlation-Id.json"
                },
                {
                  "url" : "required",
                  "valueBoolean" : false
                }
              ],
              "url" : "https://fhir-ig.digital.health.nz/hnz-digital-tooling/StructureDefinition/custom-headers-extension"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueString" : "Request-Context"
                },
                {
                  "url" : "value",
                  "valueUri" : "https://raw.githubusercontent.com/tewhatuora/schemas/main/shared-care/Request-Context.json"
                },
                {
                  "url" : "required",
                  "valueBoolean" : true
                }
              ],
              "url" : "https://fhir-ig.digital.health.nz/hnz-digital-tooling/StructureDefinition/custom-headers-extension"
            }
          ],
          "url" : "globalHeaders"
        }
      ],
      "url" : "https://fhir-ig.digital.health.nz/hnz-digital-tooling/StructureDefinition/resource-metadata-extension"
    }
  ],
  "url" : "https://fhir-ig.digital.health.nz/sdhr/CapabilityStatement/SDHRCapabilityStatement",
  "version" : "1.0.0",
  "name" : "SDHRCapabilityStatement",
  "title" : "NZ Shared Digital Health Record API",
  "status" : "draft",
  "experimental" : false,
  "date" : "2024-04-15T01:15:23.3688326Z",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "NZ Shared Digital Health Record API Capability Statement",
  "kind" : "capability",
  "software" : {
    "name" : "NZ Shared Digital Health Record API",
    "version" : "1.0.0"
  },
  "implementation" : {
    "description" : "Health NZ | Te Whatu Ora NZ Shared Digital Health Record API",
    "url" : "https://api.sdhr.digital.health.nz/s2s"
  },
  "fhirVersion" : "4.0.1",
  "format" : ["application/fhir+json"],
  "rest" : [
    {
      "mode" : "server",
      "documentation" : "### Request-Context custom header\n\nAll FHIR API requests MUST include the HNZ request context *custom header* which supplies identifiers for the health user \nand organisation, or system behind the API request.\n\nThis context is supplied using the 'Request-Context' custom HTTP header in the form of a base64-encoded JSON object.\nThe value of the header has differing forms based on the type of request being made, namely whether it is in a user context (e.g. a clinical user searching for patient records), or a system context (e.g. a system submitting data to the API in a bulk load scenario).\n\n#### Requests with user context\n| **Context property**     | **Mandatory** | **Value**                                                                                                                          |\n|:-------------------------|:------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------|\n| `userIdentifier`         | Yes         | The userid of the user as authenticated by the PMS/health application                                                                                   |\n| `secondaryIdentifier`    | Yes         | The secondary identifier for the user - this **MUST** be the end users Common Person Number (aka HPI Practitioner identifier) of the practitioner using the application where available. Otherwise, any secondary identifier that is held for the user |\n| `purposeOfUse`           | Yes         | One of [ \"PATRQT\", \"POPHLTH\", \"TREAT\", \"ETREAT\", \"PUBHLTH\", \"RECORDMGT\" ]. For descriptions of the values, see [Audit Events](https://fhir-ig.digital.health.nz/auditevents/ValueSet-purposeofuse.html)                                                                                 |\n| `userFullName`           | Yes         | Full name of the user of the PMS/health application.                                                                                                     |\n| `userRole`               | Yes         | Role of the user of the PMS/health application. Set to `\"PROV\"` (Provider) or `\"PAT\"` (Patient)                                                         |\n| `orgIdentifier`          | Yes         | The HPI Organisation Number (aka HPI Organisation identifier) for the organisation in which the API consumer application is deployed                     |\n| `facilityIdentifier`     | Yes         | The HPI Facility identifier for the facility where the record is being sourced / accessed.                                                                                                |\n\n#### Requests with system context\n| **Context property**     | **Mandatory** | **Value**                                                                                                                          |\n|:-------------------------|:------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------|\n| `userIdentifier`         | Yes         | The oAuth clientId of the system submitting data to the API                                                                                   |\n| `purposeOfUse`           | Yes         | [ \"RECORDMGT\" ]. For descriptions of the values, see [Audit Events](https://fhir-ig.digital.health.nz/auditevents/ValueSet-purposeofuse.html)                                                                              |\n| `userFullName`           | Yes         | Name of the PMS/health application.                                                                                                    |\n| `userRole`               | Yes         | Role of the PMS/health application. Set to `\"110150\"` (Application)                                                 |\n| `orgIdentifier`          | Yes         | The HPI Organisation Number (aka HPI Organisation identifier) for the organisation in which the API consumer application is deployed                     |\n| `facilityIdentifier`     | Yes         | HPI identifier for the facility where the user is located                                                                                                |\n\nA schema definition and examples for `Request-Context` can be [found here](https://github.com/tewhatuora/schemas/blob/main/json-schema/Request-Context.json)\n\n#### Example Request-Context Header Payload for a clinical user searching for a patient's Conditions\n**Base64 Encoded**\n```\newogICJ1c2VySWRlbnRpZmllciI6ICJwbXMtaWQtMTIzIiwKICAidXNlclJvbGUiOiAiUFJPViIsCiAgInNlY29uZGFyeUlkZW50aWZpZXIiOiB7CiAgICAidXNlIjogIm9mZmljaWFsIiwKICAgICJzeXN0ZW0iOiAiaHR0cHM6Ly9zdGFuZGFyZHMuZGlnaXRhbC5oZWFsdGgubnovbnMvaHBpLXBlcnNvbi1pZCIsCiAgICAidmFsdWUiOiAiOTlaWlpTIgogIH0sCiAgInB1cnBvc2VPZlVzZSI6IFsKICAgICJQT1BITFRIIgogIF0sCiAgInVzZXJGdWxsTmFtZSI6ICJCZXZlcmx5IENydXNoZXIiLAogICJvcmdJZGVudGlmaWVyIjogIkcwMDAwMS1HIiwKICAiZmFjaWxpdHlJZGVudGlmaWVyIjogIkZaWjk5OS1CIgp9\n```\n**Decoded JSON**\n```json\n{\n  \"userIdentifier\": \"pms-id-123\",\n  \"userRole\": \"PROV\",\n  \"secondaryIdentifier\": {\n    \"use\": \"official\",\n    \"system\": \"https://standards.digital.health.nz/ns/hpi-person-id\",\n    \"value\": \"99ZZZS\"\n  },\n  \"purposeOfUse\": [\n    \"POPHLTH\"\n  ],\n  \"userFullName\": \"Beverly Crusher\",\n  \"orgIdentifier\": \"G00001-G\",\n  \"facilityIdentifier\": \"FZZ999-B\"\n}\n```\n  #### Example Request-Context Header Payload for a system submitting data to the API, where there is no end user\n**Base64 Encoded**\n```\newogICAgInVzZXJJZGVudGlmaWVyIjogIjFiODIwMGQ3LTNhOGMtNGZiNi04ZTVjLWNlYzQ1NDA5OTlkNSIsCiAgICAidXNlclJvbGUiOiAiMTEwMTUwIiwKICAgICJwdXJwb3NlT2ZVc2UiOiBbCiAgICAgICAgIlJFQ09SRE1HVCIKICAgIF0sCiAgICAidXNlckZ1bGxOYW1lIjogIlNhbXBsZSBQTVMgSW50ZWdyYXRpb24gQXBwbGljYXRpb24iLAogICAgIm9yZ0lkZW50aWZpZXIiOiAiRzAwMDAxLUciLAogICAgImZhY2lsaXR5SWRlbnRpZmllciI6ICJGWlo5OTktQiIKfQ==\n```\n**Decoded JSON**\n```json\n{\n    \"userIdentifier\": \"1b8200d7-3a8c-4fb6-8e5c-cec4540999d5\",\n    \"userRole\": \"110150\",\n    \"purposeOfUse\": [\n        \"RECORDMGT\"\n    ],\n    \"userFullName\": \"Sample PMS Integration Application\",\n    \"orgIdentifier\": \"G00001-G\",\n    \"facilityIdentifier\": \"FZZ999-B\"\n}\n```\n\n### Mandatory search parameters\nAll FHIR API search requests must include the HNZ mandatory search parameters. These are listed in the Combined Search Parameters section of each resource below.\n\n### Error status codes\n\n#### Read (GET) Operation Statuses\n\n|**Code**|**Meaning**|**Description**|\n|:--:|:-----------------|:--|\n|200|OK                 |The request was successful, and the response body contains the representation requested|\n|302|FOUND              |A common redirect response; you can GET the representation at the URI in the Location response header|\n|304|NOT MODIFIED       |Your client's cached version of the representation is still up to date|\n|400|BAD REQUEST        |Missing or bad `Request-Context` custom header; FHIR request payload does not validate against Implementation Guide|\n|401|UNAUTHORIZED       |The supplied credentials, if any, are not sufficient to access the resource|\n|403|FORBIDDEN          |Insufficient privilege to access the requested FHIR resource/operation|\n|404|NOT FOUND          |The requested representation was not found. Retrying this request is unlikely to be successful|\n|429|TOO MANY REQUESTS  |Your application is sending too many simultaneous requests|\n|500|SERVER ERROR       |An internal server error prevented return of the representation response|\n|503|SERVICE UNAVAILABLE|We are temporarily unable to return the representation. Please wait and try again later|\n\n#### Search (GET) Operation Statuses\n\n|**Code**|**Meaning**   |**OperationOutcome** in response?|**Description**|\n|:--:|:-----------------|:----------------------------------|:----------------------------------|\n|200|OK                 |Yes, When there are additional messages about a match result|The request was successful, and the response body contains the representation requested|\n|302|FOUND              |No |A common redirect response; you can GET the representation at the URI in the Location response header|\n|400|BAD REQUEST        |Yes|Missing or bad `Request-Context` custom header;<br>FHIR request payload does not validate against Implementation Guide|\n|401|UNAUTHORIZED       |Yes|The supplied credentials, if any, are not sufficient to access the resource|\n|403|FORBIDDEN          |Yes|Insufficient privilege to access the requested FHIR resource/operation. See [OperationOutcome-APIError-Unauthorised](./OperationOutcome-APIError-Unauthorised.html)|\n|429|TOO MANY REQUESTS  |No |Your application is sending too many simultaneous requests|\n|500|SERVER ERROR       |No |An internal server error prevented return of the representation response|\n|503|SERVICE UNAVAILABLE|No |The server is temporarily unable to return the representation. Please wait and try again later|\n\n #### Update or Create (POST or PUT) Operation Statuses\n\n|**Code**|**Meaning**   |**OperationOutcome** in response?|**Description**|\n|:--:|:-----------------|:----------------------------------|:----------------------------------|\n|200|OK                 |Yes, When there are additional messages about an operation|The request was successful, and the response body contains the representation requested|\n|201|CREATED            |No|The request was successful, and the response body contains the representation created|\n|400|BAD REQUEST        |Yes|Missing or bad `Request-Context` custom header;<br>FHIR request payload does not validate against Implementation Guide|\n|401|UNAUTHORIZED       |Yes|The supplied credentials, if any, are not sufficient to access the resource|\n|403|FORBIDDEN          |Yes|Insufficient privilege to access the requested FHIR resource/operation. See [OperationOutcome-APIError-Unauthorised](./OperationOutcome-APIError-Unauthorised.html)|\n|429|TOO MANY REQUESTS  |Yes |Your application is sending too many simultaneous requests|\n|500|SERVER ERROR       |Yes |An internal server error prevented return of the representation response|\n|503|SERVICE UNAVAILABLE|No |The server is temporarily unable to return the representation. Please wait and try again later|\n\n### Non existent API endpoints\n\nWhen a consumer attempts to call a non-existent API end point, respond\nwith a **501 Not Implemented** status code.\n\n### API Rate Limits\nAPI rate limiting is enforced on a per client basis, and the status of the rate limit is communicated via the following HTTP response headers:\n\n| **Header name**       | **Description**                                  |\n|:----------------------|:-------------------------------------------------|\n| x-ratelimit-remaining | The amount of available quota |\n| x-ratelimit-limit     | The maximum available requests per window |\n| x-ratelimit-reset     | The remaining time, in milliseconds, until a new window starts |\n\nThe API client **MUST** monitor these headers and ensure that they do not exceed the quota expressed in the `x-ratelimit-limit` header before the time window expressed in `x-ratelimit-reset`.\nIf the rate limit is exceeded, the API will respond with a **429 Too Many Requests** status code and the [Rate Limit OperationOutcome](./OperationOutcome-OperationOutcomeRateLimitExceeded.json.html).\n\n| **Usage plan**       | **Rate limits**                                  |\n|:----------------------|:-------------------------------------------------|\n| SDHR Gold | 400 requests per second, per client |\n| SDHR Silver     | 50 requests per second, per client |\n| SDHR Bronze     | 10 requests per second, per client |\n\nWhere the rate limit is exceeded as part of normal operations, the API client can request an increased quota by contacting the SDHR service desk portal.",
      "security" : {
        "extension" : [
          {
            "extension" : [
              {
                "url" : "token",
                "valueUri" : "https://ppd.auth.services.health.nz/realms/hnz-integration/protocol/openid-connect/token"
              },
              {
                "url" : "authorize",
                "valueUri" : "https://ppd.auth.services.health.nz/realms/hnz-integration/protocol/openid-connect/authorize"
              }
            ],
            "url" : "http://fhir-registry.smarthealthit.org/StructureDefinition/oauth-uris"
          },
          {
            "url" : "http://fhir-registry.smarthealthit.org/StructureDefinition/capabilities",
            "valueCode" : "client-confidential-symmetric"
          }
        ],
        "cors" : true,
        "service" : [
          {
            "coding" : [
              {
                "code" : "SMART-on-FHIR"
              }
            ]
          }
        ],
        "description" : "OAuth 2.0 - Client Credential flow."
      },
      "resource" : [
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "AllergyIntolerance",
          "profile" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRAllergyIntolerance",
          "documentation" : "Note that the supported interactions of the API will vary per API Consumer, depending on the consuming system's role.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "create"
            },
            {
              "code" : "update"
            },
            {
              "code" : "search-type"
            },
            {
              "code" : "delete"
            }
          ],
          "searchParam" : [
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "MANDATORY\n  Who the sensitivity is for \n [Patient](http://hl7.org/fhir/R4/patient.html)"
            },
            {
              "name" : "category",
              "definition" : "http://hl7.org/fhir/SearchParameter/AllergyIntolerance-category",
              "type" : "token",
              "documentation" : "Must be one of \n* food\n* medication\n* environment\n* biologic \n [AllergyIntolerance Category ValueSet](http://hl7.org/fhir/ValueSet/allergy-intolerance-category)"
            },
            {
              "name" : "clinical-status",
              "definition" : "http://hl7.org/fhir/SearchParameter/AllergyIntolerance-clinical-status",
              "type" : "token",
              "documentation" : "Must be one of \n* active\n * inactive\n * resolved\n[AllergyIntolerance Clinical Status ValueSet](http://hl7.org/fhir/R4/valueset-allergyintolerance-clinical.html)"
            },
            {
              "name" : "code",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-code",
              "type" : "token",
              "documentation" : "Code that identifies the allergy or intolerance \n [AllergyIntolerance Code ValueSet](http://hl7.org/fhir/ValueSet/allergyintolerance-code)"
            },
            {
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-identifier",
              "type" : "token",
              "documentation" : "A unique identifier assigned to this resource."
            },
            {
              "name" : "recorder",
              "definition" : "http://hl7.org/fhir/SearchParameter/AllergyIntolerance-recorder",
              "type" : "reference",
              "documentation" : "Who recorded the sensitivity \n [AllergyIntolerance.recorder](http://hl7.org/fhir/R4/allergyintolerance-definitions.html#AllergyIntolerance.recorder)"
            },
            {
              "name" : "severity",
              "definition" : "http://hl7.org/fhir/SearchParameter/severity",
              "type" : "token",
              "documentation" : "mild | moderate | severe (of event as a whole)."
            },
            {
              "name" : "_lastUpdated",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-lastUpdated",
              "type" : "date",
              "documentation" : "When the resource version last changed"
            }
          ]
        },
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Condition",
          "profile" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRCondition",
          "documentation" : "Note that the supported interactions of the API will vary per API Consumer, depending on the consuming system's role.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "create"
            },
            {
              "code" : "update"
            },
            {
              "code" : "search-type"
            },
            {
              "code" : "delete"
            }
          ],
          "searchInclude" : ["Condition:encounter"],
          "searchParam" : [
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "**MANDATORY**\n  Who has the condition?"
            },
            {
              "name" : "category",
              "definition" : "http://hl7.org/fhir/SearchParameter/Condition-category",
              "type" : "token",
              "documentation" : "The category of the condition"
            },
            {
              "name" : "code",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-code",
              "type" : "token",
              "documentation" : "The code for the condition"
            },
            {
              "name" : "encounter",
              "definition" : "http://hl7.org/fhir/SearchParameter/Condition-encounter",
              "type" : "reference",
              "documentation" : "Encounter associated with the condition"
            },
            {
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-identifier",
              "type" : "token",
              "documentation" : "A unique identifier assigned to this resource."
            },
            {
              "name" : "onset-date",
              "definition" : "http://hl7.org/fhir/SearchParameter/Condition-onset-date",
              "type" : "date",
              "documentation" : "Date the condition started"
            },
            {
              "name" : "severity",
              "definition" : "http://hl7.org/fhir/SearchParameter/Condition-severity",
              "type" : "token",
              "documentation" : "The severity of the condition"
            },
            {
              "name" : "subject",
              "definition" : "http://hl7.org/fhir/SearchParameter/Condition-subject",
              "type" : "reference",
              "documentation" : "Who has the condition?"
            },
            {
              "name" : "highlighted",
              "definition" : "https://fhir-ig.digital.health.nz/sdhr/SearchParameter/condition-highlighted",
              "type" : "token",
              "documentation" : "Search for conditions flagged as highlighted in the SDHRCondition profile"
            },
            {
              "name" : "long-term-condition",
              "definition" : "https://fhir-ig.digital.health.nz/sdhr/SearchParameter/condition-long-term-condition",
              "type" : "token",
              "documentation" : "Search for conditions flagged as long term in the SDHRCondition profile"
            },
            {
              "name" : "_lastUpdated",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-lastUpdated",
              "type" : "date",
              "documentation" : "When the resource version last changed."
            }
          ]
        },
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Observation",
          "profile" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRObservation",
          "documentation" : "Note that the supported interactions of the API will vary per API Consumer, depending on the consuming system's role.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "create"
            },
            {
              "code" : "update"
            },
            {
              "code" : "search-type"
            },
            {
              "code" : "delete"
            }
          ],
          "searchParam" : [
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "**MANDATORY**\n  Who the observation is for \n [Patient](http://hl7.org/fhir/R4/patient.html)"
            },
            {
              "name" : "category",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-category",
              "type" : "token",
              "documentation" : "The classification of the type of observation"
            },
            {
              "name" : "code",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-code",
              "type" : "token",
              "documentation" : "Describes what was observed. Sometimes this is called the observation 'name'"
            },
            {
              "name" : "date",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-date",
              "type" : "date",
              "documentation" : "Observation.effective \n Obtained date/time. If the obtained element is a period, a date that falls in the period"
            },
            {
              "name" : "encounter",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-encounter",
              "type" : "reference",
              "documentation" : "The Encounter resource associated with the Observation."
            },
            {
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-identifier",
              "type" : "token",
              "documentation" : "A unique identifier assigned to this resource."
            },
            {
              "name" : "performer",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-performer",
              "type" : "reference",
              "documentation" : "Who performed the observation"
            },
            {
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-status",
              "type" : "token",
              "documentation" : "The status of the observation"
            },
            {
              "name" : "subject",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-subject",
              "type" : "reference",
              "documentation" : "The subject that the observation is about"
            },
            {
              "name" : "value-concept",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-value-concept",
              "type" : "token",
              "documentation" : "The value of the observation, if the value is a CodeableConcept"
            },
            {
              "name" : "value-date",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-value-date",
              "type" : "date",
              "documentation" : "The value of the observation, if the value is a date or period of time"
            },
            {
              "name" : "value-quantity",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-value-quantity",
              "type" : "quantity",
              "documentation" : "The value of the observation, if the value is a Quantity, or a SampledData (just search on the bounds of the values in sampled data)"
            },
            {
              "name" : "value-string",
              "definition" : "http://hl7.org/fhir/SearchParameter/Observation-value-string",
              "type" : "string",
              "documentation" : "The value of the observation, if the value is a string, and also searches in CodeableConcept.text"
            },
            {
              "name" : "_lastUpdated",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-lastUpdated",
              "type" : "date",
              "documentation" : "When the resource version last changed."
            }
          ]
        }
      ],
      "interaction" : [
        {
          "code" : "search-system"
        },
        {
          "code" : "transaction"
        },
        {
          "code" : "batch"
        }
      ],
      "operation" : [
        {
          "name" : "participate",
          "definition" : "https://fhir-ig.digital.health.nz/sdhr/OperationDefinition/SDHRParticipateOperation",
          "documentation" : "This operation allows a patient to choose to participate in the Shared Digital Health Record service.\nThis operation should be used by data providers in the Shared Digital Health Record ecosystem such as Patient Management Systems (PMS) or Electronic Health Record (EHR) systems.\nIt can be used to indicate whether the patient wishes to participate, whether any resources are withheld, and the reason for participation. The scope of this operation is the API consumer - e.g. an HPI Facility where patient data is held.\n\nScenarios where this operation might be used include:\n- A patient has opted in to the Shared Digital Health Record service and appropriate data will be shared from the data holder to the service.\n- A patient chooses not to participate in the Shared Digital Health Record service and informs their healthcare provider of this choice.\n- A patient has one or more confidential records, held at their healthcare provider, that are withheld from the service.\n- A patient has previously withheld records but has now released them to the Shared Digital Health Record service.\n\nFor example payloads that might be used with this operation see:\n- [Parameters resource for total non-participation](./Parameters-ParametersDoNotParticipate.html) : This example shows how to indicate that a patient does not wish to participate in the Shared Digital Health Record service (has opted out).\n- [Parameters resource for participation](./Parameters-ParametersParticipate.html) : This example shows how to indicate that a patient wishes to participate in the Shared Digital Health Record service, where previously opted out (opt-in).\n- [Parameters resource for partial participation with withheld records](./Parameters-ParametersParticipateRecordWithheld.html) : This example shows how to indicate that a patient has some confidential records that are withheld from the Shared Digital Health Record service.\n- [Parameters resource for releasing withheld records](./Parameters-ParametersParticipateRecordReleased.html) : This example shows how to indicate that a patient has previously withheld records but has now released them to the Shared Digital Health Record service.\n\nTo make a request to this operation the API Consumer must POST a `Parameters` payload to the operation URL (e.g. `POST https://api.sdhr.digital.health.nz/s2s/$participate`).\n\nThe operation is idempotent, meaning that multiple requests with the same parameters will have the same effect as a single request.\nThe operation is expected to be called by a healthcare provider on behalf of the patient, and the patient must be identified by their NHI.\nThe operation will return an OperationOutcome resource indicating the result of the operation."
        },
        {
          "name" : "hnz-participate",
          "definition" : "https://fhir-ig.digital.health.nz/sdhr/OperationDefinition/SDHRHNZParticipateOperation",
          "documentation" : "This operation allows a patient to choose to participate in the Shared Digital Health Record service via HNZ assisted channels.\nThis operation should only be used by HNZ channels.\n\nScenarios where this operation might be used include:\n- A patient has opted in to the Shared Digital Health Record service by contacting Health NZ via appropriate digital or assisted channels.\n- A patient chooses not to participate in the Shared Digital Health Record service and informs Health NZ of this choice via appropriate digital or assisted channels.\n\nFor example payloads that might be used with this operation see:\n- [Parameters resource for total non-participation](./Parameters-ParametersHNZParticipateOptOut.html) : This example shows how to indicate that a patient does not wish to participate in the Shared Digital Health Record service (has opted out).\n- [Parameters resource for participation](./Parameters-ParametersHNZParticipateOptIn.html) : This example shows how to indicate that a patient wishes to participate in the Shared Digital Health Record service.\n\nTo make a request to this operation the API Consumer must POST a `Parameters` payload to the operation URL (e.g. `POST https://api.sdhr.digital.health.nz/s2s/$hnz-participate`).\n\nThe operation is idempotent, meaning that multiple requests with the same parameters will have the same effect as a single request.\nThe operation is expected to be called by a Health NZ channel system on behalf of the patient, and the patient must be identified by their NHI.\nThe operation will return an OperationOutcome resource indicating the result of the operation."
        }
      ]
    }
  ]
}

```
