# SearchConfidentialRecordsResponseExample - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **SearchConfidentialRecordsResponseExample**

## Example Bundle: SearchConfidentialRecordsResponseExample



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "SearchConfidentialRecordsResponseExample",
  "meta" : {
    "lastUpdated" : "2025-04-29T23:35:29.795Z",
    "security" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationValue",
        "code" : "redacted",
        "display" : "REDACTED"
      }
    ]
  },
  "type" : "searchset",
  "total" : 2,
  "link" : [
    {
      "relation" : "self",
      "url" : "https://api.mock.sdhr.digital.health.nz/s2s/AllergyIntolerance?patient=https%3A%2F%2Fapi.hip.digital.health.nz%2Ffhir%2Fnhi%2Fv1%2FPatient%2FZKC7284"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "https://api.mock.sdhr.digital.health.nz/s2s/AllergyIntolerance/AllergyIntoleranceExample2",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "AllergyIntoleranceExample2",
        "meta" : {
          "lastUpdated" : "2024-01-26T10:03:26+13:00",
          "source" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B",
          "profile" : [
            "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRAllergyIntolerance"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_AllergyIntoleranceExample2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance AllergyIntoleranceExample2</b></p><a name=\"AllergyIntoleranceExample2\"> </a><a name=\"hcAllergyIntoleranceExample2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">Last updated: 2024-01-26 10:03:26+1300; </p><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&amp;canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B\">https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SDHRAllergyIntolerance.html\">SDHRAllergyIntolerance</a></p></div><p><b>identifier</b>: <code>https://fhir.examplepms.co.nz</code>/ec2d6cad-1e19-46ee-accf-dc460a680710 (use: secondary, )</p><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-verification confirmed}\">Confirmed</span></p><p><b>type</b>: Allergy</p><p><b>category</b>: 370540009</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 227493005}\">Cashew nuts</span></p><p><b>patient</b>: <a href=\"https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&amp;canonical=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284\">Sage Westbrook</a></p><p><b>recorder</b>: <a href=\"https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&amp;canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/91ZZXN\">DR Julian Subatoi Bashir</a></p></div>"
        },
        "identifier" : [
          {
            "use" : "secondary",
            "system" : "https://fhir.examplepms.co.nz",
            "value" : "ec2d6cad-1e19-46ee-accf-dc460a680710"
          }
        ],
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ]
        },
        "type" : "allergy",
        "category" : ["370540009"],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "227493005",
              "display" : "Cashew nuts",
              "userSelected" : true
            }
          ]
        },
        "patient" : {
          "reference" : "https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284",
          "type" : "Patient",
          "display" : "Sage Westbrook"
        },
        "recorder" : {
          "reference" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/91ZZXN",
          "type" : "Practitioner",
          "display" : "DR Julian Subatoi Bashir"
        }
      },
      "search" : {
        "mode" : "match"
      }
    }
  ]
}

```
