# AllergyIntoleranceExample - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **AllergyIntoleranceExample**

## Example AllergyIntolerance: AllergyIntoleranceExample

Last updated: 2024-01-26 10:03:26+1300; 

Information Source: [https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B)

Profile: [SDHRAllergyIntolerance](StructureDefinition-SDHRAllergyIntolerance.md)

Security Label: Restricted (Details: Confidentiality code R = 'Restricted')

**Client Last Updated**: 2023-11-26 10:02:45+1300

**identifier**: `https://fhir.examplepms.co.nz`/ec2d6cad-1e19-46ee-accf-dc460a680710 (use: secondary, )

**clinicalStatus**: Active Phase

**verificationStatus**: Confirmed present

**type**: Allergy

**category**: 62014003

**code**: Allergy to penicillin (finding)

**patient**: [Sage Westbrook](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284)

**recorder**: [DR Julian Subatoi Bashir](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/91ZZXN)



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "AllergyIntoleranceExample",
  "meta" : {
    "lastUpdated" : "2024-01-26T10:03:26+13:00",
    "source" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B",
    "profile" : [
      "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRAllergyIntolerance"
    ],
    "security" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-Confidentiality",
        "code" : "R",
        "display" : "Restricted"
      }
    ]
  },
  "extension" : [
    {
      "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-client-last-updated-extension",
      "valueDateTime" : "2023-11-26T10:02:45+13:00"
    }
  ],
  "identifier" : [
    {
      "use" : "secondary",
      "system" : "https://fhir.examplepms.co.nz",
      "value" : "ec2d6cad-1e19-46ee-accf-dc460a680710"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "443601000210103",
        "display" : "Active Phase"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "410605003",
        "display" : "Confirmed present"
      }
    ]
  },
  "type" : "allergy",
  "category" : ["62014003"],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "91936005",
        "display" : "Allergy to penicillin (finding)",
        "userSelected" : true
      }
    ]
  },
  "patient" : {
    "reference" : "https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284",
    "type" : "Patient",
    "display" : "Sage Westbrook"
  },
  "recorder" : {
    "reference" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/91ZZXN",
    "type" : "Practitioner",
    "display" : "DR Julian Subatoi Bashir"
  }
}

```
