# NZ Shared Digital Health Record API - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* **NZ Shared Digital Health Record API**

## NZ Shared Digital Health Record API

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/ImplementationGuide/tewhatuora.fhir.nz-shared-digital-health-record | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:nzshareddigitalhealthrecord |

# NZ Shared Digital Health Record (SDHR) API

Enables a person’s core health information to be securely accessed from their general practice PMS. This information can then be made available to health professionals across Aotearoa.

# Brief Description

The Shared Digital Health Record (SDHR) API will enable a person’s core health information to be securely accessed from their general practice PMS. With the patient’s permission, information will be copied to a central database which will be made available to health professionals across Aotearoa, through existing shared patient record systems, such as shared electronic health records. This will give a fuller view of a person’s important health information and enable better care.

This health information will initially include a person’s health conditions and allergies, observations (eg, heart rate and blood pressure)

# Overview

* The SDHR data service will enable a person's core health information to be accessed across care settings nationally, and, in time, to be updated.
* It will give health professionals access to the important patient information they need to care for people.
* New Zealanders will be reassured that their important healthcare data can be securely accessed where and when needed – which could be life saving.

# Accessible Data

The SDHR API will initially access the following information from PMSs.

* [Allergies and intolerances.](./StructureDefinition-SDHRAllergyIntolerance.md)
* [Health conditions.](./StructureDefinition-SDHRCondition.md) 
* [Observations.](./StructureDefinition-SDHRObservation.md) 

Further information may become available to be accessed over time.

# Who can use this API

Access to the SDHR APIs is currently limited to pre-approved integration partners involved in the development of the Shared Digital Health Record data service. The APIs will be generally available following this initial development phase, subject to future funding decisions.

The SDHR API is for:

* accredited healthcare providers
* health software developers
* developers of practice management systems, consumer-facing patient portals or third-party integrators
* shared electronic health record vendors, enabling them to access data from SDHR and make it available to existing shared patient record systems.

Healthcare professionals using clinical workstations (CWS) or PMSs that have the SDHR API will be able to access the central minimum dataset of patient information through their CWS or PMS.

# Use Cases

SDHR will enable:

* health professionals to access patient information to support the care of that patient, wherever in the country the person or health professional is
* health professionals to have a summary view of a patient’s health record, copied from the patient’s general practice’s PMS
* someone’s information to be accessed in emergency situations. For example, if a person is unconscious in the emergency department, the SDHR data service will give rapid access to potentially life-saving information about their allergies, medications, and medical history
* (in time), health professionals to update a patient’s health record.

# Onboarding and Implementation

To begin the onboarding process for this API, please visit the [Consumer onboarding page](https://www.tewhatuora.govt.nz/health-services-and-programmes/digital-health/digital-services-hub/consumer-onboarding/).

For more information on integrating, please review the [Implementation guide](https://fhir-ig.digital.health.nz/sdhr/index.html).

# API Types

## FHIR API

All FHIR API endpoints adhere to Fast Healthcare Interoperable Resources (FHIR) interoperability standards and follow REST protocols

# Service Levels

* Target 99.99 percent service availability 24 hours a day, seven days a week.
* For support when using the SDHR APIs, please use the link here to access the SDHR service desk portal or call the team on 0800 855 066 (press 2 and then 1). These channels are currently monitored:

# Additional Requirements

Any additional requirements for consuming the SDHR APIs will be released once the service is made available for onboarding, following this initial development phase, and subject to future funding decisions.

# FHIR version

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (tewhatuora.fhir.nz-shared-digital-health-record.r4)](package.r4.tgz) and [R4B (tewhatuora.fhir.nz-shared-digital-health-record.r4b)](package.r4b.tgz) are available.

# Postman Collection

We provide a Postman collection for the Mock+ and UAT environments. These environments contain placeholder values for the client ID, client secret, and developer email address which you will need to replace with your own values. The Postman collections are available in the following locations:

* [UAT Collection](postman/UAT-SDHR.postman_collection.json)
* [UAT Environment](postman/UAT-SDHR-example.postman_environment.json)



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "tewhatuora.fhir.nz-shared-digital-health-record",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/ImplementationGuide/tewhatuora.fhir.nz-shared-digital-health-record",
  "version" : "1.0.0",
  "name" : "nzshareddigitalhealthrecord",
  "title" : "NZ Shared Digital Health Record API",
  "status" : "active",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "NZ Shared Digital Health Record API",
  "packageId" : "tewhatuora.fhir.nz-shared-digital-health-record",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "fhir_org_nz_ig_base",
      "uri" : "http://fhir.org.nz/ig/base",
      "packageId" : "fhir.org.nz.ig.base",
      "version" : "3.0.0"
    },
    {
      "id" : "tewhatuora_digitaltooling",
      "uri" : "https://fhir-ig.digital.health.nz/hnz-digital-tooling/ImplementationGuide/tewhatuora.digitaltooling",
      "packageId" : "tewhatuora.digitaltooling",
      "version" : "0.0.11"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "release"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir-ig.digital.health.nz/sdhr/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "release"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir-ig.digital.health.nz/sdhr/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/AllergyIntoleranceExample"
        },
        "name" : "AllergyIntoleranceExample",
        "description" : "An example payload for a Primary Care AllergyIntolerance resource indicating an allergy to Penicillin, with a confidentiality of restricted.",
        "exampleCanonical" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRAllergyIntolerance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/AllergyIntoleranceExample2"
        },
        "name" : "AllergyIntoleranceExample2",
        "description" : "An example payload for a Primary Care AllergyIntolerance resource indicating an allergy to Cashew nuts",
        "exampleCanonical" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRAllergyIntolerance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/APIError-Confidential"
        },
        "name" : "APIError-Confidential",
        "description" : "Example OperationOutcome API response, returned when a resource has been flagged as confidential, and so cannot be accessed.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/APIError-Unauthorised"
        },
        "name" : "APIError-Unauthorised",
        "description" : "Access to Shared Digital Health Records is **restricted**.<br>\n    This API validates information that is provided by the API Consumer in their `Request-Context` header.\n    The API Consumer must also provide an appropriate OAuth 2.0 Bearer token in the `Authorization` header containing scopes appropriate for the resource being accessed.\n    The API Consumer must be registered with the Shared Digital Health Record API.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDHRBatchBundle"
        },
        "name" : "Batch Bundle with a Single Patient",
        "description" : "SDHR allows Bundle posts with the following restrictions:\n- The Bundle type must be `batch` (transactions are not supported).\n- All Patient references in the Bundle must target a single Patient.\n- The Bundle must not contain any $participate or $hnz-participate requests.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/Batch-example"
        },
        "name" : "Batch-example",
        "exampleCanonical" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRBatchBundle"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hnz-sdhr-client-last-updated-extension"
        },
        "name" : "Client Last Updated",
        "description" : "Extension to record the last time a resource was updated by the source system. When consuming applications are writing data to the SDHR API they can use this extension to record the `LastUpdated` timestamp in their system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/condition-highlighted"
        },
        "name" : "condition-highlighted",
        "description" : "Search for conditions flagged as highlighted in the SDHRCondition profile",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/condition-long-term-condition"
        },
        "name" : "condition-long-term-condition",
        "description" : "Search for conditions marked as long term in the SDHRCondition profile",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ConditionHypertensionExample"
        },
        "name" : "ConditionHypertensionExample",
        "description" : "Example Hypertension Condition",
        "exampleCanonical" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRCondition"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ConditionRespiratoryExample"
        },
        "name" : "ConditionRespiratoryExample",
        "description" : "Example Respiratory Condition",
        "exampleCanonical" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRCondition"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/ConsentExample"
        },
        "name" : "ConsentExample",
        "description" : "Consent example submitted to allow a patient to opt in to sharing their information, originating from a practice management system",
        "exampleCanonical" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRConsent"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/ConsentExampleRecordsWithheld"
        },
        "name" : "ConsentExampleRecordsWithheld",
        "description" : "Consent example to allow a patient to opt in to sharing their information, while withholding some records from the service",
        "exampleCanonical" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRConsent"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/ConsentFacilityDenyExample"
        },
        "name" : "ConsentFacilityDenyExample",
        "description" : "Consent example submitted to allow a patient to opt out of sharing their information. This example shows a Consent resource created as the result of an HNZ opt out.",
        "exampleCanonical" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRConsent"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/ConsentHNZDenyExample"
        },
        "name" : "ConsentHNZDenyExample",
        "description" : "Consent example submitted to allow a patient to opt out of sharing their information. This example shows a Consent resource created as the result of an HNZ opt out.",
        "exampleCanonical" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRConsent"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/ConsentMultiFacilityExample"
        },
        "name" : "ConsentMultiFacilityExample",
        "description" : "Consent example illustrating a patient stating participation preferences forsharing their information with SDHR at multiple facilities.",
        "exampleCanonical" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRConsent"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/facility-participation-extension"
        },
        "name" : "Facility Participation",
        "description" : "Indicates whether the patient has opted out or opted in to participation at the facility. If opted out, no records will be shared from that facility.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hnz-sdhr-highlighted-extension"
        },
        "name" : "HNZ SDHR Highlighted",
        "description" : "Extension to indicate that a resource should be highlighted in the user interface. This is used to indicate that the resource is important and should be highlighted in a user interface.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/SDHRCapabilityStatement"
        },
        "name" : "NZ Shared Digital Health Record API",
        "description" : "NZ Shared Digital Health Record API Capability Statement",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/nz-sdhr-codesystem"
        },
        "name" : "NZ-specific terminology for Shared Digital Health Records",
        "description" : "This system defines standard codes used throughout this Implementation Guide for New Zealand Shared Digital Health Records",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ObservationVitalSignsExample"
        },
        "name" : "ObservationVitalSignsExample",
        "description" : "An example SDHR Vital Signs Observation",
        "exampleCanonical" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRObservation"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/OperationOutcomeFacilityDenyExample"
        },
        "name" : "OperationOutcomeFacilityDenyExample",
        "description" : "Example OperationOutcome for a request where the patient has opted out of participating in the shared digital health record service for a specific facility.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/OperationOutcomeFacilityLocked"
        },
        "name" : "OperationOutcomeFacilityLocked",
        "description" : "This outcome message will be returned in a special case where a facility has been `locked` due to a background load process where the SDHR service is performing a historic record load for a practice.\nA typical scenario where this would occur would be where a practice has 'onboarded' to the SDHR service and SDHR is sourcing historic records for consented patients.\nIf a data holder receives this outcome when loading records they should queue the failed records and retry after a delay.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/OperationOutcomeFacilityUnknown"
        },
        "name" : "OperationOutcomeFacilityUnknown",
        "description" : "This outcome message will be returned where a facility is not yet onboarded to SDHR.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/OperationOutcomeGlobalDenyExample"
        },
        "name" : "OperationOutcomeGlobalDenyExample",
        "description" : "Example OperationOutcome for a request where the patient has opted out of participating in the shared digital health record service.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/OperationOutcomeParticipateInvalidPatient"
        },
        "name" : "OperationOutcomeParticipateInvalidPatient",
        "description" : "Example OperationOutcome for an invalid patient participation operation indicating that the patient parameter is invalid.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/OperationOutcomeParticipateMissingReason"
        },
        "name" : "OperationOutcomeParticipateMissingReason",
        "description" : "Example OperationOutcome for a missing reason code in the Participate operation indicating that the reason for participation status is required.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/OperationOutcomeParticipatePreferencesNotKnown"
        },
        "name" : "OperationOutcomeParticipatePreferencesNotKnown",
        "description" : "Example OperationOutcome where a patient has not indicated their participation preferences for the Shared Digital Health Record service.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/OperationOutcomeParticipateSuccess"
        },
        "name" : "OperationOutcomeParticipateSuccess",
        "description" : "Example OperationOutcome for a successful participation operation indicating that the patient's participation status was successfully recorded.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/OperationOutcomePatientLocked"
        },
        "name" : "OperationOutcomePatientLocked",
        "description" : "This outcome message will be returned in a special case where a patient record has been `locked` due to a background load process where the SDHR service is performing a historic record load for a patient.\nA typical scenario where this would occur would be where a practice has 'onboarded' to the SDHR service and SDHR is sourcing historic records for a patient who has contented to participation.\nIf a data holder receives this outcome when loading records they should queue the failed record(s) and retry after a delay.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/OperationOutcomeRateLimitExceeded"
        },
        "name" : "OperationOutcomeRateLimitExceeded",
        "description" : "This outcome message will be returned where an API Consumer has exceeded the allocated rate limit.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/OperationOutcomeRecordsWithheldAtSource"
        },
        "name" : "OperationOutcomeRecordsWithheldAtSource",
        "description" : "Example OperationOutcome when a patient has withheld records at source.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/ParametersDoNotParticipate"
        },
        "name" : "ParametersDoNotParticipate",
        "description" : "Example parameters content to POST to the Participate operation where a patient does not wish to participate in the Shared Digital Health Record service.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/ParametersHNZParticipateOptIn"
        },
        "name" : "ParametersHNZParticipateOptIn",
        "description" : "Example parameters content to POST to the HNZ Participate (`$hnz-participate`) operation where a patient elects to participate in the Shared Digital Health Record service by using an appropriate HNZ digital or assisted channel.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/ParametersHNZParticipateOptOut"
        },
        "name" : "ParametersHNZParticipateOptOut",
        "description" : "Example parameters content to POST to the HNZ Participate (`$hnz-participate`) operation where a patient elects not to participate in the Shared Digital Health Record service by using an appropriate HNZ digital or assisted channel.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/ParametersParticipate"
        },
        "name" : "ParametersParticipate",
        "description" : "Example parameters content to POST to the Participate operation where a patient wishes to participate in the Shared Digital Health Record service.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/ParametersParticipateRecordReleased"
        },
        "name" : "ParametersParticipateRecordReleased",
        "description" : "Example parameters content to POST to the Participate operation where a patient has individual records that are no longer withheld.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/ParametersParticipateRecordWithheld"
        },
        "name" : "ParametersParticipateRecordWithheld",
        "description" : "Example parameters content to POST to the Participate operation where a patient has individual records that are withheld - e.g. records marked as `Confidential`.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/sdhr-other-codes"
        },
        "name" : "SDHR Codes where the appropriate code is not known or can not be determined.",
        "description" : "This code system is used when the appropriate code is not known or can not be determined.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/sdhr-participation-reason"
        },
        "name" : "SDHR Participation Reason Codes",
        "description" : "This code system defines the reasons for a patient to participate in the Shared Digital Health Record service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/sdhr-outcome-codes"
        },
        "name" : "SDHR Specific Outcome Codes",
        "description" : "This code system defines standard OperationOucome codes used throughout this Implementation Guide for New Zealand Shared Digital Health Records",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDHRAllergyIntolerance"
        },
        "name" : "SDHRAllergyIntolerance",
        "description" : "AllergyIntolerance FHIR resource for Shared Digital Health Record",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDHRCondition"
        },
        "name" : "SDHRCondition",
        "description" : "Condition resource to record problems and conditions affecting a person",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDHRConsent"
        },
        "name" : "SDHRConsent",
        "description" : "Consent resource created to reflect a patient's preferences with regard to sharing their information with authorised health workers via the shared digital health record service.\n            Note that this is a protected resource and scopes required to manage this resource are not provisioned to most API consumers.\n            A patient's participation preferences should be managed by the [Participate Operation](./OperationDefinition-SDHRParticipateOperation.html).\n            For more details on the participate operation see [SDHR Custom Operations](./api.html#sdhr-custom-operations).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/SDHRHNZParticipateOperation"
        },
        "name" : "SDHRHNZParticipateOperation",
        "description" : "This operation allows a patient to choose to participate in the Shared Digital Health Record service via HNZ assisted channels.\nThis operation should only be used by HNZ channels.\n\nScenarios where this operation might be used include:\n- A patient has opted in to the Shared Digital Health Record service by contacting Health NZ via appropriate digital or assisted channels.\n- A patient chooses not to participate in the Shared Digital Health Record service and informs Health NZ of this choice via appropriate digital or assisted channels.\n\nFor example payloads that might be used with this operation see:\n- [Parameters resource for total non-participation](./Parameters-ParametersHNZParticipateOptOut.html) : This example shows how to indicate that a patient does not wish to participate in the Shared Digital Health Record service (has opted out).\n- [Parameters resource for participation](./Parameters-ParametersHNZParticipateOptIn.html) : This example shows how to indicate that a patient wishes to participate in the Shared Digital Health Record service.\n\nTo make a request to this operation the API Consumer must POST a `Parameters` payload to the operation URL (e.g. `POST https://api.sdhr.digital.health.nz/s2s/$hnz-participate`).\n\nThe operation is idempotent, meaning that multiple requests with the same parameters will have the same effect as a single request.\nThe operation is expected to be called by a Health NZ channel system on behalf of the patient, and the patient must be identified by their NHI.\nThe operation will return an OperationOutcome resource indicating the result of the operation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDHRObservation"
        },
        "name" : "SDHRObservation",
        "description" : "A Shared Digital Health Record Observation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/SDHRParticipateOperation"
        },
        "name" : "SDHRParticipateOperation",
        "description" : "This operation allows a patient to choose to participate in the Shared Digital Health Record service.\nThis operation should be used by data providers in the Shared Digital Health Record ecosystem such as Patient Management Systems (PMS) or Electronic Health Record (EHR) systems.\nIt can be used to indicate whether the patient wishes to participate, whether any resources are withheld, and the reason for participation. The scope of this operation is the API consumer - e.g. an HPI Facility where patient data is held.\n\nScenarios where this operation might be used include:\n- A patient has opted in to the Shared Digital Health Record service and appropriate data will be shared from the data holder to the service.\n- A patient chooses not to participate in the Shared Digital Health Record service and informs their healthcare provider of this choice.\n- A patient has one or more confidential records, held at their healthcare provider, that are withheld from the service.\n- A patient has previously withheld records but has now released them to the Shared Digital Health Record service.\n\nFor example payloads that might be used with this operation see:\n- [Parameters resource for total non-participation](./Parameters-ParametersDoNotParticipate.html) : This example shows how to indicate that a patient does not wish to participate in the Shared Digital Health Record service (has opted out).\n- [Parameters resource for participation](./Parameters-ParametersParticipate.html) : This example shows how to indicate that a patient wishes to participate in the Shared Digital Health Record service, where previously opted out (opt-in).\n- [Parameters resource for partial participation with withheld records](./Parameters-ParametersParticipateRecordWithheld.html) : This example shows how to indicate that a patient has some confidential records that are withheld from the Shared Digital Health Record service.\n- [Parameters resource for releasing withheld records](./Parameters-ParametersParticipateRecordReleased.html) : This example shows how to indicate that a patient has previously withheld records but has now released them to the Shared Digital Health Record service.\n\nTo make a request to this operation the API Consumer must POST a `Parameters` payload to the operation URL (e.g. `POST https://api.sdhr.digital.health.nz/s2s/$participate`).\n\nThe operation is idempotent, meaning that multiple requests with the same parameters will have the same effect as a single request.\nThe operation is expected to be called by a healthcare provider on behalf of the patient, and the patient must be identified by their NHI.\nThe operation will return an OperationOutcome resource indicating the result of the operation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/SearchConditionResponseExample"
        },
        "name" : "SearchConditionResponseExample",
        "description" : "Example of a search response for a condition search. In this case the search response returns one result using the search parameters `code` and `subject`. `GET /Condition?subject=https://api.hip.digital.health.nz/fhir/Patient/ZKC7284&code=http://snomed.info/sct%7C38341003`",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/SearchConfidentialRecordsResponseExample"
        },
        "name" : "SearchConfidentialRecordsResponseExample",
        "description" : "Example of a searchset API response for an AllergyIntolerance resource search.\nIn this case, the search response returns one entry item, with a total count of 2. This is because the API will not return the confidential record.\nThe redacted security label is applied to the Bundle response, to indicate that confidential records have been removed from the result set.\nSee the [API documentation](./api.html#sdhr-confidential-record-api-behaviour) for more information.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/SearchExactMatchRecordWithheldExample"
        },
        "name" : "SearchExactMatchRecordWithheldExample",
        "description" : "Example of a searchset API response for an Condition resource search where the patient has withheld records at their PMS.\nIn this case, the server does not have the record but the parameters supplied in the search mean we are able to uniquely match to a single record that has been withheld using the $participate operation.\nThe search response returns zero entries `'total':0`.\nThe response includes an entry which is an `OperationOutcome` resource indicating that records were withheld at source.\nThis is indicated by the `search.mode` being set to `outcome` for the `OperationOutcome` entry.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/SearchWithRecordsWithheldExample"
        },
        "name" : "SearchWithRecordsWithheldExample",
        "description" : "Example of a searchset API response for an Condition resource search where the patient has withheld records at their PMS.\nIn this case, the search response returns one entry `'total':1`.\nThe response also includes an entry which is an `OperationOutcome` resource indicating that some records were withheld at source.\nThis is indicated by the `search.mode` being set to `outcome` for the `OperationOutcome` entry.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/sdhr-allergyintolerance-code-valueset"
        },
        "name" : "ValueSet for AllergyIntolerance Code",
        "description" : "A ValueSet containing all codes from the AllergyIntolerance Code system.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/sdhr-allergyintolerance-manifestation-valueset"
        },
        "name" : "ValueSet for AllergyIntolerance Manifestation",
        "description" : "A ValueSet containing all codes from the AllergyIntolerance Manifestation system.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/sdhr-allergyintolerance-severity-valueset"
        },
        "name" : "ValueSet for AllergyIntolerance Severity",
        "description" : "A ValueSet containing all codes from the AllergyIntolerance Severity system.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/sdhr-participation-reason-valueset"
        },
        "name" : "ValueSet for SDHR Participation Reason",
        "description" : "A ValueSet containing all codes from the SDHR Participation Reason system.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/sdhr-resource-tags-valueset"
        },
        "name" : "ValueSet for SDHR Resource Tags",
        "description" : "A ValueSet containing all codes from the SDHR Resource Tags system.",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "NZ Shared Digital Health Record API",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "use-cases.html"
            }
          ],
          "nameUrl" : "use-cases.html",
          "title" : "Use cases",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "consent-based-access.html"
            }
          ],
          "nameUrl" : "consent-based-access.html",
          "title" : "Consent based access control",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "artifacts.html"
            }
          ],
          "nameUrl" : "artifacts.html",
          "title" : "FHIR Artifacts",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "compliance-requirements.html"
            }
          ],
          "nameUrl" : "compliance-requirements.html",
          "title" : "Compliance Requirements - for Systems Sharing Data",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "data-models.html"
            }
          ],
          "nameUrl" : "data-models.html",
          "title" : "Data Models",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "api.html"
            }
          ],
          "nameUrl" : "api.html",
          "title" : "API Docs",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "test-data.html"
            }
          ],
          "nameUrl" : "test-data.html",
          "title" : "Test Data",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
