# ValueSet for SDHR Resource Tags - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **ValueSet for SDHR Resource Tags**

## ValueSet: ValueSet for SDHR Resource Tags 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/ValueSet/sdhr-resource-tags-valueset | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:SDHRResourceTagsValueSet |

 
A ValueSet containing all codes from the SDHR Resource Tags system. 

 **References** 

* [SDHRAllergyIntolerance](StructureDefinition-SDHRAllergyIntolerance.md)
* [SDHRCondition](StructureDefinition-SDHRCondition.md)
* [SDHRObservation](StructureDefinition-SDHRObservation.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "sdhr-resource-tags-valueset",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/ValueSet/sdhr-resource-tags-valueset",
  "version" : "1.0.0",
  "name" : "SDHRResourceTagsValueSet",
  "title" : "ValueSet for SDHR Resource Tags",
  "status" : "active",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A ValueSet containing all codes from the SDHR Resource Tags system.",
  "compose" : {
    "include" : [
      {
        "system" : "https://fhir-ig.digital.health.nz/sdhr/CodeSystem/nz-sdhr-codesystem",
        "concept" : [
          {
            "code" : "highlighted"
          }
        ]
      }
    ]
  }
}

```
