# ValueSet for AllergyIntolerance Severity - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **ValueSet for AllergyIntolerance Severity**

## ValueSet: ValueSet for AllergyIntolerance Severity 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/ValueSet/sdhr-allergyintolerance-severity-valueset | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:SDHRAllergyIntoleranceSeverityValueSet |

 
A ValueSet containing all codes from the AllergyIntolerance Severity system. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on:

* [codesystem AllergyIntoleranceSeverity v4.0.1 (CodeSystem)](http://hl7.org/fhir/R4/codesystem-reaction-event-severity.html)
* SNOMED CT International edition 01-Feb 2025
* [valueset AllergyIntoleranceSeverity v4.0.1 (ValueSet)](http://hl7.org/fhir/R4/valueset-reaction-event-severity.html)

This value set contains 6 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "sdhr-allergyintolerance-severity-valueset",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/ValueSet/sdhr-allergyintolerance-severity-valueset",
  "version" : "1.0.0",
  "name" : "SDHRAllergyIntoleranceSeverityValueSet",
  "title" : "ValueSet for AllergyIntolerance Severity",
  "status" : "active",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A ValueSet containing all codes from the AllergyIntolerance Severity system.",
  "compose" : {
    "include" : [
      {
        "valueSet" : ["http://hl7.org/fhir/ValueSet/reaction-event-severity"]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "255604002",
            "display" : "Mild (qualifier value)"
          },
          {
            "code" : "1255665007",
            "display" : "Moderate (qualifier value)"
          },
          {
            "code" : "24484000",
            "display" : "Severe (severity modifier) (qualifier value)"
          }
        ]
      }
    ]
  }
}

```
