# HNZ SDHR Highlighted - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **HNZ SDHR Highlighted**

## Extension: HNZ SDHR Highlighted 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-highlighted-extension | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:HNZSDHRHighlightedExtension |

Extension to indicate that a resource should be highlighted in the user interface. This is used to indicate that the resource is important and should be highlighted in a user interface.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [SDHRCondition](StructureDefinition-SDHRCondition.md)
* Examples for this Extension: [Bundle/SearchConditionResponseExample](Bundle-SearchConditionResponseExample.md), [Bundle/SearchWithRecordsWithheldExample](Bundle-SearchWithRecordsWithheldExample.md) and [Condition/ConditionHypertensionExample](Condition-ConditionHypertensionExample.md)
* Search Parameters using this Extension: [ConditionHighlighted](SearchParameter-condition-highlighted.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tewhatuora.fhir.nz-shared-digital-health-record|current/StructureDefinition/hnz-sdhr-highlighted-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-hnz-sdhr-highlighted-extension.csv), [Excel](StructureDefinition-hnz-sdhr-highlighted-extension.xlsx), [Schematron](StructureDefinition-hnz-sdhr-highlighted-extension.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hnz-sdhr-highlighted-extension",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-highlighted-extension",
  "version" : "1.0.0",
  "name" : "HNZSDHRHighlightedExtension",
  "title" : "HNZ SDHR Highlighted",
  "status" : "active",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Extension to indicate that a resource should be highlighted in the user interface. This is used to indicate that the resource is important and should be highlighted in a user interface.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Condition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "HNZ SDHR Highlighted",
        "definition" : "Extension to indicate that a resource should be highlighted in the user interface. This is used to indicate that the resource is important and should be highlighted in a user interface."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-highlighted-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      }
    ]
  }
}

```
