# Client Last Updated - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **Client Last Updated**

## Extension: Client Last Updated 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-client-last-updated-extension | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:ClientLastUpdatedExtension |

Extension to record the last time a resource was updated by the source system. When consuming applications are writing data to the SDHR API they can use this extension to record the `LastUpdated` timestamp in their system

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [SDHRAllergyIntolerance](StructureDefinition-SDHRAllergyIntolerance.md), [SDHRCondition](StructureDefinition-SDHRCondition.md) and [SDHRObservation](StructureDefinition-SDHRObservation.md)
* Examples for this Extension: [AllergyIntolerance/AllergyIntoleranceExample](AllergyIntolerance-AllergyIntoleranceExample.md), [Bundle/SearchConditionResponseExample](Bundle-SearchConditionResponseExample.md), [Bundle/SearchWithRecordsWithheldExample](Bundle-SearchWithRecordsWithheldExample.md), [Condition/ConditionHypertensionExample](Condition-ConditionHypertensionExample.md)...Show 2 more,[Condition/ConditionRespiratoryExample](Condition-ConditionRespiratoryExample.md)and[Observation/ObservationVitalSignsExample](Observation-ObservationVitalSignsExample.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tewhatuora.fhir.nz-shared-digital-health-record|current/StructureDefinition/hnz-sdhr-client-last-updated-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-hnz-sdhr-client-last-updated-extension.csv), [Excel](StructureDefinition-hnz-sdhr-client-last-updated-extension.xlsx), [Schematron](StructureDefinition-hnz-sdhr-client-last-updated-extension.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hnz-sdhr-client-last-updated-extension",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-client-last-updated-extension",
  "version" : "1.0.0",
  "name" : "ClientLastUpdatedExtension",
  "title" : "Client Last Updated",
  "status" : "active",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Extension to record the last time a resource was updated by the source system. When consuming applications are writing data to the SDHR API they can use this extension to record the `LastUpdated` timestamp in their system",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Condition"
    },
    {
      "type" : "element",
      "expression" : "Observation"
    },
    {
      "type" : "element",
      "expression" : "AllergyIntolerance"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Client Last Updated",
        "definition" : "Extension to record the last time a resource was updated by the source system. When consuming applications are writing data to the SDHR API they can use this extension to record the `LastUpdated` timestamp in their system"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-client-last-updated-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
