# Facility Participation - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **Facility Participation**

## Extension: Facility Participation 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/facility-participation-extension | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:FacilityParticipationExtension |

Indicates whether the patient has opted out or opted in to participation at the facility. If opted out, no records will be shared from that facility.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [SDHRConsent](StructureDefinition-SDHRConsent.md)
* Examples for this Extension: [Consent/ConsentExampleRecordsWithheld](Consent-ConsentExampleRecordsWithheld.md), [Consent/ConsentFacilityDenyExample](Consent-ConsentFacilityDenyExample.md) and [Consent/ConsentMultiFacilityExample](Consent-ConsentMultiFacilityExample.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tewhatuora.fhir.nz-shared-digital-health-record|current/StructureDefinition/facility-participation-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-facility-participation-extension.csv), [Excel](StructureDefinition-facility-participation-extension.xlsx), [Schematron](StructureDefinition-facility-participation-extension.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "facility-participation-extension",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/facility-participation-extension",
  "version" : "1.0.0",
  "name" : "FacilityParticipationExtension",
  "title" : "Facility Participation",
  "status" : "active",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Indicates whether the patient has opted out or opted in to participation at the facility. If opted out, no records will be shared from that facility.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Facility Participation",
        "definition" : "Indicates whether the patient has opted out or opted in to participation at the facility. If opted out, no records will be shared from that facility."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/facility-participation-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Extension.value[x]:valueCodeableConcept",
        "path" : "Extension.value[x]",
        "sliceName" : "valueCodeableConcept",
        "short" : "Use sdhr-facility-opt-out if the patient has opted out, sdhr-facility-opt-in if the patient has opted in",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir-ig.digital.health.nz/sdhr/ValueSet/sdhr-participation-reason-valueset"
        }
      }
    ]
  }
}

```
