# SDHRConsent - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **SDHRConsent**

## Resource Profile: SDHRConsent 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRConsent | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:SDHRConsent |

 
Consent resource created to reflect a patient's preferences with regard to sharing their information with authorised health workers via the shared digital health record service. Note that this is a protected resource and scopes required to manage this resource are not provisioned to most API consumers. A patient's participation preferences should be managed by the[Participate Operation](./OperationDefinition-SDHRParticipateOperation.md). For more details on the participate operation see[SDHR Custom Operations](./api.md#sdhr-custom-operations). 

### Usage of this resource

-------

**Usages:**

* Examples for this Profile: [Consent/ConsentExample](Consent-ConsentExample.md), [Consent/ConsentExampleRecordsWithheld](Consent-ConsentExampleRecordsWithheld.md), [Consent/ConsentFacilityDenyExample](Consent-ConsentFacilityDenyExample.md), [Consent/ConsentHNZDenyExample](Consent-ConsentHNZDenyExample.md) and [Consent/ConsentMultiFacilityExample](Consent-ConsentMultiFacilityExample.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tewhatuora.fhir.nz-shared-digital-health-record|current/StructureDefinition/SDHRConsent)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SDHRConsent.csv), [Excel](StructureDefinition-SDHRConsent.xlsx), [Schematron](StructureDefinition-SDHRConsent.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDHRConsent",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRConsent",
  "version" : "1.0.0",
  "name" : "SDHRConsent",
  "status" : "active",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Consent resource created to reflect a patient's preferences with regard to sharing their information with authorised health workers via the shared digital health record service.\n            Note that this is a protected resource and scopes required to manage this resource are not provisioned to most API consumers.\n            A patient's participation preferences should be managed by the [Participate Operation](./OperationDefinition-SDHRParticipateOperation.html).\n            For more details on the participate operation see [SDHR Custom Operations](./api.html#sdhr-custom-operations).",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Consent",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Consent",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Consent",
        "path" : "Consent"
      },
      {
        "id" : "Consent.status",
        "path" : "Consent.status",
        "short" : "The state of the Consent. This must be active to release data from the server"
      },
      {
        "id" : "Consent.scope",
        "path" : "Consent.scope",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
              "code" : "patient-privacy"
            }
          ]
        }
      },
      {
        "id" : "Consent.category",
        "path" : "Consent.category",
        "short" : "The category of the consent, which is a code that indicates the type of consent",
        "definition" : "The category of the consent, which is a code that indicates the type of consent",
        "max" : "1",
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "887031000000108"
            }
          ]
        }
      },
      {
        "id" : "Consent.patient",
        "path" : "Consent.patient",
        "min" : 1
      },
      {
        "id" : "Consent.patient.reference",
        "path" : "Consent.patient.reference",
        "short" : "Must be an absolute URL reference to the patient on the NHI system. See constraints for details.",
        "min" : 1,
        "constraint" : [
          {
            "key" : "nhi-url-format",
            "severity" : "error",
            "human" : "Reference must be an NHI Patient URL with format https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZZZ1111 or ZZZ11AA",
            "expression" : "matches('^https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/[A-Z]{3}([0-9]{4}|[0-9]{2}[A-Z]{2})$')",
            "source" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRConsent"
          }
        ]
      },
      {
        "id" : "Consent.patient.type",
        "path" : "Consent.patient.type",
        "min" : 1,
        "patternUri" : "Patient"
      },
      {
        "id" : "Consent.policy",
        "path" : "Consent.policy",
        "min" : 1
      },
      {
        "id" : "Consent.provision",
        "path" : "Consent.provision",
        "short" : "The provision of the consent, which may be a permit or deny",
        "min" : 1
      },
      {
        "id" : "Consent.provision.type",
        "path" : "Consent.provision.type",
        "short" : "The type of consent, either permit or deny",
        "min" : 1
      },
      {
        "id" : "Consent.provision.period.start",
        "path" : "Consent.provision.period.start",
        "short" : "The date and time the Consent is considered to be in effect",
        "min" : 1
      },
      {
        "id" : "Consent.provision.period.end",
        "path" : "Consent.provision.period.end",
        "short" : "The date and time the Consent is considered to be expired"
      },
      {
        "id" : "Consent.provision.action",
        "path" : "Consent.provision.action",
        "short" : "The action that is being permitted or denied",
        "min" : 1
      },
      {
        "id" : "Consent.provision.provision",
        "path" : "Consent.provision.provision",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Consent.provision.provision.extension",
        "path" : "Consent.provision.provision.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Consent.provision.provision.extension:FacilityParticipationExtension",
        "path" : "Consent.provision.provision.extension",
        "sliceName" : "FacilityParticipationExtension",
        "short" : "Indicates the patient has opted out of participation entirely at the facility",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/facility-participation-extension"
            ]
          }
        ]
      }
    ]
  }
}

```
