# Batch Bundle with a Single Patient - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **Batch Bundle with a Single Patient**

## Resource Profile: Batch Bundle with a Single Patient 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRBatchBundle | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:BatchBundle |

 
SDHR allows Bundle posts with the following restrictions: 
* The Bundle type must be `batch` (transactions are not supported).
* All Patient references in the Bundle must target a single Patient.
* The Bundle must not contain any $participate or $hnz-participate requests.
 

**Usages:**

* Examples for this Profile: [Bundle/Batch-example](Bundle-Batch-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tewhatuora.fhir.nz-shared-digital-health-record|current/StructureDefinition/SDHRBatchBundle)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SDHRBatchBundle.csv), [Excel](StructureDefinition-SDHRBatchBundle.xlsx), [Schematron](StructureDefinition-SDHRBatchBundle.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDHRBatchBundle",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRBatchBundle",
  "version" : "1.0.0",
  "name" : "BatchBundle",
  "title" : "Batch Bundle with a Single Patient",
  "status" : "active",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "SDHR allows Bundle posts with the following restrictions:\n- The Bundle type must be `batch` (transactions are not supported).\n- All Patient references in the Bundle must target a single Patient.\n- The Bundle must not contain any $participate or $hnz-participate requests.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "constraint" : [
          {
            "key" : "one-patient-only",
            "severity" : "error",
            "human" : "All Patient references in the bundle are the same (compares full reference strings).",
            "expression" : "entry.resource.descendants().where($this is Reference).reference.where(matches('(^|.*/)?Patient/[^/]+$')).exists() and entry.resource.descendants().where($this is Reference).reference.where(matches('(^|.*/)?Patient/[^/]+$')).distinct().count() = 1",
            "source" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRBatchBundle"
          },
          {
            "key" : "no-participation-ops",
            "severity" : "error",
            "human" : "Bundle entries MUST NOT invoke $participate or $hnz-participate.",
            "expression" : "entry.request.url.where($this.matches('[$](participate|hnz-participate)')).exists().not()",
            "source" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRBatchBundle"
          }
        ]
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "fixedCode" : "batch"
      }
    ]
  }
}

```
