# condition-highlighted - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **condition-highlighted**

## SearchParameter: condition-highlighted 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/SearchParameter/condition-highlighted | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:ConditionHighlighted |

 
Search for conditions flagged as highlighted in the SDHRCondition profile 

## ConditionHighlighted

Parameter `highlighted`:`token`

Search for conditions flagged as highlighted in the SDHRCondition profile

| | |
| :--- | :--- |
| Resource | [Condition](http://hl7.org/fhir/R4/condition.html) |
| Expression | `Condition.extension('https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-highlighted-extension')` |
| Processing Mode | Normal |
| Multiples | * multipleAnd: It's up to the server whether the parameter may repeat in order to specify multiple values that must all be true
* multipleOr: It's up to the server whether the parameter can have multiple values (separated by comma) where at least one must be true
 |



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "condition-highlighted",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/SearchParameter/condition-highlighted",
  "version" : "1.0.0",
  "name" : "ConditionHighlighted",
  "status" : "active",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Search for conditions flagged as highlighted in the SDHRCondition profile",
  "code" : "highlighted",
  "base" : ["Condition"],
  "type" : "token",
  "expression" : "Condition.extension('https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-highlighted-extension')",
  "xpathUsage" : "normal"
}

```
