# OperationOutcomeRecordsWithheldAtSource - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **OperationOutcomeRecordsWithheldAtSource**

## Example OperationOutcome: OperationOutcomeRecordsWithheldAtSource

### Issues

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Severity** | **Code** | **Details** |
| * | Information | Informational Note | Patient has withheld records at source. The operation was successful, but some records were not included in the response due to confidentiality settings. |



## Resource Content

```json
{
  "resourceType" : "OperationOutcome",
  "id" : "OperationOutcomeRecordsWithheldAtSource",
  "issue" : [
    {
      "severity" : "information",
      "code" : "informational",
      "details" : {
        "coding" : [
          {
            "system" : "https://fhir-ig.digital.health.nz/sdhr/CodeSystem/sdhr-outcome-codes",
            "code" : "sdhr-records-withheld-at-source",
            "display" : "Records withheld at source"
          }
        ],
        "text" : "Patient has withheld records at source. The operation was successful, but some records were not included in the response due to confidentiality settings."
      }
    }
  ]
}

```
