# OperationOutcomePatientLocked - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **OperationOutcomePatientLocked**

## Example OperationOutcome: OperationOutcomePatientLocked

### Issues

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Severity** | **Code** | **Details** |
| * | Error | Element value invalid | The patient has been temporarily locked due to a background load process |



## Resource Content

```json
{
  "resourceType" : "OperationOutcome",
  "id" : "OperationOutcomePatientLocked",
  "issue" : [
    {
      "severity" : "error",
      "code" : "value",
      "details" : {
        "coding" : [
          {
            "system" : "https://fhir-ig.digital.health.nz/sdhr/CodeSystem/sdhr-outcome-codes",
            "code" : "sdhr-patient-locked",
            "display" : "SDHR Patient Locked"
          }
        ],
        "text" : "The patient has been temporarily locked due to a background load process"
      }
    }
  ]
}

```
