# OperationOutcomeParticipateInvalidPatient - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **OperationOutcomeParticipateInvalidPatient**

## Example OperationOutcome: OperationOutcomeParticipateInvalidPatient

### Issues

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Severity** | **Code** | **Details** |
| * | Error | Element value invalid | The patient parameter is invalid for the shared digital health record service operation. Please ensure the patient is correctly specified and matches the required NHI Patient URL format. |



## Resource Content

```json
{
  "resourceType" : "OperationOutcome",
  "id" : "OperationOutcomeParticipateInvalidPatient",
  "issue" : [
    {
      "severity" : "error",
      "code" : "value",
      "details" : {
        "coding" : [
          {
            "system" : "https://fhir-ig.digital.health.nz/sdhr/CodeSystem/sdhr-outcome-codes",
            "code" : "sdhr-invalid-patient",
            "display" : "SDHR Invalid Patient"
          }
        ],
        "text" : "The patient parameter is invalid for the shared digital health record service operation. Please ensure the patient is correctly specified and matches the required NHI Patient URL format."
      }
    }
  ]
}

```
