# OperationOutcomeGlobalDenyExample - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **OperationOutcomeGlobalDenyExample**

## Example OperationOutcome: OperationOutcomeGlobalDenyExample

### Issues

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Severity** | **Code** | **Details** |
| * | Error | Information Suppressed | Patient has opted out of participating in the shared digital health record service. |



## Resource Content

```json
{
  "resourceType" : "OperationOutcome",
  "id" : "OperationOutcomeGlobalDenyExample",
  "issue" : [
    {
      "severity" : "error",
      "code" : "suppressed",
      "details" : {
        "coding" : [
          {
            "system" : "https://fhir-ig.digital.health.nz/sdhr/CodeSystem/sdhr-outcome-codes",
            "code" : "sdhr-participation-status-denied",
            "display" : "SDHR Participation Status Denied"
          }
        ],
        "text" : "Patient has opted out of participating in the shared digital health record service."
      }
    }
  ]
}

```
