# OperationOutcomeFacilityUnknown - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **OperationOutcomeFacilityUnknown**

## Example OperationOutcome: OperationOutcomeFacilityUnknown

### Issues

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Severity** | **Code** | **Details** |
| * | Error | Element value invalid | The facility has not been onboarded to SDHR |



## Resource Content

```json
{
  "resourceType" : "OperationOutcome",
  "id" : "OperationOutcomeFacilityUnknown",
  "issue" : [
    {
      "severity" : "error",
      "code" : "value",
      "details" : {
        "coding" : [
          {
            "system" : "https://fhir-ig.digital.health.nz/sdhr/CodeSystem/sdhr-outcome-codes",
            "code" : "sdhr-facility-unknown",
            "display" : "SDHR Facility Unknown"
          }
        ],
        "text" : "The facility has not been onboarded to SDHR"
      }
    }
  ]
}

```
