# OperationOutcomeFacilityLocked - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **OperationOutcomeFacilityLocked**

## Example OperationOutcome: OperationOutcomeFacilityLocked

### Issues

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Severity** | **Code** | **Details** |
| * | Error | Element value invalid | The facility has been temporarily locked due to a background load process |



## Resource Content

```json
{
  "resourceType" : "OperationOutcome",
  "id" : "OperationOutcomeFacilityLocked",
  "issue" : [
    {
      "severity" : "error",
      "code" : "value",
      "details" : {
        "coding" : [
          {
            "system" : "https://fhir-ig.digital.health.nz/sdhr/CodeSystem/sdhr-outcome-codes",
            "code" : "sdhr-facility-locked",
            "display" : "SDHR Facility Locked"
          }
        ],
        "text" : "The facility has been temporarily locked due to a background load process"
      }
    }
  ]
}

```
