# OperationOutcomeFacilityDenyExample - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **OperationOutcomeFacilityDenyExample**

## Example OperationOutcome: OperationOutcomeFacilityDenyExample

### Issues

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Severity** | **Code** | **Details** |
| * | Error | Information Suppressed | Patient has opted out of participating in the shared digital health record service at this facility. |



## Resource Content

```json
{
  "resourceType" : "OperationOutcome",
  "id" : "OperationOutcomeFacilityDenyExample",
  "issue" : [
    {
      "severity" : "error",
      "code" : "suppressed",
      "details" : {
        "coding" : [
          {
            "system" : "https://fhir-ig.digital.health.nz/sdhr/CodeSystem/sdhr-outcome-codes",
            "code" : "sdhr-participation-status-denied-facility",
            "display" : "SDHR Participation Status Denied at Facility"
          }
        ],
        "text" : "Patient has opted out of participating in the shared digital health record service at this facility."
      }
    }
  ]
}

```
