# SDHRParticipateOperation - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **SDHRParticipateOperation**

## OperationDefinition: SDHRParticipateOperation 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/OperationDefinition/SDHRParticipateOperation | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:Participate |

 
This operation allows a patient to choose to participate in the Shared Digital Health Record service. This operation should be used by data providers in the Shared Digital Health Record ecosystem such as Patient Management Systems (PMS) or Electronic Health Record (EHR) systems. It can be used to indicate whether the patient wishes to participate, whether any resources are withheld, and the reason for participation. The scope of this operation is the API consumer - e.g. an HPI Facility where patient data is held. 
Scenarios where this operation might be used include: 
* A patient has opted in to the Shared Digital Health Record service and appropriate data will be shared from the data holder to the service.
* A patient chooses not to participate in the Shared Digital Health Record service and informs their healthcare provider of this choice.
* A patient has one or more confidential records, held at their healthcare provider, that are withheld from the service.
* A patient has previously withheld records but has now released them to the Shared Digital Health Record service.
 
For example payloads that might be used with this operation see: 
* [Parameters resource for total non-participation](./Parameters-ParametersDoNotParticipate.md) : This example shows how to indicate that a patient does not wish to participate in the Shared Digital Health Record service (has opted out).
* [Parameters resource for participation](./Parameters-ParametersParticipate.md) : This example shows how to indicate that a patient wishes to participate in the Shared Digital Health Record service, where previously opted out (opt-in).
* [Parameters resource for partial participation with withheld records](./Parameters-ParametersParticipateRecordWithheld.md) : This example shows how to indicate that a patient has some confidential records that are withheld from the Shared Digital Health Record service.
* [Parameters resource for releasing withheld records](./Parameters-ParametersParticipateRecordReleased.md) : This example shows how to indicate that a patient has previously withheld records but has now released them to the Shared Digital Health Record service.
 
To make a request to this operation the API Consumer must POST a`Parameters`payload to the operation URL (e.g.`POST https://api.sdhr.digital.health.nz/s2s/$participate`). 
The operation is idempotent, meaning that multiple requests with the same parameters will have the same effect as a single request. The operation is expected to be called by a healthcare provider on behalf of the patient, and the patient must be identified by their NHI. The operation will return an OperationOutcome resource indicating the result of the operation. 

URL: [base]/$participate

### Parameters

* **Use**: IN
  * **Name**: patient
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [Reference](http://hl7.org/fhir/R4/references.html#Reference)
  * **Binding**: 
  * **Documentation**: Reference must be an NHI Patient URL with format https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZZZ1111 or ZZZ11AA
* **Use**: IN
  * **Name**: participationIndicator
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [boolean](http://hl7.org/fhir/R4/datatypes.html#boolean)
  * **Binding**: 
  * **Documentation**: Indicates global participation in the Shared Digital Health Record service (true/false) If false, the patient does not wish to participate in the service and their resources will not be shared. This parameter is mandatory when indicating global participation but is not required when indicating partial participation with withheld records (see `resourceType` and `localResourceId` parameters). If an API consumer attempts to POST a record for a patient that has not opted in, the API will return an OperationOutcome with an error message indicating that the patient has not indicated their participation preferences.
* **Use**: IN
  * **Name**: resourceType
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [string](http://hl7.org/fhir/R4/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: The resource type that is being withheld. Must be a valid FHIR resource type supported by the SDHR service, such as `Condition`, `Observation` etc. Note that `AllergyIntolerance` resources MUST NOT be withheld. This parameter is optional and should only be used to specify the type of resource that is withheld from the Shared Digital Health Record service. When this paramter is used the request MUST contain a `reasonCode` parameter and a `localResourceId` parameter.
* **Use**: IN
  * **Name**: facilityId
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [Reference](http://hl7.org/fhir/R4/references.html#Reference)
  * **Binding**: 
  * **Documentation**: The HPI Facility ID of the healthcare provider that is withholding the resource. This parameter is mandatory and must be provided to indicate the healthcare provider that is withholding the resource from the Shared Digital Health Record service. The HPI Facility ID must be a valid HPI Facility ID in the format `https://api.hip.digital.health.nz/fhir/hpi/v1/Location/{hpi-facility-id}`.
* **Use**: IN
  * **Name**: localResourceId
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [string](http://hl7.org/fhir/R4/datatypes.html#string)
  * **Binding**: 
  * **Documentation**: The local resource ID that is withheld from the Shared Digital Health Record service. This parameter is optional and should only be used to specify the local ID of the resource that is withheld. When this paramter is used the request MUST contain a `reasonCode` parameter and a `resourceType` parameter.
* **Use**: IN
  * **Name**: reasonCode
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)
  * **Binding**: [ValueSet for SDHR Participation Reason](ValueSet-sdhr-participation-reason-valueset.md)(Required)
  * **Documentation**: The reason code for participation. This **MUST** be provided when the intent is to indicate a withheld record or when releasing a record. Valid codes include:* `sdhr-record-withheld`: Records withheld from the patient for privacy or confidentiality reasons.
* `sdhr-record-released`: Record that was previously withheld has been released (is no longer confidential or restricted) to the service by the patient.

* **Use**: OUT
  * **Name**: return
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [OperationOutcome](http://hl7.org/fhir/R4/operationoutcome.html)
  * **Binding**: 
  * **Documentation**: The result of the operation. This parameter will contain an OperationOutcome resource indicating the success or failure of the operation. If the operation is successful, the OperationOutcome will contain a success message. If the operation fails, the OperationOutcome will contain an error message indicating the reason for the failure. The OperationOutcome resource will be returned in the response body of the operation request. See the following examples for possible OperationOutcome responses:* [OperationOutcome for invalid patient reference](./OperationOutcome-OperationOutcomeParticipateInvalidPatient.md)
* [OperationOutcome for missing reason code](./OperationOutcome-OperationOutcomeParticipateMissingReason.md)
* [OperationOutcome for successful participation](./OperationOutcome-OperationOutcomeParticipateSuccess.md) Note that the following `OperationOutcome` would be returned when an API Consumer attempts to POST a record for a patient that has not provided their participation preferences:
* [OperationOutcome for participation preferences not known](./OperationOutcome-OperationOutcomeParticipatePreferencesNotKnown.md)




## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "SDHRParticipateOperation",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/OperationDefinition/SDHRParticipateOperation",
  "version" : "1.0.0",
  "name" : "Participate",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This operation allows a patient to choose to participate in the Shared Digital Health Record service.\nThis operation should be used by data providers in the Shared Digital Health Record ecosystem such as Patient Management Systems (PMS) or Electronic Health Record (EHR) systems.\nIt can be used to indicate whether the patient wishes to participate, whether any resources are withheld, and the reason for participation. The scope of this operation is the API consumer - e.g. an HPI Facility where patient data is held.\n\nScenarios where this operation might be used include:\n- A patient has opted in to the Shared Digital Health Record service and appropriate data will be shared from the data holder to the service.\n- A patient chooses not to participate in the Shared Digital Health Record service and informs their healthcare provider of this choice.\n- A patient has one or more confidential records, held at their healthcare provider, that are withheld from the service.\n- A patient has previously withheld records but has now released them to the Shared Digital Health Record service.\n\nFor example payloads that might be used with this operation see:\n- [Parameters resource for total non-participation](./Parameters-ParametersDoNotParticipate.html) : This example shows how to indicate that a patient does not wish to participate in the Shared Digital Health Record service (has opted out).\n- [Parameters resource for participation](./Parameters-ParametersParticipate.html) : This example shows how to indicate that a patient wishes to participate in the Shared Digital Health Record service, where previously opted out (opt-in).\n- [Parameters resource for partial participation with withheld records](./Parameters-ParametersParticipateRecordWithheld.html) : This example shows how to indicate that a patient has some confidential records that are withheld from the Shared Digital Health Record service.\n- [Parameters resource for releasing withheld records](./Parameters-ParametersParticipateRecordReleased.html) : This example shows how to indicate that a patient has previously withheld records but has now released them to the Shared Digital Health Record service.\n\nTo make a request to this operation the API Consumer must POST a `Parameters` payload to the operation URL (e.g. `POST https://api.sdhr.digital.health.nz/s2s/$participate`).\n\nThe operation is idempotent, meaning that multiple requests with the same parameters will have the same effect as a single request.\nThe operation is expected to be called by a healthcare provider on behalf of the patient, and the patient must be identified by their NHI.\nThe operation will return an OperationOutcome resource indicating the result of the operation.",
  "code" : "participate",
  "system" : true,
  "type" : false,
  "instance" : false,
  "parameter" : [
    {
      "name" : "patient",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "Reference must be an NHI Patient URL with format https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZZZ1111 or ZZZ11AA",
      "type" : "Reference"
    },
    {
      "name" : "participationIndicator",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "Indicates global participation in the Shared Digital Health Record service (true/false)\nIf false, the patient does not wish to participate in the service and their resources will not be shared.\nThis parameter is mandatory when indicating global participation but is not required when indicating partial participation with withheld records (see `resourceType` and `localResourceId` parameters).\nIf an API consumer attempts to POST a record for a patient that has not opted in, the API will return an OperationOutcome with an error message indicating that the patient has not indicated their participation preferences.",
      "type" : "boolean"
    },
    {
      "name" : "resourceType",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "The resource type that is being withheld. Must be a valid FHIR resource type supported by the SDHR service, such as `Condition`, `Observation` etc. Note that `AllergyIntolerance` resources MUST NOT be withheld.\n    This parameter is optional and should only be used to specify the type of resource that is withheld from the Shared Digital Health Record service.\n    When this paramter is used the request MUST contain a `reasonCode` parameter and a `localResourceId` parameter.",
      "type" : "string"
    },
    {
      "name" : "facilityId",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The HPI Facility ID of the healthcare provider that is withholding the resource.\n    This parameter is mandatory and must be provided to indicate the healthcare provider that is withholding the resource from the Shared Digital Health Record service.\n    The HPI Facility ID must be a valid HPI Facility ID in the format `https://api.hip.digital.health.nz/fhir/hpi/v1/Location/{hpi-facility-id}`.",
      "type" : "Reference"
    },
    {
      "name" : "localResourceId",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "The local resource ID that is withheld from the Shared Digital Health Record service.\n    This parameter is optional and should only be used to specify the local ID of the resource that is withheld.\n    When this paramter is used the request MUST contain a `reasonCode` parameter and a `resourceType` parameter.",
      "type" : "string"
    },
    {
      "name" : "reasonCode",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "The reason code for participation. This **MUST** be provided when the intent is to indicate a withheld record or when releasing a record.\nValid codes include:\n- `sdhr-record-withheld`: Records withheld from the patient for privacy or confidentiality reasons.\n- `sdhr-record-released`: Record that was previously withheld has been released (is no longer confidential or restricted) to the service by the patient.",
      "type" : "Coding",
      "binding" : {
        "strength" : "required",
        "valueSet" : "https://fhir-ig.digital.health.nz/sdhr/ValueSet/sdhr-participation-reason-valueset"
      }
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "documentation" : "The result of the operation. \nThis parameter will contain an OperationOutcome resource indicating the success or failure of the operation.\nIf the operation is successful, the OperationOutcome will contain a success message.\nIf the operation fails, the OperationOutcome will contain an error message indicating the reason for the failure.\nThe OperationOutcome resource will be returned in the response body of the operation request.\nSee the following examples for possible OperationOutcome responses:\n- [OperationOutcome for invalid patient reference](./OperationOutcome-OperationOutcomeParticipateInvalidPatient.html)\n- [OperationOutcome for missing reason code](./OperationOutcome-OperationOutcomeParticipateMissingReason.html)\n- [OperationOutcome for successful participation](./OperationOutcome-OperationOutcomeParticipateSuccess.html)\nNote that the following `OperationOutcome` would be returned when an API Consumer attempts to POST a record for a patient that has not provided their participation preferences:\n- [OperationOutcome for participation preferences not known](./OperationOutcome-OperationOutcomeParticipatePreferencesNotKnown.html)",
      "type" : "OperationOutcome"
    }
  ]
}

```
