# SDHRHNZParticipateOperation - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **SDHRHNZParticipateOperation**

## OperationDefinition: SDHRHNZParticipateOperation 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/OperationDefinition/SDHRHNZParticipateOperation | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:HNZParticipate |

 
This operation allows a patient to choose to participate in the Shared Digital Health Record service via HNZ assisted channels. This operation should only be used by HNZ channels. 
Scenarios where this operation might be used include: 
* A patient has opted in to the Shared Digital Health Record service by contacting Health NZ via appropriate digital or assisted channels.
* A patient chooses not to participate in the Shared Digital Health Record service and informs Health NZ of this choice via appropriate digital or assisted channels.
 
For example payloads that might be used with this operation see: 
* [Parameters resource for total non-participation](./Parameters-ParametersHNZParticipateOptOut.md) : This example shows how to indicate that a patient does not wish to participate in the Shared Digital Health Record service (has opted out).
* [Parameters resource for participation](./Parameters-ParametersHNZParticipateOptIn.md) : This example shows how to indicate that a patient wishes to participate in the Shared Digital Health Record service.
 
To make a request to this operation the API Consumer must POST a`Parameters`payload to the operation URL (e.g.`POST https://api.sdhr.digital.health.nz/s2s/$hnz-participate`). 
The operation is idempotent, meaning that multiple requests with the same parameters will have the same effect as a single request. The operation is expected to be called by a Health NZ channel system on behalf of the patient, and the patient must be identified by their NHI. The operation will return an OperationOutcome resource indicating the result of the operation. 

URL: [base]/$hnz-participate

### Parameters

* **Use**: IN
  * **Name**: patient
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [Reference](http://hl7.org/fhir/R4/references.html#Reference)
  * **Binding**: 
  * **Documentation**: Reference must be an NHI Patient URL with format https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZZZ1111 or ZZZ11AA
* **Use**: IN
  * **Name**: hnzParticipationIndicator
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [boolean](http://hl7.org/fhir/R4/datatypes.html#boolean)
  * **Binding**: 
  * **Documentation**: Indicates global participation in the Shared Digital Health Record service (true/false) If false, the patient does not wish to participate in the service and their resources will not be shared.
* **Use**: OUT
  * **Name**: return
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [OperationOutcome](http://hl7.org/fhir/R4/operationoutcome.html)
  * **Binding**: 
  * **Documentation**: The result of the operation. This parameter will contain an OperationOutcome resource indicating the success or failure of the operation. If the operation is successful, the OperationOutcome will contain a success message. If the operation fails, the OperationOutcome will contain an error message indicating the reason for the failure. The OperationOutcome resource will be returned in the response body of the operation request. See the following examples for possible OperationOutcome responses: - [OperationOutcome for invalid patient reference](./OperationOutcome-OperationOutcomeParticipateInvalidPatient.md) - [OperationOutcome for successful participation](./OperationOutcome-OperationOutcomeParticipateSuccess.md)



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "SDHRHNZParticipateOperation",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/OperationDefinition/SDHRHNZParticipateOperation",
  "version" : "1.0.0",
  "name" : "HNZParticipate",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This operation allows a patient to choose to participate in the Shared Digital Health Record service via HNZ assisted channels.\nThis operation should only be used by HNZ channels.\n\nScenarios where this operation might be used include:\n- A patient has opted in to the Shared Digital Health Record service by contacting Health NZ via appropriate digital or assisted channels.\n- A patient chooses not to participate in the Shared Digital Health Record service and informs Health NZ of this choice via appropriate digital or assisted channels.\n\nFor example payloads that might be used with this operation see:\n- [Parameters resource for total non-participation](./Parameters-ParametersHNZParticipateOptOut.html) : This example shows how to indicate that a patient does not wish to participate in the Shared Digital Health Record service (has opted out).\n- [Parameters resource for participation](./Parameters-ParametersHNZParticipateOptIn.html) : This example shows how to indicate that a patient wishes to participate in the Shared Digital Health Record service.\n\nTo make a request to this operation the API Consumer must POST a `Parameters` payload to the operation URL (e.g. `POST https://api.sdhr.digital.health.nz/s2s/$hnz-participate`).\n\nThe operation is idempotent, meaning that multiple requests with the same parameters will have the same effect as a single request.\nThe operation is expected to be called by a Health NZ channel system on behalf of the patient, and the patient must be identified by their NHI.\nThe operation will return an OperationOutcome resource indicating the result of the operation.",
  "code" : "hnz-participate",
  "system" : true,
  "type" : false,
  "instance" : false,
  "parameter" : [
    {
      "name" : "patient",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "Reference must be an NHI Patient URL with format https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZZZ1111 or ZZZ11AA",
      "type" : "Reference"
    },
    {
      "name" : "hnzParticipationIndicator",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "Indicates global participation in the Shared Digital Health Record service (true/false)\nIf false, the patient does not wish to participate in the service and their resources will not be shared.",
      "type" : "boolean"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "documentation" : "The result of the operation.\n    This parameter will contain an OperationOutcome resource indicating the success or failure of the operation.\n    If the operation is successful, the OperationOutcome will contain a success message.\n    If the operation fails, the OperationOutcome will contain an error message indicating the reason for the failure.\n    The OperationOutcome resource will be returned in the response body of the operation request.\n    See the following examples for possible OperationOutcome responses:\n    - [OperationOutcome for invalid patient reference](./OperationOutcome-OperationOutcomeParticipateInvalidPatient.html)\n    - [OperationOutcome for successful participation](./OperationOutcome-OperationOutcomeParticipateSuccess.html)",
      "type" : "OperationOutcome"
    }
  ]
}

```
