# ObservationVitalSignsExample - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **ObservationVitalSignsExample**

## Example Observation: ObservationVitalSignsExample

version: 1; Last updated: 2025-01-26 00:21:56+0000; 

Information Source: [https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B)

Profile: [SDHRObservation](StructureDefinition-SDHRObservation.md)

**Client Last Updated**: 2024-11-26 10:02:45+1300

**identifier**: `https://fhir.examplepms.co.nz`/ec2d6cad-1e19-46ee-accf-dc460a680710 (use: secondary, )

**status**: Final

**category**: Vital Signs

**code**: Measurement procedure (procedure)

**subject**: [Sage Westbrook](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284)

**effective**: 2024-12-12 04:22:55+0000

**issued**: 2024-12-12 04:22:55+0000

**performer**: [DR Beverly Crusher](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/91ZZXZ)

> **component****code**:Systolic blood pressure**value**: 73 mmHg(Details: UCUM codemm[Hg] = 'mm[Hg]')

> **component****code**:Diastolic blood pressure**value**: 73 mmHg(Details: UCUM codemm[Hg] = 'mm[Hg]')

> **component****code**:Heart rate**value**: 44 beats/minute(Details: UCUM code/min = '/min')

> **component****code**:R-R interval.standard deviation (Heart rate variability)**value**: 44 milliseconds(Details: UCUM codems = 'ms')

> **component****code**:Respiratory rate**value**: 17 breaths/minute(Details: UCUM code/min = '/min')

> **component****code**:Body temperature**value**: 38 degree Celsius(Details: UCUM codeCel = 'Cel')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "ObservationVitalSignsExample",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2025-01-26T00:21:56.607Z",
    "source" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B",
    "profile" : [
      "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRObservation"
    ]
  },
  "extension" : [
    {
      "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-client-last-updated-extension",
      "valueDateTime" : "2024-11-26T10:02:45+13:00"
    }
  ],
  "identifier" : [
    {
      "use" : "secondary",
      "system" : "https://fhir.examplepms.co.nz",
      "value" : "ec2d6cad-1e19-46ee-accf-dc460a680710"
    }
  ],
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "122869004",
        "display" : "Measurement procedure (procedure)"
      }
    ]
  },
  "subject" : {
    "reference" : "https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284",
    "type" : "Patient",
    "display" : "Sage Westbrook"
  },
  "effectiveDateTime" : "2024-12-12T04:22:55.965Z",
  "issued" : "2024-12-12T04:22:55.965Z",
  "performer" : [
    {
      "reference" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/91ZZXZ",
      "type" : "Practitioner",
      "display" : "DR Beverly Crusher"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8480-6",
            "display" : "Systolic blood pressure",
            "userSelected" : true
          }
        ]
      },
      "valueQuantity" : {
        "value" : 73,
        "unit" : "mmHg",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8462-4",
            "display" : "Diastolic blood pressure",
            "userSelected" : true
          }
        ]
      },
      "valueQuantity" : {
        "value" : 73,
        "unit" : "mmHg",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8867-4",
            "display" : "Heart rate",
            "userSelected" : true
          }
        ]
      },
      "valueQuantity" : {
        "value" : 44,
        "unit" : "beats/minute",
        "system" : "http://unitsofmeasure.org",
        "code" : "/min"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "80404-7",
            "display" : "R-R interval.standard deviation (Heart rate variability)",
            "userSelected" : true
          }
        ]
      },
      "valueQuantity" : {
        "value" : 44,
        "unit" : "milliseconds",
        "system" : "http://unitsofmeasure.org",
        "code" : "ms"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "9279-1",
            "display" : "Respiratory rate",
            "userSelected" : true
          }
        ]
      },
      "valueQuantity" : {
        "value" : 17,
        "unit" : "breaths/minute",
        "system" : "http://unitsofmeasure.org",
        "code" : "/min"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8310-5",
            "display" : "Body temperature",
            "userSelected" : true
          }
        ]
      },
      "valueQuantity" : {
        "value" : 38,
        "unit" : "degree Celsius",
        "system" : "http://unitsofmeasure.org",
        "code" : "Cel"
      }
    }
  ]
}

```
