# ConsentExampleRecordsWithheld - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **ConsentExampleRecordsWithheld**

## Example Consent: ConsentExampleRecordsWithheld

Profile: [SDHRConsent](StructureDefinition-SDHRConsent.md)

**identifier**: 93f28be6-4787-40f1-ae39-64233eb2cf7c (use: secondary, )

**status**: Active

**scope**: Privacy Consent

**category**: Consent for information sharing

**patient**: [Sage Westbrook](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284)

### Policies

| | | |
| :--- | :--- | :--- |
| - | **Authority** | **Uri** |
| * | [https://www.privacy.org.nz](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://www.privacy.org.nz) | [https://www.privacy.org.nz/privacy-act-2020](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://www.privacy.org.nz/privacy-act-2020) |

> **provision****type**: Opt In**period**: 2023-10-04 --> (ongoing)**action**:access
> **provision****Facility Participation**:Facility opt in**type**: Opt Out

### Actors

| | | |
| :--- | :--- | :--- |
| - | **Role** | **Reference** |
| * | PROV | [https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ111-A](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ111-A) |

> **data****meaning**: Instance**reference**:[Condition/local-pms-id](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=http://fhir.org.nz/ig/base/Condition/local-pms-id)

> **data****meaning**: Instance**reference**:[Condition/another-local-pms-id](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=http://fhir.org.nz/ig/base/Condition/another-local-pms-id)




## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "ConsentExampleRecordsWithheld",
  "meta" : {
    "profile" : [
      "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRConsent"
    ]
  },
  "identifier" : [
    {
      "use" : "secondary",
      "value" : "93f28be6-4787-40f1-ae39-64233eb2cf7c"
    }
  ],
  "status" : "active",
  "scope" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
        "code" : "patient-privacy"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "887031000000108",
          "display" : "Consent for information sharing"
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284",
    "type" : "Patient",
    "display" : "Sage Westbrook"
  },
  "policy" : [
    {
      "authority" : "https://www.privacy.org.nz",
      "uri" : "https://www.privacy.org.nz/privacy-act-2020"
    }
  ],
  "provision" : {
    "type" : "permit",
    "period" : {
      "start" : "2023-10-04"
    },
    "action" : [
      {
        "coding" : [
          {
            "code" : "access"
          }
        ]
      }
    ],
    "provision" : [
      {
        "extension" : [
          {
            "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/facility-participation-extension",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "code" : "sdhr-facility-opt-in",
                  "display" : "Facility opt in"
                }
              ]
            }
          }
        ],
        "type" : "deny",
        "actor" : [
          {
            "role" : {
              "coding" : [
                {
                  "code" : "PROV"
                }
              ]
            },
            "reference" : {
              "reference" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ111-A"
            }
          }
        ],
        "data" : [
          {
            "meaning" : "instance",
            "reference" : {
              "reference" : "Condition/local-pms-id"
            }
          },
          {
            "meaning" : "instance",
            "reference" : {
              "reference" : "Condition/another-local-pms-id"
            }
          }
        ]
      }
    ]
  }
}

```
