# ConsentExample - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **ConsentExample**

## Example Consent: ConsentExample

Profile: [SDHRConsent](StructureDefinition-SDHRConsent.md)

**identifier**: 93f28be6-4787-40f1-ae39-64233eb2cf7c (use: secondary, )

**status**: Active

**scope**: Privacy Consent

**category**: Consent for information sharing

**patient**: [Sage Westbrook](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284)

### Policies

| | | |
| :--- | :--- | :--- |
| - | **Authority** | **Uri** |
| * | [https://www.privacy.org.nz](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://www.privacy.org.nz) | [https://www.privacy.org.nz/privacy-act-2020](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://www.privacy.org.nz/privacy-act-2020) |

### Provisions

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Type** | **Period** | **Action** |
| * | Opt In | 2023-10-04 --> (ongoing) | access |



## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "ConsentExample",
  "meta" : {
    "profile" : [
      "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRConsent"
    ]
  },
  "identifier" : [
    {
      "use" : "secondary",
      "value" : "93f28be6-4787-40f1-ae39-64233eb2cf7c"
    }
  ],
  "status" : "active",
  "scope" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
        "code" : "patient-privacy"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "887031000000108",
          "display" : "Consent for information sharing"
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284",
    "type" : "Patient",
    "display" : "Sage Westbrook"
  },
  "policy" : [
    {
      "authority" : "https://www.privacy.org.nz",
      "uri" : "https://www.privacy.org.nz/privacy-act-2020"
    }
  ],
  "provision" : {
    "type" : "permit",
    "period" : {
      "start" : "2023-10-04"
    },
    "action" : [
      {
        "coding" : [
          {
            "code" : "access"
          }
        ]
      }
    ]
  }
}

```
