# ConditionRespiratoryExample - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **ConditionRespiratoryExample**

## Example Condition: ConditionRespiratoryExample

Last updated: 2024-01-26 10:03:26+1300; 

Information Source: [https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B)

Profile: [SDHRCondition](StructureDefinition-SDHRCondition.md)

**Long Term Condition Indicator**: false

**Client Last Updated**: 2025-01-26 10:02:45+1300

**identifier**: `https://fhir.examplepms.co.nz`/ec2d6cad-1e19-46ee-accf-dc460a680710 (use: secondary, )

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**code**: Acute up resp tract infection

**subject**: [Sage Westbrook](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284)

**onset**: 2011-02-05 00:00:00+1300

**recordedDate**: 2023-11-26 10:02:45+1300

**recorder**: [DR Julian Subatoi Bashir](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/91ZZXN)

**asserter**: [Dottie McStuffins](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/99ZZZZ)



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "ConditionRespiratoryExample",
  "meta" : {
    "lastUpdated" : "2024-01-26T10:03:26+13:00",
    "source" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B",
    "profile" : [
      "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRCondition"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/long-term-condition",
      "valueBoolean" : false
    },
    {
      "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-client-last-updated-extension",
      "valueDateTime" : "2025-01-26T10:02:45+13:00"
    }
  ],
  "identifier" : [
    {
      "use" : "secondary",
      "system" : "https://fhir.examplepms.co.nz",
      "value" : "ec2d6cad-1e19-46ee-accf-dc460a680710"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://health.govt.nz/read-codes",
        "code" : "H051.00",
        "display" : "Acute up resp tract infection"
      }
    ]
  },
  "subject" : {
    "reference" : "https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284",
    "type" : "Patient",
    "display" : "Sage Westbrook"
  },
  "onsetDateTime" : "2011-02-05T00:00:00+13:00",
  "recordedDate" : "2023-11-26T10:02:45+13:00",
  "recorder" : {
    "reference" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/91ZZXN",
    "type" : "Practitioner",
    "display" : "DR Julian Subatoi Bashir"
  },
  "asserter" : {
    "reference" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/99ZZZZ",
    "type" : "Practitioner",
    "display" : "Dottie McStuffins"
  }
}

```
