# ConditionHypertensionExample - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **ConditionHypertensionExample**

## Example Condition: ConditionHypertensionExample

Last updated: 2024-01-26 10:03:26+1300; 

Information Source: [https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B)

Profile: [SDHRCondition](StructureDefinition-SDHRCondition.md)

**Long Term Condition Indicator**: true

**Client Last Updated**: 2023-11-26 10:02:45+1300

**HNZ SDHR Highlighted**: true

**identifier**: `https://fhir.examplepms.co.nz`/ec2d6cad-1e19-46ee-accf-dc460a680710 (use: secondary, )

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**code**: Hypertension

**subject**: [Sage Westbrook](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284)

**onset**: 2011-02-05 00:00:00+1300

**recordedDate**: 2023-11-26 10:02:45+1300

**recorder**: [Dottie McStuffins](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/99ZZZZ)

**asserter**: [DR Julian Subatoi Bashir](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/91ZZXN)



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "ConditionHypertensionExample",
  "meta" : {
    "lastUpdated" : "2024-01-26T10:03:26+13:00",
    "source" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B",
    "profile" : [
      "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRCondition"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/long-term-condition",
      "valueBoolean" : true
    },
    {
      "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-client-last-updated-extension",
      "valueDateTime" : "2023-11-26T10:02:45+13:00"
    },
    {
      "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-highlighted-extension",
      "valueBoolean" : true
    }
  ],
  "identifier" : [
    {
      "use" : "secondary",
      "system" : "https://fhir.examplepms.co.nz",
      "value" : "ec2d6cad-1e19-46ee-accf-dc460a680710"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "38341003",
        "display" : "HT - Hypertension"
      }
    ],
    "text" : "Hypertension"
  },
  "subject" : {
    "reference" : "https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284",
    "type" : "Patient",
    "display" : "Sage Westbrook"
  },
  "onsetDateTime" : "2011-02-05T00:00:00+13:00",
  "recordedDate" : "2023-11-26T10:02:45+13:00",
  "recorder" : {
    "reference" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/99ZZZZ",
    "type" : "Practitioner",
    "display" : "Dottie McStuffins"
  },
  "asserter" : {
    "reference" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/91ZZXN",
    "type" : "Practitioner",
    "display" : "DR Julian Subatoi Bashir"
  }
}

```
