# SDHR Participation Reason Codes - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **SDHR Participation Reason Codes**

## CodeSystem: SDHR Participation Reason Codes 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/CodeSystem/sdhr-participation-reason | *Version*:1.0.0 |
| Draft as of 2025-11-18 | *Computable Name*:SDHRParticipationReason |

 
This code system defines the reasons for a patient to participate in the Shared Digital Health Record service. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SDHRParticipationReasonValueSet](ValueSet-sdhr-participation-reason-valueset.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "sdhr-participation-reason",
  "meta" : {
    "versionId" : "1"
  },
  "url" : "https://fhir-ig.digital.health.nz/sdhr/CodeSystem/sdhr-participation-reason",
  "version" : "1.0.0",
  "name" : "SDHRParticipationReason",
  "title" : "SDHR Participation Reason Codes",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This code system defines the reasons for a patient to participate in the Shared Digital Health Record service.",
  "content" : "complete",
  "count" : 6,
  "concept" : [
    {
      "code" : "sdhr-record-withheld",
      "display" : "Record withheld",
      "definition" : "Record withheld from the service for privacy or confidentiality reasons."
    },
    {
      "code" : "sdhr-record-released",
      "display" : "Record released",
      "definition" : "Record that was previously withheld has been released (is no longer confidential or restricted) to the service by the patient."
    },
    {
      "code" : "sdhr-facility-opt-out",
      "display" : "Facility opt out",
      "definition" : "Patient has opted out of participation entirely at the facility. This means that no records will be shared from that facility."
    },
    {
      "code" : "sdhr-facility-opt-in",
      "display" : "Facility opt in",
      "definition" : "Patient has opted in to participation at the facility. This means that records will be shared from that facility."
    },
    {
      "code" : "sdhr-hnz-opt-out",
      "display" : "HNZ opt out",
      "definition" : "Patient has opted out of participation entirely with Health NZ. This means that no records will be shared from any facility."
    },
    {
      "code" : "sdhr-hnz-opt-in",
      "display" : "HNZ opt in",
      "definition" : "Patient has opted in to participation with Health NZ. This means that records will be shared from all facilities."
    }
  ]
}

```
