# SDHR Specific Outcome Codes - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **SDHR Specific Outcome Codes**

## CodeSystem: SDHR Specific Outcome Codes 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/CodeSystem/sdhr-outcome-codes | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:SDHROutcomeCodes |

 
This code system defines standard OperationOucome codes used throughout this Implementation Guide for New Zealand Shared Digital Health Records 

 
The codes defined in this CodeSystem are used by the Shared Digital Health Record service to indicate the outcome of operations. 
These codes will be used in various`OperationOutcome`resources to provide feedback on the outcome of a request. 
See[SDHR Participate Operation](https://fhir-ig.digital.health.nz/sdhr/OperationDefinition/SDHRParticipateOperation)for more example information on the use of these codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "sdhr-outcome-codes",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/CodeSystem/sdhr-outcome-codes",
  "version" : "1.0.0",
  "name" : "SDHROutcomeCodes",
  "title" : "SDHR Specific Outcome Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This code system defines standard OperationOucome codes used throughout this Implementation Guide for New Zealand Shared Digital Health Records",
  "purpose" : "The codes defined in this CodeSystem are used by the Shared Digital Health Record service to indicate the outcome of\noperations.\n\nThese codes will be used in various `OperationOutcome` resources to provide feedback on the outcome of a request.\n\nSee [SDHR Participate Operation](https://fhir-ig.digital.health.nz/sdhr/OperationDefinition/SDHRParticipateOperation) for more example information on the use of these codes.\n",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 12,
  "concept" : [
    {
      "code" : "sdhr-records-withheld-at-source",
      "display" : "Records withheld at source",
      "definition" : "This code is used when the patient has records that are withheld from the Shared Digital Health Record service at source, for example, a GP practice or hospital."
    },
    {
      "code" : "sdhr-participation-status-denied",
      "display" : "SDHR Participation Status Denied",
      "definition" : "This code is used when the patient has opted out of participating in the Shared Digital Health Record service."
    },
    {
      "code" : "sdhr-participation-status-denied-facility",
      "display" : "SDHR Participation Status Denied at Facility",
      "definition" : "This code is used when the patient has opted out of participating in the Shared Digital Health Record service at a specific facility."
    },
    {
      "code" : "sdhr-invalid-patient",
      "display" : "SDHR Invalid Patient",
      "definition" : "This code is used when the patient parameter is invalid for the Shared Digital Health Record service operation. Please ensure the patient is correctly specified and matches the required NHI Patient URL format."
    },
    {
      "code" : "sdhr-parameter-missing",
      "display" : "SDHR Required parameter missing",
      "definition" : "This code is used when a required parameter is missing in the request, such as the reasonCode parameter."
    },
    {
      "code" : "sdhr-parameter-invalid",
      "display" : "SDHR parameter invalid",
      "definition" : "This code is used when a parameter is invalid in the request."
    },
    {
      "code" : "sdhr-participation-status-invalid",
      "display" : "SDHR Participation Status Invalid"
    },
    {
      "code" : "sdhr-operation-success",
      "display" : "SDHR Operation Success",
      "definition" : "This code is used when the operation was successful, such as when a patient's participation status was successfully recorded."
    },
    {
      "code" : "sdhr-participation-status-unknown",
      "display" : "SDHR Participation Status Unknown",
      "definition" : "This code is used when the Shared Digital Health Record service has no record of participation preferences for this patient. Please use the $participate operation to indicate the patient's participation preferences."
    },
    {
      "code" : "sdhr-facility-locked",
      "display" : "SDHR Facility Locked",
      "definition" : "This code is used when a facility has been temporarily locked due to a background load process"
    },
    {
      "code" : "sdhr-patient-locked",
      "display" : "SDHR Patient Locked",
      "definition" : "This code is used when a patient has been temporarily locked due to a background load process"
    },
    {
      "code" : "sdhr-facility-unknown",
      "display" : "SDHR Facility Unknown",
      "definition" : "This code is used when a facility has not been onboarded to SDHR"
    }
  ]
}

```
