# NZ-specific terminology for Shared Digital Health Records - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **NZ-specific terminology for Shared Digital Health Records**

## CodeSystem: NZ-specific terminology for Shared Digital Health Records 

| | |
| :--- | :--- |
| *Official URL*:https://fhir-ig.digital.health.nz/sdhr/CodeSystem/nz-sdhr-codesystem | *Version*:1.0.0 |
| Active as of 2025-11-18 | *Computable Name*:SDHRCodeSystem |

 
This system defines standard codes used throughout this Implementation Guide for New Zealand Shared Digital Health Records 

 
The codes defined in this CodeSystem are used throughout the SDHR IG, including in resource profiles. 
Note: When available these codes will be sourced from the NZHTS Implementation Guide 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SDHRResourceTagsValueSet](ValueSet-sdhr-resource-tags-valueset.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "nz-sdhr-codesystem",
  "url" : "https://fhir-ig.digital.health.nz/sdhr/CodeSystem/nz-sdhr-codesystem",
  "version" : "1.0.0",
  "name" : "SDHRCodeSystem",
  "title" : "NZ-specific terminology for Shared Digital Health Records",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-18T19:29:08+00:00",
  "publisher" : "Health New Zealand",
  "contact" : [
    {
      "name" : "Health New Zealand",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/tewhatuora"
        }
      ]
    },
    {
      "name" : "HNZ Integration Team",
      "telecom" : [
        {
          "system" : "email",
          "value" : "integration@tewhatuora.govt.nz",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This system defines standard codes used throughout this Implementation Guide for New Zealand Shared Digital Health Records",
  "purpose" : "The codes defined in this CodeSystem are used throughout the SDHR IG, including in resource profiles.\n\nNote: When available these codes will be sourced from the NZHTS Implementation Guide\n",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 2,
  "concept" : [
    {
      "code" : "sdhr-usability-flags",
      "display" : "These codes are intended to be applied as `Meta.tag` indicators so that API Consumers are able apply local visibility or usability rules."
    },
    {
      "code" : "highlighted",
      "display" : "Highlighted",
      "definition" : "This code indicates that the resource is important and, for example, should be highlighted in a user interface."
    }
  ]
}

```
