# SearchExactMatchRecordWithheldExample - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **SearchExactMatchRecordWithheldExample**

## Example Bundle: SearchExactMatchRecordWithheldExample

Last updated: 2025-04-29 23:35:29+0000

Bundle SearchExactMatchRecordWithheldExample of type searchset

-------

Entry 1

Search:Mode = outcome

Resource OperationOutcome:

> All OK



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "SearchExactMatchRecordWithheldExample",
  "meta" : {
    "lastUpdated" : "2025-04-29T23:35:29.795Z"
  },
  "type" : "searchset",
  "total" : 0,
  "link" : [
    {
      "relation" : "self",
      "url" : "https://api.mock.sdhr.digital.health.nz/s2s/Condition?patient=https%3A%2F%2Fapi.hip.digital.health.nz%2Ffhir%2Fnhi%2Fv1%2FPatient%2FZKC4633&_source=https%3A%2F%2Fapi.hip.digital.health.nz%2Ffhir%2FLocation%2FF38006-B&identifier=6b8a6cc1-612f-456e-89df-9fbcd753acb2"
    }
  ],
  "entry" : [
    {
      "resource" : {
        "resourceType" : "OperationOutcome",
        "id" : "OperationOutcomeRecordsWithheldAtSource",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"OperationOutcome_OperationOutcomeRecordsWithheldAtSource\"> </a><p class=\"res-header-id\"><b>Generated Narrative: OperationOutcome OperationOutcomeRecordsWithheldAtSource</b></p><a name=\"OperationOutcomeRecordsWithheldAtSource\"> </a><a name=\"hcOperationOutcomeRecordsWithheldAtSource\"> </a><h3>Issues</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Severity</b></td><td><b>Code</b></td><td><b>Details</b></td></tr><tr><td style=\"display: none\">*</td><td>Information</td><td>Informational Note</td><td><span title=\"Codes:{https://fhir-ig.digital.health.nz/sdhr/CodeSystem/sdhr-outcome-codes sdhr-records-withheld-at-source}\">Patient has withheld records at source. The operation was successful, but some records were not included in the response due to confidentiality settings.</span></td></tr></table></div>"
        },
        "issue" : [
          {
            "severity" : "information",
            "code" : "informational",
            "details" : {
              "coding" : [
                {
                  "system" : "https://fhir-ig.digital.health.nz/sdhr/CodeSystem/sdhr-outcome-codes",
                  "code" : "sdhr-records-withheld-at-source",
                  "display" : "Records withheld at source"
                }
              ],
              "text" : "Patient has withheld records at source. The operation was successful, but some records were not included in the response due to confidentiality settings."
            }
          }
        ]
      },
      "search" : {
        "mode" : "outcome"
      }
    }
  ]
}

```
