# SearchConditionResponseExample - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **SearchConditionResponseExample**

## Example Bundle: SearchConditionResponseExample

Last updated: 2025-04-29 23:35:29+0000

Bundle SearchConditionResponseExample of type searchset

-------

Entry 1 - fullUrl = https://api.mock.sdhr.digital.health.nz/s2s/Condition/ConditionHypertensionExample

Search:Mode = match

Resource Condition:

> 

Last updated: 2024-01-26 10:03:26+1300; 

Information Source: [https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B)

Profile: [SDHRCondition](StructureDefinition-SDHRCondition.md)

**Long Term Condition Indicator**: true**Client Last Updated**: 2023-11-26 10:02:45+1300**HNZ SDHR Highlighted**: true**identifier**:`https://fhir.examplepms.co.nz`/ec2d6cad-1e19-46ee-accf-dc460a680710 (use: secondary, )**clinicalStatus**:Active**verificationStatus**:Confirmed**code**:Hypertension**subject**:[Sage Westbrook](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284)**onset**: 2011-02-05 00:00:00+1300**recordedDate**: 2023-11-26 10:02:45+1300



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "SearchConditionResponseExample",
  "meta" : {
    "lastUpdated" : "2025-04-29T23:35:29.795Z"
  },
  "type" : "searchset",
  "total" : 1,
  "link" : [
    {
      "relation" : "self",
      "url" : "https://api.mock.sdhr.digital.health.nz/s2s/Condition?code=http%3A%2F%2Fsnomed.info%2Fsct%7C38341003&subject=https%3A%2F%2Fapi.hip.digital.health.nz%2Ffhir%2Fnhi%2Fv1%2FPatient%2FZKC7284"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "https://api.mock.sdhr.digital.health.nz/s2s/Condition/ConditionHypertensionExample",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "ConditionHypertensionExample",
        "meta" : {
          "lastUpdated" : "2024-01-26T10:03:26+13:00",
          "source" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B",
          "profile" : [
            "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRCondition"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_ConditionHypertensionExample\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition ConditionHypertensionExample</b></p><a name=\"ConditionHypertensionExample\"> </a><a name=\"hcConditionHypertensionExample\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">Last updated: 2024-01-26 10:03:26+1300; </p><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&amp;canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B\">https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SDHRCondition.html\">SDHRCondition</a></p></div><p><b>Long Term Condition Indicator</b>: true</p><p><b>Client Last Updated</b>: 2023-11-26 10:02:45+1300</p><p><b>HNZ SDHR Highlighted</b>: true</p><p><b>identifier</b>: <code>https://fhir.examplepms.co.nz</code>/ec2d6cad-1e19-46ee-accf-dc460a680710 (use: secondary, )</p><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 38341003}\">Hypertension</span></p><p><b>subject</b>: <a href=\"https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&amp;canonical=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284\">Sage Westbrook</a></p><p><b>onset</b>: 2011-02-05 00:00:00+1300</p><p><b>recordedDate</b>: 2023-11-26 10:02:45+1300</p><p><b>recorder</b>: <a href=\"https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&amp;canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/99ZZZZ\">Dottie McStuffins</a></p><p><b>asserter</b>: <a href=\"https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&amp;canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/91ZZXN\">DR Julian Subatoi Bashir</a></p></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org.nz/fhir/StructureDefinition/long-term-condition",
            "valueBoolean" : true
          },
          {
            "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-client-last-updated-extension",
            "valueDateTime" : "2023-11-26T10:02:45+13:00"
          },
          {
            "url" : "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/hnz-sdhr-highlighted-extension",
            "valueBoolean" : true
          }
        ],
        "identifier" : [
          {
            "use" : "secondary",
            "system" : "https://fhir.examplepms.co.nz",
            "value" : "ec2d6cad-1e19-46ee-accf-dc460a680710"
          }
        ],
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "38341003",
              "display" : "HT - Hypertension"
            }
          ],
          "text" : "Hypertension"
        },
        "subject" : {
          "reference" : "https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284",
          "type" : "Patient",
          "display" : "Sage Westbrook"
        },
        "onsetDateTime" : "2011-02-05T00:00:00+13:00",
        "recordedDate" : "2023-11-26T10:02:45+13:00",
        "recorder" : {
          "reference" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/99ZZZZ",
          "type" : "Practitioner",
          "display" : "Dottie McStuffins"
        },
        "asserter" : {
          "reference" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/91ZZXN",
          "type" : "Practitioner",
          "display" : "DR Julian Subatoi Bashir"
        }
      },
      "search" : {
        "mode" : "match"
      }
    }
  ]
}

```
