# Batch-example - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **Batch-example**

## Example Bundle: Batch-example

Profile: [Batch Bundle with a Single Patient](StructureDefinition-SDHRBatchBundle.md)

Bundle Batch-example of type batch

-------

Entry 1 - fullUrl = urn:uuid:2c9a5a2b-4b2a-4d2a-a9e2-2a7e9f6f0c01

Resource Condition:

> 

Information Source: [https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ999-B](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ999-B)

Profile: [SDHRCondition](StructureDefinition-SDHRCondition.md)

**Long Term Condition Indicator**: true**identifier**:`https://fhir.examplepms.co.nz`/ec2d6cad-1e19-46ee-accf-dc460a680710 (use: secondary, )**clinicalStatus**:Active**verificationStatus**:Confirmed**code**:Hypertension**subject**:[Sage Westbrook](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZMW6002)**onset**: 2011-02-05 00:00:00+1300**recordedDate**: 2023-11-26 10:02:45+1300

Request:

```
POST Condition

```

-------

Entry 2 - fullUrl = urn:uuid:1d8e3b41-5a29-4c43-8d0d-6e1d0b0f5a02

Resource Condition:

> 

Profile: [SDHRCondition](StructureDefinition-SDHRCondition.md)

**clinicalStatus**:Inactive**verificationStatus**:Confirmed**code**:Hypertension**subject**:[Sage Westbrook](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZMW6003)**recordedDate**: 2025-08-20 10:02:45+1200

Request:

```
PUT Condition/Inline-Condition-2

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "Batch-example",
  "meta" : {
    "profile" : [
      "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRBatchBundle"
    ]
  },
  "type" : "batch",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:2c9a5a2b-4b2a-4d2a-a9e2-2a7e9f6f0c01",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "Inline-Condition-1",
        "meta" : {
          "source" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ999-B",
          "profile" : [
            "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRCondition"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_Inline-Condition-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition Inline-Condition-1</b></p><a name=\"Inline-Condition-1\"> </a><a name=\"hcInline-Condition-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&amp;canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ999-B\">https://api.hip.digital.health.nz/fhir/hpi/v1/Location/FZZ999-B</a></p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SDHRCondition.html\">SDHRCondition</a></p></div><p><b>Long Term Condition Indicator</b>: true</p><p><b>identifier</b>: <code>https://fhir.examplepms.co.nz</code>/ec2d6cad-1e19-46ee-accf-dc460a680710 (use: secondary, )</p><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 38341003}\">Hypertension</span></p><p><b>subject</b>: <a href=\"https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&amp;canonical=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZMW6002\">Sage Westbrook</a></p><p><b>onset</b>: 2011-02-05 00:00:00+1300</p><p><b>recordedDate</b>: 2023-11-26 10:02:45+1300</p><p><b>recorder</b>: <a href=\"https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&amp;canonical=https://api.hip.digital.health.nz/fhir/Practitioner/99ZZZZ\">Dottie McStuffins</a></p><p><b>asserter</b>: <a href=\"https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&amp;canonical=https://api.hip.digital.health.nz/fhir/Practitioner/91ZZXN\">DR Julian Subatoi Bashir</a></p></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org.nz/fhir/StructureDefinition/long-term-condition",
            "valueBoolean" : true
          }
        ],
        "identifier" : [
          {
            "use" : "secondary",
            "system" : "https://fhir.examplepms.co.nz",
            "value" : "ec2d6cad-1e19-46ee-accf-dc460a680710"
          }
        ],
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "38341003",
              "display" : "HT - Hypertension"
            }
          ],
          "text" : "Hypertension"
        },
        "subject" : {
          "reference" : "https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZMW6002",
          "type" : "Patient",
          "display" : "Sage Westbrook"
        },
        "onsetDateTime" : "2011-02-05T00:00:00+13:00",
        "recordedDate" : "2023-11-26T10:02:45+13:00",
        "recorder" : {
          "reference" : "https://api.hip.digital.health.nz/fhir/Practitioner/99ZZZZ",
          "type" : "Practitioner",
          "display" : "Dottie McStuffins"
        },
        "asserter" : {
          "reference" : "https://api.hip.digital.health.nz/fhir/Practitioner/91ZZXN",
          "type" : "Practitioner",
          "display" : "DR Julian Subatoi Bashir"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Condition"
      }
    },
    {
      "fullUrl" : "urn:uuid:1d8e3b41-5a29-4c43-8d0d-6e1d0b0f5a02",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "Inline-Condition-2",
        "meta" : {
          "profile" : [
            "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRCondition"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_Inline-Condition-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition Inline-Condition-2</b></p><a name=\"Inline-Condition-2\"> </a><a name=\"hcInline-Condition-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SDHRCondition.html\">SDHRCondition</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical inactive}\">Inactive</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 38341003}\">Hypertension</span></p><p><b>subject</b>: <a href=\"https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&amp;canonical=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZMW6003\">Sage Westbrook</a></p><p><b>recordedDate</b>: 2025-08-20 10:02:45+1200</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "inactive"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "38341003",
              "display" : "HT - Hypertension"
            }
          ],
          "text" : "Hypertension"
        },
        "subject" : {
          "reference" : "https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZMW6003",
          "type" : "Patient",
          "display" : "Sage Westbrook"
        },
        "recordedDate" : "2025-08-20T10:02:45+12:00"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Condition/Inline-Condition-2"
      }
    }
  ]
}

```
