# AllergyIntoleranceExample2 - NZ Shared Digital Health Record API v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **AllergyIntoleranceExample2**

## Example AllergyIntolerance: AllergyIntoleranceExample2

Last updated: 2024-01-26 10:03:26+1300; 

Information Source: [https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B)

Profile: [SDHRAllergyIntolerance](StructureDefinition-SDHRAllergyIntolerance.md)

**identifier**: `https://fhir.examplepms.co.nz`/ec2d6cad-1e19-46ee-accf-dc460a680710 (use: secondary, )

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**type**: Allergy

**category**: 370540009

**code**: Cashew nuts

**patient**: [Sage Westbrook](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284)

**recorder**: [DR Julian Subatoi Bashir](https://simplifier.net/resolve?scope=fhir.org.nz.ig.base@3.0.0&canonical=https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/91ZZXN)



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "AllergyIntoleranceExample2",
  "meta" : {
    "lastUpdated" : "2024-01-26T10:03:26+13:00",
    "source" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Location/F38006-B",
    "profile" : [
      "https://fhir-ig.digital.health.nz/sdhr/StructureDefinition/SDHRAllergyIntolerance"
    ]
  },
  "identifier" : [
    {
      "use" : "secondary",
      "system" : "https://fhir.examplepms.co.nz",
      "value" : "ec2d6cad-1e19-46ee-accf-dc460a680710"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ]
  },
  "type" : "allergy",
  "category" : ["370540009"],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "227493005",
        "display" : "Cashew nuts",
        "userSelected" : true
      }
    ]
  },
  "patient" : {
    "reference" : "https://api.hip.digital.health.nz/fhir/nhi/v1/Patient/ZKC7284",
    "type" : "Patient",
    "display" : "Sage Westbrook"
  },
  "recorder" : {
    "reference" : "https://api.hip.digital.health.nz/fhir/hpi/v1/Practitioner/91ZZXN",
    "type" : "Practitioner",
    "display" : "DR Julian Subatoi Bashir"
  }
}

```
