# au.digitalhealth.r4.healthconnect#0.2.0-preview: Health Connect Australia Provider Directory FHIR Implementation Guide

## Pages

* [Home](index.md)
* [Profiles and Extensions](profiles-and-extensions.md)
* [Health Connect Provider Directory Responder Actor](ActorDefinition-responder-actor-health-connect.md)
* [Search Parameters](search-parameters.md)
* [Health Connect Provider Directory Responder Actor - Testing](ActorDefinition-responder-actor-health-connect-testing.md)
* [Health Connect Provider Directory Requester Actor - XML Representation](ActorDefinition-requester-actor-health-connect.xml.md)
* [Guidance](guidance.md)
* [Health Connect Provider Directory Responder Actor - TTL Representation](ActorDefinition-responder-actor-health-connect.ttl.md)
* [Examples](examples.md)
* [Change Log](changelog.md)
* [Downloads](downloads.md)
* [Capability Statements](capability-statements.md)
* [Health Connect Provider Directory Responder Actor - JSON Representation](ActorDefinition-responder-actor-health-connect.json.md)
* [Health Connect Provider Directory Requester Actor - JSON Representation](ActorDefinition-requester-actor-health-connect.json.md)
* [Actor Definitions](actors.md)
* [Disclaimers](disclaimers.md)
* [Health Connect Provider Directory Responder Actor - XML Representation](ActorDefinition-responder-actor-health-connect.xml.md)
* [Health Connect Provider Directory Requester Actor](ActorDefinition-requester-actor-health-connect.md)
* [](ActorDefinition-responder-actor-health-connect.change.history.md)
* [Conformance](conformance.md)
* [](ActorDefinition-requester-actor-health-connect.change.history.md)
* [Health Connect Provider Directory Requester Actor - Testing](ActorDefinition-requester-actor-health-connect-testing.md)
* [Health Connect Provider Directory Requester Actor - TTL Representation](ActorDefinition-requester-actor-health-connect.ttl.md)
* [FHIR Artefacts](artifacts.md)
* [Terminology](terminology.md)

## Resources

### CodeSystems

* [HC Australian Endpoint Payload Types](CodeSystem-hc-endpoint-payload-type-cs.md)
* [HC Organization Classification CodeSystem](CodeSystem-hc-org-classification-cs.md)
* [HC Australian Service Interfaces](CodeSystem-hc-service-interfaces-cs.md)
* [HC Service Provision Code](CodeSystem-hc-service-provision-code-cs.md)
* [IAR Levels of Care CodeSystem](CodeSystem-iar-levels-of-care.md)

### ValueSets

* [HC Gender Identity ValueSet](ValueSet-HCGenderIdentityVs.md)
* [HC Australian Endpoint Payload Types](ValueSet-hc-endpoint-payload-type-vs.md)
* [HC Organization Classification ValueSet](ValueSet-hc-org-classification-vs.md)
* [HC Australian Service Interfaces](ValueSet-hc-service-interfaces-vs.md)
* [HC Service Provision Code](ValueSet-hc-service-provision-code-vs.md)
* [IAR Levels of Care ValueSet](ValueSet-iar-levels-of-care-vs.md)

### Complex-type Profiles

* [HC Endpoint Identifier (HC-EPI)](StructureDefinition-hc-endpoint-identifier.md)
* [HC Healthcare Provider Identifier - Organisation (HC HPI-O)](StructureDefinition-hc-hpio.md)
* [HC Healthcare Support Service Provider - Organisation (HC HSP-O)](StructureDefinition-hc-hspo.md)
* [HC Peak Body Professional Registration Number (HC-PBPRN)](StructureDefinition-hc-pbprn.md)
* [HC SMD Target Identifier (HC-SMDTI)](StructureDefinition-hc-smd-target-identifier.md)
* [HC PCA Healthcare Service Identifier (PCA-HSI)](StructureDefinition-pca-hsi.md)

### Resource Profiles

* [HC Endpoint](StructureDefinition-hc-endpoint.md)
* [HC HealthcareService](StructureDefinition-hc-healthcareservice.md)
* [HC Location](StructureDefinition-hc-location.md)
* [HC Organization](StructureDefinition-hc-organization.md)
* [HC Practitioner](StructureDefinition-hc-practitioner.md)
* [HC PractitionerRole](StructureDefinition-hc-practitionerrole.md)
* [HC Provenance](StructureDefinition-hc-provenance.md)
* [HC Service Coverage Area](StructureDefinition-hc-service-coverage-area.md)

### Extensions

* [HC Accept New Patient](StructureDefinition-hc-accept-new-patient.md)
* [HC Active Period](StructureDefinition-hc-active-period.md)
* [HC Amenity](StructureDefinition-hc-amenity.md)
* [HC Organization Classification](StructureDefinition-hc-org-classification.md)
* [HC Practitioner Role Communication](StructureDefinition-hc-practitioner-role-communication.md)
* [HC Preferred Name](StructureDefinition-hc-preferred-name.md)
* [HC Preferred Postal Address](StructureDefinition-hc-preferred-postal-address.md)
* [HC Referral Information for Referrer](StructureDefinition-hc-referral-information-for-referrer.md)
* [IAR Levels of Care](StructureDefinition-iar-levels-of-care.md)

### Basics

* [requester-actor-health-connect](Basic-requester-actor-health-connect.md)
* [responder-actor-health-connect](Basic-responder-actor-health-connect.md)

### CapabilityStatements

* [Health Connect Provider Directory Requester](CapabilityStatement-health-connect-provider-directory-requester.md)
* [Health Connect Provider Directory Responder](CapabilityStatement-health-connect-provider-directory-responder.md)

### ImplementationGuides

* [Health Connect Australia Provider Directory FHIR Implementation Guide](index.md)

### SearchParameters

* [SearchParameterAllDay](SearchParameter-allday.md)
* [SearchParameterDaysOfWeek](SearchParameter-daysofweek.md)
* [SearchParameterEndpointIdentifierHC](SearchParameter-endpoint-hcepi.md)
* [SearchParameterEndpointPayloadMimeType](SearchParameter-endpoint-payloadmimetype.md)
* [SearchParameterEndpointUrl](SearchParameter-endpoint-url.md)
* [SearchParameterEndTime](SearchParameter-endtime.md)
* [SearchParameterHealthcareServiceBilling](SearchParameter-healthcareservice-billing.md)
* [SearchParameterLanguages](SearchParameter-languages.md)
* [SearchParameterLocationAmenities](SearchParameter-location-amenities.md)
* [SearchParameterLocationPostalAddress](SearchParameter-location-locmailaddress.md)
* [SearchParameterLocationPhysicalType](SearchParameter-location-physicaltype.md)
* [SearchParameterPractitionerIdentifierR5](SearchParameter-practitioner-identifier-r5.md)
* [SearchParameterPractitionerRegProf](SearchParameter-practitioner-regprof.md)
* [SearchParameterPractitionerRSG](SearchParameter-practitioner-rsg.md)
* [SearchParameterPractitionerRoleType](SearchParameter-practitionerrole-roletype.md)
* [SearchParameterStartTime](SearchParameter-starttime.md)

### Examples

* [Sydney General Hospital SMD Endpoint (Endpoint)](Endpoint-example-hc-endpoint-smd.md)
* [Healthcare service with Residential Aged Care service type (HealthcareService)](HealthcareService-example-healthconnect-healthcareservice-1.md)
* [Sydney Central Medical Centre (Location)](Location-example-healthconnect-medical-centre-location-1.md)
* [Mobile Healthcare Unit - Sydney CBD (Location)](Location-example-healthconnect-mobile-healthcare-unit-1.md)
* [Sydney CBD Mobile Unit Service Area (Location)](Location-example-healthconnect-mobile-unit-coverage-area-1.md)
* [Virtual Telehealth Service (Location)](Location-example-healthconnect-virtual-telehealth-service-1.md)
* [Example Aged Care Facility (Organization)](Organization-example-healthconnect-organization-1.md)
* [Caring Hands Home Support (Organization)](Organization-example-healthconnect-organization-2.md)
* [example-healthconnect-practitioner-1 (Practitioner)](Practitioner-example-healthconnect-practitioner-1.md)
* [external-hc-practitioner-record (Practitioner)](Practitioner-external-hc-practitioner-record.md)
* [example-healthconnect-practitionerrole-1 (PractitionerRole)](PractitionerRole-example-healthconnect-practitionerrole-1.md)
* [provenance-practitioner-name-update (Provenance)](Provenance-provenance-practitioner-name-update.md)
* [provenance-practitioner-phone-update (Provenance)](Provenance-provenance-practitioner-phone-update.md)
