# Home - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect | *Version*:0.2.0-preview |
| *IG Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HealthConnectAustraliaProviderDirectoryFHIRImplementationGuide |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

# Health Connect FHIR ImplementationGuide

> This material is under active development and content may be added or updated on a regular basis.

ADHA review feedback

We welcome your feedback on this implementation guide.

To contribute directly to this implementation guide with code changes or documentation updates, please fork the repository and submit a pull request.

For technical FHIR-related comments, implementation feedback, or suggestions for profile improvements, you can create a GitHub issue.

For feedback concerning design considerations, business requirements, or broader implementation strategy, please [contact the Clinical Informatics team](mailto:informatics@digitalhealth.gov.au).

**Note:** The next release of this FHIR Implementation Guide (beyond Snapshot 2) will include updates to the URL scheme to ensure clarity about the scope of this IG in relation to future Health Connect FHIR Implementation Guides.

### Scope

This Implementation Guide (IG) defines how a Health Connect Provider Directory Requester Actor (client) interacts with a Health Connect Provider Directory Responder Actor (server), specifying the expected behaviors for each. The Requester Actor is a read-only FHIR client: it may perform search and read operations, but does not create, update, or delete resources in Health Connect. The capability statements in this IG set out the minimum operations and behaviors that conformant implementations must support. For the Responder Actor, requirements are expressed as SHALL statements, indicating mandatory support. For the Requester Actor, requirements are a mix of SHALL (mandatory) and SHOULD (recommended) statements, as detailed in the relevant [capability statements](capability-statements.md) and [conformance statement](conformance.md) sections of this guide. For further detail please appraise both the [capability statements](capability-statements.md) and [conformance statement](conformance.md).

### Introduction

Health Connect Australia is a national health information exchange program designed to enable the sharing of health information between healthcare participants quickly and securely. By integrating advanced digital infrastructure, standards, privacy protections and enabling real-time data sharing, Health Connect Australia will support multidisciplinary collaboration across care settings. As a key enabler of the [National Digital Health Strategy 2023–2028](https://www.digitalhealth.gov.au/national-digital-health-strategy) and the [National Healthcare Interoperability Plan 2023-2028](https://www.digitalhealth.gov.au/about-us/strategies-and-plans/national-healthcare-interoperability-plan), it ensures secure, connected digital solutions that improve access, efficiency and care quality-paving the way for a smarter, more integrated future in digital health. The program is being delivered in phases, beginning with foundational capabilities and expanding to support secure communication, record discovery, and value-added services for both providers and consumers.

The Directory and Authorisation Service Project is the first initiative under the Foundations phase. It enables healthcare providers to discover accurate, up-to-date information about other providers and the services they offer, while establishing a trust framework to support consistent and secure access to health information. By connecting provider data from multiple primary sources through a single access point and ensuring near real-time updates, the project lays the groundwork for broader interoperability and trusted information exchange across the national health ecosystem.

One of the key objectives of the Directory and Authorisation Service Project is to enable interoperability through contemporary standards-such as FHIR APIs-to ensure seamless integration across clinical and administrative systems. To support this, the project is establishing a centralised directory hosted on a FHIR repository, where provider and organisation data will be structured using HL7® FHIR® and terminology standards. To guide consistent implementation and promote national alignment, the project is developing a FHIR Implementation Guide that defines how provider information should be represented and exchanged. This guide will build on existing standards, including the HL7 Australia FHIR AU Core, and provide a clear reference for integrators and system vendors to support secure, scalable, and standards-compliant access to directory data.

### How to read this guide

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* [Home](index.md): This page provides the introduction and scope for the implementation guide.
* [Guidance](guidance.md): This page provides implementation guidance and best practices for using the Health Connect Provider Directory FHIR IG.
* [FHIR Artefacts](artifacts.md): These pages provide detailed descriptions and formal definitions for all the FHIR artefacts defined in this guide. 
* [Artifacts Summary](artifacts.md): This page provides a comprehensive summary of all FHIR artifacts defined in this implementation guide including profiles, extensions, terminology, and other conformance resources.
* [Profiles and Extensions](profiles-and-extensions.md): This page lists the FHIR profiles and extensions that are defined in this guide.
* [Terminology](terminology.md): This page lists the FHIR terminology that are defined in this guide.
* [Capability Statements](capability-statements.md): This page defines the expected FHIR capabilities of Health Connect Provider Directory Requester and Health Connect Provider Directory Responder.
* [Search Parameters](artifacts.md#behavior-search-parameters): This page lists the FHIR search parameters that are defined in this guide.
* [Actor Definitions](actors.md): This page defines the Health Connect actors, Health Connect Provider Directory Requester and Health Connect Provider Directory Responder.
 
* [Conformance](conformance.md): This page describes the set of rules to claim conformance to this guide including capability statements and actor definitions.
* [Examples](examples.md): This page lists the sample instances of FHIR resources conforming to the FHIR profiles.
* [Disclaimers](disclaimers.md): This page lists the licensing, copyright, and disclaimers under which this guide is issued.
* [Downloads](downloads.md): This page provides links to downloadable artefacts including the Agency FHIR NPM package.
* [Change Log](changelog.md): This page documents the version history and changes made to this implementation guide across different releases.

### Document purpose and scope

The primary aim of this implementation guide is to support implementers integrating with the Directory services using [FHIR, Release 4 (v4.0.1) [HL7FHIR4]](#HL7FHIR4). It provides the technical specifications, FHIR profiles, and terminology definitions required for healthcare provider data exchange through Health Connect Provider Directory APIs.

This document describes specific system behaviours such as obligations, API HTTP response codes, and search parameters. Other system behavioural requirements such as the presentation of information and user experience are managed separately and must be met before systems can be assessed for conformance and granted access to Health Connect APIs.

Reference has been made to International and Australian Standards, and to Standards from HL7. The following standards are referred to in the text in such a way that some or all of its content constitutes requirements for the purposes of this specification:

* [FHIR, Release 4 (v4.0.1) [HL7FHIR4]](#HL7FHIR4)
* [Australian Base Profiles Implementation Guide [HL7AUBIG]](#HL7AUBIG)
* [Australian Core Profiles Implementation Guide [HL7AUCIG]](#HL7AUCIG)

Wherever possible, material in this specification is based on existing standards. All efforts have been made to minimise divergence from the HL7 Australia standards ([AU Core [HL7AUCIG]](#HL7AUCIG) and [AU Base [HL7AUBIG]](#HL7AUBIG)) to provide for system interoperability and compatibility with other profiles. Issues of an editorial nature in the source material (such as spelling or punctuation errors) are intentionally reproduced. For a list of known issues (see below).

### Intended audience

This implementation guide is aimed at software development teams, architects, and designers that integrate with the Health Connect Provider Directory system.

This implementation guide and related artefacts are technical in nature and the audience is expected to be familiar with the language of health data specifications and to have some familiarity with health information standards and specifications, such as FHIR.

### Relationships with other work

This implementation guide builds on other specifications, helping ensure a consistent approach to data sharing that should ease adoption. The specific guides used, and the portions relevant from each of them are as follows:

### Cross version analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (au.digitalhealth.r4.healthconnect.r4)](package.r4.tgz) and [R4B (au.digitalhealth.r4.healthconnect.r4b)](package.r4b.tgz) are available.

### Global profiles

*There are no Global profiles defined*

### Data model overview

The Health Connect Provider Directory uses FHIR resources to represent healthcare providers, their roles, organisational affiliations, service locations, and the healthcare services they provide. The diagram below illustrates the key relationships between these FHIR resources:

* Practitioner - Individual healthcare providers with their professional qualifications and identifiers
* Organization - Healthcare organisations and facilities that employ or affiliate with practitioners
* HealthcareService - Specific services offered by organisations at locations
* Location - Physical or virtual locations where healthcare services are delivered
* Endpoint - Technical endpoints for digital service integration and communication

This model supports complex healthcare delivery scenarios while maintaining FHIR R4 compliance and enabling efficient provider directory searches and integrations.

### Known issues

This table lists known issues with this specification at the time of publishing. We are working on solutions to these issues and encourage comments to help us develop these solutions.

* Reference: Example system URI
  * Description: An inherited example system (e.g.`http://www.acme.com/identifiers/patient`) erroneously infers patient context. Implementers must use their own namespace URIs. The affected identifier profile is Endpoint (HC-EPI) - this profile includes the erroneous example `system` in their documentation.

### References

| | |
| :--- | :--- |
| [HL7AUBIG] | HL7 Australia, FHIR R4 standard for AU Base Implementation Guide, v6.0.0 |
|   | [https://hl7.org.au/fhir/6.0.0/index.html](https://hl7.org.au/fhir/6.0.0/index.html) |

| | |
| :--- | :--- |
| [HL7FHIR4] | Health Level Seven, Inc., 30 October 2019, FHIR R4. |
|   | [http://hl7.org/fhir/R4/](http://hl7.org/fhir/R4/) |

| | |
| :--- | :--- |
| [HL7AUCIG] | HL7 Australia, FHIR R4 standard for AU Core Implementation Guide, v2.0.0-ballot - Ballot (Ballot) |
|   | [https://hl7.org.au/fhir/core/2.0.0-ballot/index.html](https://hl7.org.au/fhir/core/2.0.0-ballot/index.html) |

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.

