# Disclaimers - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* **Disclaimers**

## Disclaimers

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Disclaimer

The Australian Digital Health Agency (“the Agency”) makes the information and other material (“Information”) in this document available in good faith but without any representation or warranty as to its accuracy or completeness. The Agency cannot accept any responsibility for the consequences of any use of the Information. As the Information is of a general nature only, it is up to any person using or relying on the Information to ensure that it is accurate, complete and suitable for the circumstances of its use.

### Document control

This document is maintained in electronic form and is uncontrolled in printed form. It is the responsibility of the user to verify that this copy is the latest revision.

### Copyright © 2025 Australian Digital Health Agency

This document contains information which is protected by copyright. All Rights Reserved. No part of this work may be reproduced or used in any form or by any means – graphic, electronic, or mechanical, including photocopying, recording, taping, or information storage and retrieval systems – without the permission of the Australian Digital Health Agency. All copies of this document must include the copyright and other information contained on this page.

### Regenstrief Institute (LOINC)

This material contains content from LOINC ([http://loinc.org](http://loinc.org)). LOINC is copyright © Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at [http://loinc.org/license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

### IHTSDO (SNOMED CT)

This material includes SNOMED Clinical Terms® (SNOMED CT®) which is used by permission of the International Health Terminology Standards Development Organisation (IHTSDO). All rights reserved. SNOMED CT® was originally created by The College of American Pathologists. “SNOMED” and “SNOMED CT” are registered trademarks of the [IHTSDO](http://www.ihtsdo.org/).

### HL7 FHIR

This product includes all or a portion of material that is HL7 FHIR Copyright © 2011+ HL7 licensed under Creative Commons "No Rights Reserved".

### HL7 International

This document includes excerpts of HL7™ International standards and other HL7 International material. HL7 International is the publisher and holder of copyright in the excerpts. The publication, reproduction and use of such excerpts is governed by the [HL7 IP Policy](http://www.hl7.org/legal/ippolicy.cfm) and the HL7 International License Agreement. HL7 and CDA are trademarks of Health Level Seven International and are registered with the United States Patent and Trademark Office. FHIR is a registered trademark of Health Level Seven International.

This product includes all or a portion of the HL7 Vocabulary, or is derived from the HL7 Vocabulary, subject to a license from Health Level Seven International. Your use of the HL7 Vocabulary also is subject to this license, a copy of which is accessible through the following link: [http://www.hl7.org/permalink/?VocabTables](http://www.hl7.org/permalink/?VocabTables). The current complete HL7 Vocabulary is also available through this link. The HL7 Vocabulary is copyright © 1989-2010, Health Level Seven International. All rights reserved. THE HL7 VOCABULARY IS PROVIDED "AS IS." ANY EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

### Creative Commons 4.0 licence

This work is licensed under a Creative Commons Attribution 4.0 International License.

Please refer to the full license agreement at: [https://creativecommons.org/licenses/by/4.0](https://creativecommons.org/licenses/by/4.0).

This license allows you to distribute, remix, adapt, and build upon this material in any medium or format, as long as attribution is given to the creator.

### Intellectual property considerations

This implementation guide and the underlying FHIR specification are licensed as public domain under the [FHIR license](http://hl7.org/fhir/R4/license.html). The license page also describes rules for the use of the FHIR name and logo.

This publication includes IP covered under the following statements.

* Copyright © 2018 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/).This resource includes material that is based on Australian Institute of Health and Welfare material.All copies of this resource must include this copyright statement and all information contained in this statement.

* [Australian States and Territories](https://tx.hl7.org.au/fhir/ValueSet/australian-states-territories-1): [HCServiceCoverageArea](StructureDefinition-hc-service-coverage-area.md)


* Copyright © 2025 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/).National Health Services Directory© 2018+; Licensed Under Creative Commons No Rights Reserved.All copies of this resource must include this copyright statement and all information contained in this statement.

* [Facility Amenity](https://api.healthterminologies.gov.au/integration/R4/fhir/CodeSystem/facility-amenity-1): [HCAmenity](StructureDefinition-hc-amenity.md), [Mobile Healthcare Unit - Sydney CBD](Location-example-healthconnect-mobile-healthcare-unit-1.md) and [Sydney Central Medical Centre](Location-example-healthconnect-medical-centre-location-1.md)


* Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)](https://creativecommons.org/licenses/by/4.0/) 

* [HC Australian Endpoint Payload Types](CodeSystem-hc-endpoint-payload-type-cs.md): [AustralianEndpointPayloadTypesValueSet](ValueSet-hc-endpoint-payload-type-vs.md), [HCEndpoint](StructureDefinition-hc-endpoint.md) and [Sydney General Hospital SMD Endpoint](Endpoint-example-hc-endpoint-smd.md)
* [HC Organization Classification CodeSystem](CodeSystem-hc-org-classification-cs.md): [Caring Hands Home Support](Organization-example-healthconnect-organization-2.md), [Example Aged Care Facility](Organization-example-healthconnect-organization-1.md), [HCHSPOIdentifier](StructureDefinition-hc-hspo.md), [HcOrgClassVS](ValueSet-hc-org-classification-vs.md) and [HcOrgClassification](StructureDefinition-hc-org-classification.md)
* [HC Australian Service Interfaces](CodeSystem-hc-service-interfaces-cs.md): [HCEndpoint](StructureDefinition-hc-endpoint.md) and [HCServiceInterfacesValueSet](ValueSet-hc-service-interfaces-vs.md)
* [IAR Levels of Care CodeSystem](CodeSystem-iar-levels-of-care.md): [Healthcare service with Residential Aged Care service type](HealthcareService-example-healthconnect-healthcareservice-1.md), [IARLevelsOfCareExtension](StructureDefinition-iar-levels-of-care.md) and [IARLevelsOfCareVs](ValueSet-iar-levels-of-care-vs.md)


* Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/).

* [HC Service Provision Code](CodeSystem-hc-service-provision-code-cs.md): [HCHealthcareService](StructureDefinition-hc-healthcareservice.md) and [HCServiceProvisionCodeValueSet](ValueSet-hc-service-provision-code-vs.md)


* HL7 Australia© 2018+; Licensed Under Creative Commons No Rights Reserved.

* [Location Type AU](http://hl7.org.au/fhir/6.0.0/CodeSystem-au-location-type.html): [HCLocation](StructureDefinition-hc-location.md), [Sydney CBD Mobile Unit Service Area](Location-example-healthconnect-mobile-unit-coverage-area-1.md) and [Virtual Telehealth Service](Location-example-healthconnect-virtual-telehealth-service-1.md)
* [Service Provision Conditions Australian Concepts](http://hl7.org.au/fhir/6.0.0/CodeSystem-service-provision-conditions.html): [HCHealthcareService](StructureDefinition-hc-healthcareservice.md), [HCServiceProvisionCodeValueSet](ValueSet-hc-service-provision-code-vs.md) and [Healthcare service with Residential Aged Care service type](HealthcareService-example-healthconnect-healthcareservice-1.md)
* [IdentifierType AU](http://hl7.org.au/fhir/6.0.0/CodeSystem-au-v2-0203.html): [Caring Hands Home Support](Organization-example-healthconnect-organization-2.md), [Example Aged Care Facility](Organization-example-healthconnect-organization-1.md)...Show 8 more,[HCHPIOIdentifier](StructureDefinition-hc-hpio.md),[HCHSPOIdentifier](StructureDefinition-hc-hspo.md),[Mobile Healthcare Unit - Sydney CBD](Location-example-healthconnect-mobile-healthcare-unit-1.md),[Practitioner/example-healthconnect-practitioner-1](Practitioner-example-healthconnect-practitioner-1.md),[PractitionerRole/example-healthconnect-practitionerrole-1](PractitionerRole-example-healthconnect-practitionerrole-1.md),[Sydney CBD Mobile Unit Service Area](Location-example-healthconnect-mobile-unit-coverage-area-1.md),[Sydney Central Medical Centre](Location-example-healthconnect-medical-centre-location-1.md)and[Virtual Telehealth Service](Location-example-healthconnect-virtual-telehealth-service-1.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AustralianEndpointPayloadTypesCodeSystem](CodeSystem-hc-endpoint-payload-type-cs.md), [AustralianEndpointPayloadTypesValueSet](ValueSet-hc-endpoint-payload-type-vs.md)...Show 53 more,[HCAcceptNewPatient](StructureDefinition-hc-accept-new-patient.md),[HCAmenity](StructureDefinition-hc-amenity.md),[HCEndpoint](StructureDefinition-hc-endpoint.md),[HCEndpointIdentifier](StructureDefinition-hc-endpoint-identifier.md),[HCGenderIdentityVs](ValueSet-HCGenderIdentityVs.md),[HCHPIOIdentifier](StructureDefinition-hc-hpio.md),[HCHSPOIdentifier](StructureDefinition-hc-hspo.md),[HCHealthcareService](StructureDefinition-hc-healthcareservice.md),[HCLocation](StructureDefinition-hc-location.md),[HCOrganization](StructureDefinition-hc-organization.md),[HCPeakBodyRegistrationNumber](StructureDefinition-hc-pbprn.md),[HCPractitioner](StructureDefinition-hc-practitioner.md),[HCPractitionerRole](StructureDefinition-hc-practitionerrole.md),[HCPreferredPostalAddress](StructureDefinition-hc-preferred-postal-address.md),[HCProvenance](StructureDefinition-hc-provenance.md),[HCSMDTargetIdentifier](StructureDefinition-hc-smd-target-identifier.md),[HCServiceCoverageArea](StructureDefinition-hc-service-coverage-area.md),[HCServiceInterfaceCodeSystem](CodeSystem-hc-service-interfaces-cs.md),[HCServiceInterfacesValueSet](ValueSet-hc-service-interfaces-vs.md),[HCServiceProvisionCodeCodeSystem](CodeSystem-hc-service-provision-code-cs.md),[HCServiceProvisionCodeValueSet](ValueSet-hc-service-provision-code-vs.md),[HcActivePeriod](StructureDefinition-hc-active-period.md),[HcIarLevelsOfCareCs](CodeSystem-iar-levels-of-care.md),[HcOrgClassCS](CodeSystem-hc-org-classification-cs.md),[HcOrgClassVS](ValueSet-hc-org-classification-vs.md),[HcOrgClassification](StructureDefinition-hc-org-classification.md),[HcPractitionerRoleCommunication](StructureDefinition-hc-practitioner-role-communication.md),[HcPreferredName](StructureDefinition-hc-preferred-name.md),[HcReferralInformationForReferrer](StructureDefinition-hc-referral-information-for-referrer.md),[HealthConnectAustraliaProviderDirectoryFHIRImplementationGuide](index.md),[HealthConnectProviderDirectoryRequester](CapabilityStatement-health-connect-provider-directory-requester.md),[HealthConnectProviderDirectoryResponder](CapabilityStatement-health-connect-provider-directory-responder.md),[IARLevelsOfCareExtension](StructureDefinition-iar-levels-of-care.md),[IARLevelsOfCareVs](ValueSet-iar-levels-of-care-vs.md),[PCAHealthcareServiceIdentifier](StructureDefinition-pca-hsi.md),[RequesterActorHealthConnect](ActorDefinition-requester-actor-health-connect.md),[ResponderActorHealthConnect](ActorDefinition-responder-actor-health-connect.md),[SearchParameterAllDay](SearchParameter-allday.md),[SearchParameterDaysOfWeek](SearchParameter-daysofweek.md),[SearchParameterEndTime](SearchParameter-endtime.md),[SearchParameterEndpointIdentifierHC](SearchParameter-endpoint-hcepi.md),[SearchParameterEndpointPayloadMimeType](SearchParameter-endpoint-payloadmimetype.md),[SearchParameterEndpointUrl](SearchParameter-endpoint-url.md),[SearchParameterHealthcareServiceBilling](SearchParameter-healthcareservice-billing.md),[SearchParameterLanguages](SearchParameter-languages.md),[SearchParameterLocationAmenities](SearchParameter-location-amenities.md),[SearchParameterLocationPhysicalType](SearchParameter-location-physicaltype.md),[SearchParameterLocationPostalAddress](SearchParameter-location-locmailaddress.md),[SearchParameterPractitionerIdentifierR5](SearchParameter-practitioner-identifier-r5.md),[SearchParameterPractitionerRSG](SearchParameter-practitioner-rsg.md),[SearchParameterPractitionerRegProf](SearchParameter-practitioner-regprof.md),[SearchParameterPractitionerRoleType](SearchParameter-practitionerrole-roletype.md)and[SearchParameterStartTime](SearchParameter-starttime.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r4/ValueSet/snomedct): [HCHealthcareService](StructureDefinition-hc-healthcareservice.md), [Healthcare service with Residential Aged Care service type](HealthcareService-example-healthconnect-healthcareservice-1.md), [Practitioner/example-healthconnect-practitioner-1](Practitioner-example-healthconnect-practitioner-1.md), [Practitioner/external-hc-practitioner-record](Practitioner-external-hc-practitioner-record.md) and [PractitionerRole/example-healthconnect-practitionerrole-1](PractitionerRole-example-healthconnect-practitionerrole-1.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Location type](http://terminology.hl7.org/7.0.1/CodeSystem-location-physical-type.html): [Sydney Central Medical Centre](Location-example-healthconnect-medical-centre-location-1.md)
* [UsageContextType](http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html): [AustralianEndpointPayloadTypesCodeSystem](CodeSystem-hc-endpoint-payload-type-cs.md), [AustralianEndpointPayloadTypesValueSet](ValueSet-hc-endpoint-payload-type-vs.md)...Show 53 more,[HCAcceptNewPatient](StructureDefinition-hc-accept-new-patient.md),[HCAmenity](StructureDefinition-hc-amenity.md),[HCEndpoint](StructureDefinition-hc-endpoint.md),[HCEndpointIdentifier](StructureDefinition-hc-endpoint-identifier.md),[HCGenderIdentityVs](ValueSet-HCGenderIdentityVs.md),[HCHPIOIdentifier](StructureDefinition-hc-hpio.md),[HCHSPOIdentifier](StructureDefinition-hc-hspo.md),[HCHealthcareService](StructureDefinition-hc-healthcareservice.md),[HCLocation](StructureDefinition-hc-location.md),[HCOrganization](StructureDefinition-hc-organization.md),[HCPeakBodyRegistrationNumber](StructureDefinition-hc-pbprn.md),[HCPractitioner](StructureDefinition-hc-practitioner.md),[HCPractitionerRole](StructureDefinition-hc-practitionerrole.md),[HCPreferredPostalAddress](StructureDefinition-hc-preferred-postal-address.md),[HCProvenance](StructureDefinition-hc-provenance.md),[HCSMDTargetIdentifier](StructureDefinition-hc-smd-target-identifier.md),[HCServiceCoverageArea](StructureDefinition-hc-service-coverage-area.md),[HCServiceInterfaceCodeSystem](CodeSystem-hc-service-interfaces-cs.md),[HCServiceInterfacesValueSet](ValueSet-hc-service-interfaces-vs.md),[HCServiceProvisionCodeCodeSystem](CodeSystem-hc-service-provision-code-cs.md),[HCServiceProvisionCodeValueSet](ValueSet-hc-service-provision-code-vs.md),[HcActivePeriod](StructureDefinition-hc-active-period.md),[HcIarLevelsOfCareCs](CodeSystem-iar-levels-of-care.md),[HcOrgClassCS](CodeSystem-hc-org-classification-cs.md),[HcOrgClassVS](ValueSet-hc-org-classification-vs.md),[HcOrgClassification](StructureDefinition-hc-org-classification.md),[HcPractitionerRoleCommunication](StructureDefinition-hc-practitioner-role-communication.md),[HcPreferredName](StructureDefinition-hc-preferred-name.md),[HcReferralInformationForReferrer](StructureDefinition-hc-referral-information-for-referrer.md),[HealthConnectAustraliaProviderDirectoryFHIRImplementationGuide](index.md),[HealthConnectProviderDirectoryRequester](CapabilityStatement-health-connect-provider-directory-requester.md),[HealthConnectProviderDirectoryResponder](CapabilityStatement-health-connect-provider-directory-responder.md),[IARLevelsOfCareExtension](StructureDefinition-iar-levels-of-care.md),[IARLevelsOfCareVs](ValueSet-iar-levels-of-care-vs.md),[PCAHealthcareServiceIdentifier](StructureDefinition-pca-hsi.md),[RequesterActorHealthConnect](ActorDefinition-requester-actor-health-connect.md),[ResponderActorHealthConnect](ActorDefinition-responder-actor-health-connect.md),[SearchParameterAllDay](SearchParameter-allday.md),[SearchParameterDaysOfWeek](SearchParameter-daysofweek.md),[SearchParameterEndTime](SearchParameter-endtime.md),[SearchParameterEndpointIdentifierHC](SearchParameter-endpoint-hcepi.md),[SearchParameterEndpointPayloadMimeType](SearchParameter-endpoint-payloadmimetype.md),[SearchParameterEndpointUrl](SearchParameter-endpoint-url.md),[SearchParameterHealthcareServiceBilling](SearchParameter-healthcareservice-billing.md),[SearchParameterLanguages](SearchParameter-languages.md),[SearchParameterLocationAmenities](SearchParameter-location-amenities.md),[SearchParameterLocationPhysicalType](SearchParameter-location-physicaltype.md),[SearchParameterLocationPostalAddress](SearchParameter-location-locmailaddress.md),[SearchParameterPractitionerIdentifierR5](SearchParameter-practitioner-identifier-r5.md),[SearchParameterPractitionerRSG](SearchParameter-practitioner-rsg.md),[SearchParameterPractitionerRegProf](SearchParameter-practitioner-regprof.md),[SearchParameterPractitionerRoleType](SearchParameter-practitionerrole-roletype.md)and[SearchParameterStartTime](SearchParameter-starttime.md)
* [identifierType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0203.html): [HCEndpointIdentifier](StructureDefinition-hc-endpoint-identifier.md), [HCPeakBodyRegistrationNumber](StructureDefinition-hc-pbprn.md), [Practitioner/example-healthconnect-practitioner-1](Practitioner-example-healthconnect-practitioner-1.md), [Practitioner/external-hc-practitioner-record](Practitioner-external-hc-practitioner-record.md) and [Sydney General Hospital SMD Endpoint](Endpoint-example-hc-endpoint-smd.md)
* [ActCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html): [HCProvenance](StructureDefinition-hc-provenance.md)
* [DataOperation](http://terminology.hl7.org/7.0.1/CodeSystem-v3-DataOperation.html): [HCProvenance](StructureDefinition-hc-provenance.md), [Provenance/provenance-practitioner-name-update](Provenance-provenance-practitioner-name-update.md) and [Provenance/provenance-practitioner-phone-update](Provenance-provenance-practitioner-phone-update.md)
* [DocumentCompletion](http://terminology.hl7.org/7.0.1/CodeSystem-v3-DocumentCompletion.html): [HCProvenance](StructureDefinition-hc-provenance.md)
* [NullFlavor](http://terminology.hl7.org/7.0.1/CodeSystem-v3-NullFlavor.html): [HCGenderIdentityVs](ValueSet-HCGenderIdentityVs.md) and [HCPractitioner](StructureDefinition-hc-practitioner.md)
* [ParticipationType](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ParticipationType.html): [HCProvenance](StructureDefinition-hc-provenance.md)
* [RoleCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-RoleCode.html): [HCLocation](StructureDefinition-hc-location.md) and [Mobile Healthcare Unit - Sydney CBD](Location-example-healthconnect-mobile-healthcare-unit-1.md)


OFFICIAL

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.

