# HC PractitionerRole - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](artifacts.md)
* **HC PractitionerRole**

## Resource Profile: HC PractitionerRole 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole | *Version*:0.2.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HCPractitionerRole |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

 
This profile defines a practitioner in role for an organisation at a location providing a healthcare service. 

### Extensions

Extensions introduced in this profile:

* PractitionerRole: [HC PractitionerRole Communication](StructureDefinition-hc-practitioner-role-communication.md)
* PractitionerRole: [HC Preferred Name](StructureDefinition-hc-preferred-name.md)

### Usage notes

#### Identifiers

**Registration Identifiers (exactly one required for the role):**

* Ahpra Registration Number - The specific Ahpra registration credential relevant to this practitioner role
* Professional Registration Number (PRN) - The specific professional registration credential relevant to this practitioner role

These registration identifiers must match corresponding registration identifiers held by the referenced Practitioner and should represent the professional credentials that authorize the practitioner to perform this specific role.

HC Practitioner Role resources may also have additional identifiers specific to other business partners, with identifier systems that may or may not match other identifier slices defined in [AU Core Practitioner Role](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitionerrole.html).

#### Preferred name in role context

The [HC Preferred Name](StructureDefinition-hc-preferred-name.md) extension allows a practitioner to specify a preferred name for use in the context of a specific role. This name may differ from their registered name and allows practitioners to be known by their preferred name when delivering healthcare services in this role.

#### PractitionerRole code

Only the main role or job of the clinician should be provided, using a code from the SNOMED-CT-AU code system. The preferred value set is [Practitioner Role 1](https://tx.ontoserver.csiro.au/fhir/ValueSet/practitioner-role-1). Publishing systems must supply a single code representing the clinician’s primary practitioner role. Any additional codes or roles will be ignored. When a PractitionerRole is provided to a subscribing system, only the primary role (as defined by the SNOMED-CT-AU code from the specified value set) will be included.

The SNOMED code is the authoritative, machine-readable representation and should be used for searching, filtering, and interoperability; the display is the user-facing label and may be normalised by subscribing systems. Additional codes MUST NOT be used to represent multiple roles and will be ignored by the HC service.

#### Guidance on PractitionerRole.specialty

The `PractitionerRole.specialty` element is marked as **Must Support (MS)** because this requirement is inherited from AU Core, which also imposes obligations on defined roles. None of the AU Core roles or obligations are relevant to this specification. There is no requirement for implementers of this specification to do anything this this data element.

* It **SHOULD** be ignored by Health Connect Provider Directory Requester Actors.
* It **SHALL NOT** be populated by Health Connect Provider Directory Actors.

### Data Integrity and Validation

This profile includes invariants to ensure data consistency and integrity between PractitionerRole and the referenced Practitioner resources.

#### Registration Identifier Matching

The `inv-02-identifier-registration-match` invariant ensures that registration identifiers on the PractitionerRole match those of the referenced Practitioner. This validation prevents data inconsistencies where a PractitionerRole might reference registration numbers that don't belong to the associated Practitioner.

**Requirements:**

* If the PractitionerRole has an Ahpra registration identifier, it must match one of the referenced Practitioner's Ahpra registration identifiers.
* If the PractitionerRole has a peak body registration identifier (PRN), it must match one of the referenced Practitioner's peak body registration identifiers.

**Business Logic:** This ensures referential integrity in provider directory implementations where:

* A PractitionerRole represents a specific professional role.
* The registration credentials for that role must be held by the actual Practitioner.
* Prevents scenarios where role assignments reference incorrect or mismatched professional registrations.

#### Registration Identifier Requirements

The invariant `inv-01-identifier-registration-required` ensures that at least one of the Professional Registration Number identifier types are present, either:

* an Ahpra registration number (AHPRA) OR
* a non-Ahpra Peak Body Registration Number (PRN).

While a practitioner can have more than one professional registration and professions (e.g. nurse and midwife), the relevant registration that is applicable for this role only is captured.

**Usages:**

* Refer to this Profile: [HC Provenance](StructureDefinition-hc-provenance.md)
* Examples for this Profile: [PractitionerRole/example-healthconnect-practitionerrole-1](PractitionerRole-example-healthconnect-practitionerrole-1.md)
* CapabilityStatements using this Profile: [Health Connect Provider Directory Requester](CapabilityStatement-health-connect-provider-directory-requester.md) and [Health Connect Provider Directory Responder](CapabilityStatement-health-connect-provider-directory-responder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/au.digitalhealth.r4.healthconnect|current/StructureDefinition/hc-practitionerrole)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-hc-practitionerrole.csv), [Excel](StructureDefinition-hc-practitionerrole.xlsx), [Schematron](StructureDefinition-hc-practitionerrole.sch) 

### Notes:

### Search parameters

This IG defines and introduces several search parameters in addition to those inherited that make it easier to find and filter `HC PractitionerRole` resources in Health Connect implementations.

#### Search parameters defined in FHIR R4

The following **standard FHIR R4** search parameters are **recommended** for PractitionerRole searching:

* [`identifier`](https://hl7.org/fhir/R4/practitionerrole.html#search) (PractitionerRole.identifier)
* This search parameter supports searching by any identifier including:
* **Medicare Provider Number** (system defined in AU Base)
* **Ahpra Registration Number** (system defined in AU Base)
* **Professional Registration Number (PRN)** (peak body identifiers)
* How search queries can be performed using Medicare Provider Number or Ahpra identifier are described in [AU Core](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitionerrole.html#notes).
* This search parameter supports the following query use cases where:
* A peakbodyregistrationnumber OR Ahpra number value is supplied with or without an accompanying system. **note** that when a system is not supplied this may result in duplicate value matches, originating from multiple different issuing organizations.
* Examples:
* Medicare Provider Number: `GET /PractitionerRole?identifier=http://ns.electronichealth.net.au/id/medicare-provider-number|2426621B`
* Ahpra Registration Number: `GET /PractitionerRole?identifier=http://hl7.org.au/id/ahpra-registration-number|MED0000932945`
* PRN (with system): `GET /PractitionerRole?identifier=http://example.org/fhir/identifier/examplesystem|PRN-123456`
* PRN (without system): `GET /PractitionerRole?identifier=PRN-123456`

#### Search parameters defined in this IG

The following search parameters are **defined by this IG** and **SHOULD** be supported:

* [`languages`](SearchParameter-languages.md) (PractitionerRole.extension where url = HC practitioner role communication). Supports both `:contains` & `:exact` modifiers.
* Find practitioner roles by the languages spoken by the practitioner in this role, stored in the HC communication extension. This is a shared SearchParameter that works across both HealthcareService and PractitionerRole resources.
* Supports `:contains` modifier for partial matching, `:exact` modifier for precise matching.
* Example: `GET /PractitionerRole?languages=Italian`
* [`roletype`](SearchParameter-practitionerrole-roletype.md) (PractitionerRole.code.coding.display). Supports both `:contains` & `:exact` modifiers.
* Search for PractitionerRoles by their role type display name (for example, "Medical pathologist"). Uses string matching for display text.
* Example: `GET /PractitionerRole?roletype=Medical%20pathologist`

##### Availability

* [`allday`](SearchParameter-allday.md) (PractitionerRole.availableTime.allDay)
* Search for practitioner roles that are available all day, i.e. 24 hours. This shared SearchParameter works for both HealthcareService and PractitionerRole resources.
* Example (all day): `GET /PractitionerRole?allday=true`
* Example (not all day): `GET /PractitionerRole?allday=false`
* [`daysofweek`](SearchParameter-daysofweek.md) (PractitionerRole.availableTime.daysOfWeek)
* Search for practitioner roles by days of the week they are available. This shared SearchParameter works for both HealthcareService and PractitionerRole resources.
* Example (Monday): `GET /PractitionerRole?daysofweek=mon`
* Example (weekend): `GET /PractitionerRole?daysofweek=sat,sun`

**Availability (Start/End Time)**

* Shared parameters: [starttime](SearchParameter-starttime.md) and [endtime](SearchParameter-endtime.md) work for both HealthcareService and PractitionerRole.
* Format: Numeric HHMM (e.g., 0800 for 8:00 AM, 1730 for 5:30 PM). Do not include colons in queries.
* Matching: Numeric comparisons with prefix operators.
* Prefix operators: `eq` (=), `ge` (>=), `gt` (>), `le` (<=), `lt` (<), `ne` (!=). When no prefix is specified, `eq` is implied.
* Examples:
* Exact start: GET /PractitionerRole?starttime=0900
* Starts before 10 AM: GET /PractitionerRole?starttime=lt1000
* Exact end: GET /PractitionerRole?endtime=1700
* Ends after 6 PM: GET /PractitionerRole?endtime=gt1800

**Limitation:** Combination in a query cannot guarantee the correct pairing of `starttime` and `endtime` from the same availableTime block. Use of `daysofweek` can help filter, but may still return mixed results when multiple blocks exist for a day. At an implementation layer further filtering may be needed to ensure correct pairing.

**Note:** Support for _id is mandatory for a responder and optional for a requester. Where the expectation for a search parameter differs between actors, the table below will reflect the stronger conformance requirement.

* Parameter(s): _id
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): identifier
  * Conformance: **SHALL**
  * Type(s): `token`
  * Requirements (when used alone or in combination): Requester Actors SHOULD support search using Medicare Provider Number or Ahpra number as defined in the profile.
* Parameter(s): roletype
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): languages
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): identifier+languages
  * Conformance: **SHOULD**
  * Type(s): `token`+`string`
  * Requirements (when used alone or in combination): 
* Parameter(s): allday
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): Shared SearchParameter for availability across HealthcareService and PractitionerRole
* Parameter(s): daysofweek
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): Shared SearchParameter for availability across HealthcareService and PractitionerRole
* Parameter(s): starttime
  * Conformance: **SHOULD**
  * Type(s): `number`
  * Requirements (when used alone or in combination): Shared SearchParameter. Numeric HHMM format (e.g., 0800).
* Parameter(s): endtime
  * Conformance: **SHOULD**
  * Type(s): `number`
  * Requirements (when used alone or in combination): Shared SearchParameter. Numeric HHMM format (e.g., 1700).
* Parameter(s): identifier+daysofweek
  * Conformance: **SHOULD**
  * Type(s): `token`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): identifier+starttime
  * Conformance: **SHOULD**
  * Type(s): `token`+`number`
  * Requirements (when used alone or in combination): 
* Parameter(s): roletype+daysofweek
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): roletype+starttime
  * Conformance: **SHOULD**
  * Type(s): `string`+`number`
  * Requirements (when used alone or in combination): 
* Parameter(s): daysofweek+starttime+endtime
  * Conformance: **SHOULD**
  * Type(s): `token`+`number`+`number`
  * Requirements (when used alone or in combination): 

### Search include parameters

This implementation supports the following `_include` parameters when searching for PractitionerRole resources:

* `_include=PractitionerRole:practitioner` - Include Practitioner resources referenced by the `practitioner` element
* `_include=PractitionerRole:healthcareService` - Include HealthcareService resources referenced by the `healthcareService` element
* `_include=PractitionerRole:organization` - Include Organization resources referenced by the `organization` element
* `_include=PractitionerRole:location` - Include Location resources referenced by the `location` element
* `_include=PractitionerRole:endpoint` - Include Endpoint resources referenced by the `endpoint` element

### Search reverse include parameters

This implementation supports the following `_revinclude` parameters when searching for PractitionerRole resources:

* `_revinclude=Provenance:target` - Include Provenance resources that track changes to this PractitionerRole

#### Example usage

```
GET /PractitionerRole/101?_include=PractitionerRole:practitioner&_include=PractitionerRole:organization&_include=PractitionerRole:location

```

This query returns the PractitionerRole with the associated Practitioner, Organization, and Location details.

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hc-practitionerrole",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole",
  "version" : "0.2.0-preview",
  "name" : "HCPractitionerRole",
  "title" : "HC PractitionerRole",
  "status" : "draft",
  "experimental" : false,
  "date" : "2026-01-20T04:27:33+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.digitalhealth.gov.au/"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile defines a practitioner in role for an organisation at a location providing a healthcare service.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole|2.0.0-ballot",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole",
        "definition" : "Directory entry for a provider at a location for an organisation.",
        "constraint" : [
          {
            "key" : "inv-01-identifier-registration-required",
            "severity" : "error",
            "human" : "Either Ahpra or PRN identifier SHALL exist, but not both. While a practitioner can have more than one professional registration and\nprofessions (e.g. nurse and midwife), the relevant registration that is applicable for this role only is captured.",
            "expression" : "(identifier.type.coding.where(code = 'AHPRA').exists() and identifier.type.coding.where(code = 'PRN').exists().not()) or (identifier.type.coding.where(code = 'PRN').exists() and identifier.type.coding.where(code = 'AHPRA').exists().not())",
            "source" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole|0.2.0-preview"
          },
          {
            "key" : "inv-02-identifier-registration-match",
            "severity" : "warning",
            "human" : "PractitionerRole registration identifiers SHOULD match with the referenced Practitioner's registration identifiers in qualifications",
            "expression" : "practitioner.resolve().qualification.identifier.where(type.coding.where(code = 'AHPRA').exists()).value.intersect(identifier.where(type.coding.where(code = 'AHPRA').exists()).value).exists() or practitioner.resolve().qualification.identifier.where(type.coding.where(code = 'PRN').exists()).value.intersect(identifier.where(type.coding.where(code = 'PRN').exists()).value).exists()",
            "source" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole|0.2.0-preview"
          }
        ]
      },
      {
        "id" : "PractitionerRole.extension",
        "path" : "PractitionerRole.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "PractitionerRole.extension:hc-practitioner-role-communication",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.extension",
        "sliceName" : "hc-practitioner-role-communication",
        "short" : "Practitioner role communication preferences",
        "definition" : "Communication preferences and available modes for a practitioner in this role.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner-role-communication|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.extension:hc-preferred-name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.extension",
        "sliceName" : "hc-preferred-name",
        "short" : "Preferred name for this practitioner role",
        "definition" : "Name by which a practitioner chooses to be known in the context of the delivery of a specific healthcare service.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-preferred-name|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.identifier",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "type"
            }
          ],
          "description" : "Slice based on identifier system: must include at least one HC Location Identifier known to this profile",
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "PractitionerRole.identifier:medicareProvider",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.identifier",
        "sliceName" : "medicareProvider",
        "short" : "Medicare provider number"
      },
      {
        "id" : "PractitionerRole.identifier:peakbodyregistrationnumber",
        "path" : "PractitionerRole.identifier",
        "sliceName" : "peakbodyregistrationnumber",
        "short" : "Professional association / Peak body association (for non-Ahpra registered practitioners), as recorded against the HPI-I record",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-pbprn|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.identifier:ahpraregistrationnumber",
        "path" : "PractitionerRole.identifier",
        "sliceName" : "ahpraregistrationnumber",
        "short" : "Ahpra Registration Number",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://hl7.org.au/fhir/StructureDefinition/au-ahpraregistrationnumber|6.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.period",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.period",
        "short" : "The period during which the practitioner is active in this role.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.practitioner",
        "path" : "PractitionerRole.practitioner",
        "short" : "Practitioner in the role",
        "definition" : "Australian practitioner directory entry in this role.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner|0.2.0-preview"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.organization",
        "path" : "PractitionerRole.organization",
        "short" : "Organisation providing this role. Reference to be the same organisation as the referenced HealthcareService for this role.",
        "definition" : "Australian organisation directory entry providing this role.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.code",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.code",
        "short" : "The primary role of the practitioner",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "PractitionerRole.location",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.location",
        "short" : "Location at which this role is provided. Reference to be the same Location as the referenced HealthcareService for this role.",
        "definition" : "Location details describing where the role is being provided.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.healthcareService",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.healthcareService",
        "short" : "Healthcare service at which this role is provided.",
        "definition" : "Healthcare details describing where the role is being provided.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-healthcareservice|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.telecom",
        "path" : "PractitionerRole.telecom",
        "short" : "Contact details for the practitioner in this role.",
        "definition" : "Details for contacting the practitioner in this role."
      },
      {
        "id" : "PractitionerRole.availableTime",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.availableTime",
        "short" : "Times that the practitioner provides the healthcare service in this role at this location.",
        "definition" : "Times that the practitioner provides the healthcare service in this role at this location.",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.availableTime.daysOfWeek",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.availableTime.daysOfWeek",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.availableTime.allDay",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.availableTime.allDay",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.availableTime.availableStartTime",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.availableTime.availableStartTime",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.availableTime.availableEndTime",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.availableTime.availableEndTime",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.endpoint",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.endpoint",
        "short" : "Technical endpoints for this practitioner role.",
        "definition" : "Details for service based communication with the practitioner in this role. This can include web services, messaging profiles and other protocol based communication.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
