# HC Organization - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](artifacts.md)
* **HC Organization**

## Resource Profile: HC Organization 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization | *Version*:0.2.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HCOrganization |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

 
This profile defines a Provider Directory entry for an organisation. 

No data is entered directly into Health Connect; all Directory content is sourced from authoritative systems including [PCA](https://developer.digitalhealth.gov.au/fhir/provider-connect-australia/current/index.html?src=/), HI-Service, and NHSD.

### Extensions

The following extensions are introduced in this profile:

* [HC Organization Classification](StructureDefinition-hc-org-classification.md)

#### Organisation classification

The [extension:hc-org-classification](StructureDefinition-hc-org-classification.md) is used to indicate whether an organisation's HPI-O and HSP-O record in the HI Service is classified as a 'seed' or 'network' type. Note HSP-O can only be of 'seed' type.

The following identifiers both profile the aforementioned classification extension within their definitions:

* [HC HPI-O](StructureDefinition-hc-hpio.md) on Organization.identifier[hpio]
* [HC HSP-O](StructureDefinition-hc-hspo.md) on Organization.identifier[hspo]

### Usage notes

The following guidance maps key information requirements for HC Organization records to fields in the profile. Where a requirement references the HI Service as the authoritative source, publishers SHOULD prefer and validate values-such as organisation identifiers and names-against the HI Service where practicable.

#### Identifiers

The HC Organization profile supports the identifier slices introduced in AU Core (as indicated by the must support flag). At least one authoritative identifier (for example HPI-O, HSP-O, ABN, or other recognised identifier) SHOULD be provided to enable consistent and correct identification of the healthcare organisation and to support validation against the HI Service where applicable. Organisation identifiers can also be used as search parameters to locate organisation records.

A HC Organization resource may also contain additional business partner identifiers. These are considered secondary to the HPI-O/HSP-O and MAY not match identifier slices defined in [AU Core Organization](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-organization.html).

Note: HI Service is expected to assign only one national identifier type to an Organization (either HPI‑O or HSP‑O), not both. As such, the profile defines the following invariants:

* `inv-01-identifier-hpi-or-hsp-required`: Either an HPI-O (hpio) or an HSP-O (hspo) identifier must be present on the Organization. (severity: error)
* `inv-02-identifier-not-both-hpio-hspo`: Warn if both HPI-O and HSP-O identifiers are present on the same Organization. (severity: warning)

**Usages:**

* Refer to this Profile: [HC HealthcareService](StructureDefinition-hc-healthcareservice.md), [HC Location](StructureDefinition-hc-location.md), [HC Organization](StructureDefinition-hc-organization.md), [HC PractitionerRole](StructureDefinition-hc-practitionerrole.md)...Show 2 more,[HC Provenance](StructureDefinition-hc-provenance.md)and[HC Service Coverage Area](StructureDefinition-hc-service-coverage-area.md)
* Examples for this Profile: [Example Aged Care Facility](Organization-example-healthconnect-organization-1.md) and [Caring Hands Home Support](Organization-example-healthconnect-organization-2.md)
* CapabilityStatements using this Profile: [Health Connect Provider Directory Requester](CapabilityStatement-health-connect-provider-directory-requester.md) and [Health Connect Provider Directory Responder](CapabilityStatement-health-connect-provider-directory-responder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/au.digitalhealth.r4.healthconnect|current/StructureDefinition/hc-organization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-hc-organization.csv), [Excel](StructureDefinition-hc-organization.xlsx), [Schematron](StructureDefinition-hc-organization.sch) 

### Notes:

### Search parameters for HC Organization

This IG defines no new SearchParameters for the Organization resource; it expects implementers to support common Organization parameters from both AU Core and R4.

#### Search parameters defined within AU Core

How these identifier searches can be used is described in [AU Core documentation](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-organization.html#notes). AU Core recommends using the standard FHIR `identifier` search parameter (token, system|value) for organization identifiers. Examples:

* ABN: `GET /Organization?identifier=http://hl7.org.au/id/abn|12345678912`
* ACN: `GET /Organization?identifier=http://hl7.org.au/id/acn|123456789`
* HPI-O: `GET /Organization?identifier=http://ns.electronichealth.net.au/id/hi/hpio/1.0|8003626566707032`
* HSP-O: `GET /Organization?identifier=http://ns.electronichealth.net.au/id/hi/hspo/1.0|8003640001234569`

#### Search parameters defined within FHIR R4

The following parameters are inherited from [R4](https://hl7.org/fhir/R4/organization.html) and are commonly useful; implementers SHOULD support them as indicated.

* [`name`](https://hl7.org/fhir/R4/organization.html#search)
 Standard R4 parameter that searches Organization.name and Organization.alias (partial matches supported). String type. Example: `GET /Organization?name=Example%20Aged`
* [`type`](https://hl7.org/fhir/R4/organization.html#search)
 Standard R4 parameter that searches Organization.type.coding using token semantics (system|code). Example: `Organization?type=http://snomed.info/sct|257652008`

* Parameter(s): _id
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): HPI-O
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The Health Connect Provider Directory Requester and Provider Directory SHOULD support search using the HPI-O identifier as defined in the profile.
* Parameter(s): HSP-O
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The Health Connect Provider Directory Requester and Provider Directory SHOULD support search using the HSP-O identifier as defined in the profile.
* Parameter(s): ABN
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The Health Connect Provider Directory Requester and Provider Directory SHOULD support search using the ABN identifier as defined in the profile.
* Parameter(s): ACN
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): Use the standard `identifier` token form. Example:`?identifier=http://hl7.org.au/id/acn|123456789`
* Parameter(s): name (R4)
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): type (R4)
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): HPI-O + type
  * Conformance: **SHOULD**
  * Type(s): `token`+`token`
  * Requirements (when used alone or in combination): 

### Search include parameters

This implementation supports the following `_include` parameters when searching for Organization resources:

* `_include=Organization:partOf` - Include parent organizations referenced by the `partOf` element

### Search reverse include parameters

This implementation supports the following `_revinclude` parameters when searching for Organization resources:

* `_revinclude=Location:organization` - Include Location resources that reference this Organization through their `managingOrganization` element
* `_revinclude=Provenance:target` - Include Provenance resources that track changes to this Organization

#### Example usage

```
GET /Organization/123?_revinclude=Location:organization&_revinclude=HealthcareService:organization

```

This query returns the Organization resource along with all associated Locations and HealthcareServices.

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hc-organization",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization",
  "version" : "0.2.0-preview",
  "name" : "HCOrganization",
  "title" : "HC Organization",
  "status" : "draft",
  "experimental" : false,
  "date" : "2026-01-20T04:27:33+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.digitalhealth.gov.au/"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile defines a Provider Directory entry for an organisation.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization|2.0.0-ballot",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization",
        "short" : "Australian Organisation Directory Entry",
        "definition" : "Directory entry Australian realm Organization profile often healthcare or related service provision.",
        "constraint" : [
          {
            "key" : "inv-01-identifier-hpi-or-hsp-required",
            "severity" : "error",
            "human" : "Either an HPI-O (hpio) or an HSP-O (hspo) identifier must be present on the Organization.",
            "expression" : "identifier.where(system='http://ns.electronichealth.net.au/id/hi/hpio/1.0').exists() or identifier.where(system='http://ns.electronichealth.net.au/id/hi/hspo/1.0').exists()",
            "source" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
          },
          {
            "key" : "inv-02-identifier-not-both-hpio-hspo",
            "severity" : "warning",
            "human" : "Warn if both HPI-O and HSP-O identifiers are present on the same Organization; HI Service is expected to assign only one.",
            "expression" : "identifier.where(system='http://ns.electronichealth.net.au/id/hi/hpio/1.0').exists() implies identifier.where(system='http://ns.electronichealth.net.au/id/hi/hspo/1.0').exists().not() and identifier.where(system='http://ns.electronichealth.net.au/id/hi/hspo/1.0').exists() implies identifier.where(system='http://ns.electronichealth.net.au/id/hi/hpio/1.0').exists().not()",
            "source" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
          }
        ]
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:hpio",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.identifier",
        "sliceName" : "hpio",
        "short" : "HPI-O identifier",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-hpio|0.2.0-preview"
            ]
          }
        ]
      },
      {
        "id" : "Organization.identifier:abn",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.identifier",
        "sliceName" : "abn",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:hspo",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.identifier",
        "sliceName" : "hspo",
        "short" : "HSP-O identifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-hspo|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:acn",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.identifier",
        "sliceName" : "acn",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://hl7.org.au/fhir/StructureDefinition/au-australiancompanynumber|6.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Organization.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.name",
        "short" : "Name of Directory Entry Organisation"
      },
      {
        "id" : "Organization.alias",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.alias",
        "short" : "Additional preferred name or alias, as provided by the organisation.",
        "definition" : "A chosen or preferred name, that is different from the entity's legal name, to provide flexibility to organisations who use an alternative name in connection with their organisation.",
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Organization.telecom",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.telecom"
      },
      {
        "id" : "Organization.telecom.system",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.telecom.system"
      },
      {
        "id" : "Organization.telecom.value",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.telecom.value"
      },
      {
        "id" : "Organization.address",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.address",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "description" : "Slice based on address type: physical, postal, both. Must have at least one physical or both.",
          "rules" : "open"
        },
        "short" : "Addresses of Directory Entry Organisation",
        "min" : 1,
        "max" : "2"
      },
      {
        "id" : "Organization.address:physical",
        "path" : "Organization.address",
        "sliceName" : "physical",
        "short" : "Registered Business Address of the organisation, as recorded against the HPI-O record.",
        "definition" : "The registered business address of the organisation as required for directory entry. Must be type 'physical'.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organization.address:physical.type",
        "path" : "Organization.address.type",
        "min" : 1,
        "patternCode" : "physical"
      },
      {
        "id" : "Organization.address:postal",
        "path" : "Organization.address",
        "sliceName" : "postal",
        "short" : "A chosen or preferred mailing address, that is different from the registered address.",
        "definition" : "Optional preferred address / postal address / PO box address for the organisation (legal entity), as provided by the organisation on PCA. Must be type 'postal'.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.address:postal.type",
        "path" : "Organization.address.type",
        "min" : 1,
        "patternCode" : "postal"
      },
      {
        "id" : "Organization.partOf",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Organization.partOf",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
