# HC HealthcareService - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](artifacts.md)
* **HC HealthcareService**

## Resource Profile: HC HealthcareService 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/StructureDefinition/hc-healthcareservice | *Version*:0.2.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HCHealthcareService |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

 
This profile of HealthcareService represents a particular type of health or health related service offered by a healthcare organisation at a particular location i.e. a practice, clinic, facility, or hospital. The authoritative source for healthcare services is the healthcare provider organisation that provides the service(s). 

No data is entered directly into Health Connect; all Directory content is sourced from authoritative systems including [PCA](https://developer.digitalhealth.gov.au/fhir/provider-connect-australia/current/index.html?src=/), HI-Service, and NHSD.

### Extensions

Extensions introduced in this profile:

* HealthcareService: [IAR Levels of Care](StructureDefinition-iar-levels-of-care.md)
* HealthcareService: [Health Connect Active Period](StructureDefinition-hc-active-period.md)
* HealthcareService: [Health Connect Accept New Patient](StructureDefinition-hc-accept-new-patient.md)
* HealthcareService: [Health Connect Referral Information for Referrer](StructureDefinition-hc-referral-information-for-referrer.md)
* HealthcareService.availableTime.availableStartTime: [Timezone Code](https://hl7.org/fhir/extensions/5.2.0/StructureDefinition-timezone.html)
* HealthcareService.availableTime.availableEndTime: [Timezone Code](https://hl7.org/fhir/extensions/5.2.0/StructureDefinition-timezone.html)

### Usage notes

The `extension:iar-levels-of-care` is used to indicate the Initial Assessment and Referral (IAR) Levels of Care for a healthcare services that support mental health care. This extension draws its codes from the [IAR Levels of Care ValueSet](ValueSet-iar-levels-of-care-vs.md). The ValueSet includes the codes as follows:

* 1: Level 1 (self-management)
* 2: Level 2 (low intensity interventions)
* 3: Level 3 (moderate intensity interventions)
* 4: Level 4 (high intensity interventions)
* 5: Level 5 (specialist and acute services)

#### Accept new patient

Boolean datatype that indicates whether the healthcare service is accepting new patients.

#### Organization reference

The **providedBy** element must contain a relative reference to an existing [HC Organization](StructureDefinition-hc-organization.md).

#### Service provision code

This section describes the use of codes to indicate payment and billing options, helping requesters or searchers make informed decisions when seeking healthcare services.

#### Service type

Utilises the Service Type ValueSet, to draw codes from SNOMED that define concepts for the type of service that the healthcare service provides.

A single code representing the primary service type MUST be provided and selected from the [Service Type value set](https://healthterminologies.gov.au/fhir/ValueSet/service-type-1).

#### Location reference

The **location** element must contain a relative reference to an existing [HC Location](StructureDefinition-hc-location.md) whose **managingOrganization** references the same HC Organization as is referenced by the **providedBy** element.

#### Availability

To indicate the healthcare service is not available during a period of time, use **notAvailable**.

#### Coverage area

The coverage area that a service is intended for/available to should be defined using one or more instances of the **coverageArea** element, with the **address** elements of the contained `Location` populated depending on the type of coverage area to be defined. HealthConnect currently supports coverage areas to be defined as Australia-wide (in which case only one **coverageArea** element should be present), or as a combination of individual states and/or suburbs (with separate **coverageArea** elements for each). See the [HC Service Coverage Area](StructureDefinition-hc-service-coverage-area.md) profile for more information.

#### Referral information

Some subscribing systems may render markdown contained in the [HC Referral Information For Referrer](StructureDefinition-hc-referral-information-for-referrer.md) element; however this is not guaranteed, so publishing systems should limit markdown syntax in these elements to that which still renders well as plain text (such as bullets, numbered lists, or bold/italic text).

**Usages:**

* Refer to this Profile: [HC PractitionerRole](StructureDefinition-hc-practitionerrole.md) and [HC Provenance](StructureDefinition-hc-provenance.md)
* Examples for this Profile: [Healthcare service with Residential Aged Care service type](HealthcareService-example-healthconnect-healthcareservice-1.md)
* CapabilityStatements using this Profile: [Health Connect Provider Directory Requester](CapabilityStatement-health-connect-provider-directory-requester.md) and [Health Connect Provider Directory Responder](CapabilityStatement-health-connect-provider-directory-responder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/au.digitalhealth.r4.healthconnect|current/StructureDefinition/hc-healthcareservice)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-hc-healthcareservice.csv), [Excel](StructureDefinition-hc-healthcareservice.xlsx), [Schematron](StructureDefinition-hc-healthcareservice.sch) 

### Notes:

### Search parameters

This IG defines and intoduces several search parameters in addition to those inherited, that make it easier to find and filter `HC Healthcare Service` resources in Health Connect implementations. The following search parameters are defined and **SHOULD** be supported:

#### Search parameters defined in FHIR R4

* [`service-type`](https://hl7.org/fhir/R4/healthcareservice.html) (HealthcareService.type)
* Searches `HealthcareService.type`. It is a token search - use the fully-qualified `system|code` form to avoid ambiguity.

Examples:

* Unencoded: `GET /HealthcareService?service-type=http://snomed.info/sct|1256161000168107`
* Encoded: `GET /HealthcareService?service-type=http%3A%2F%2Fsnomed.info%2Fsct%2F32506021000036107%7C1256161000168107`

Note: Values come from the HC Healthcare Service value set (SNOMED). Use codes that are children of 224930009 ("Services"), excluding 700232004 ("General medical service").

#### Search parameters defined in this IG

The following search parameters are **defined by this IG** and **SHOULD** be supported:

* [`languages`](SearchParameter-languages.md) (HealthcareService.communication.coding.display OR PractitionerRole.extension.where(url='http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner-role-communication').value.ofType(CodeableConcept).coding.display)
* Search for healthcare services by the languages they support for communication. This shared SearchParameter works for both HealthcareService and PractitionerRole resources.
* Supports `:contains` modifier for partial matching, `:exact` modifier for precise matching.
* Example (display text): `GET /HealthcareService?languages=Italian`
* [`hsbilling`](SearchParameter-healthcareservice-billing.md) (HealthcareService.serviceProvisionCode)
* Search for healthcare services by their billing or service provision conditions (for example, bulk billing, fees apply).
* Example (preferred, unambiguous): `GET /HealthcareService?hsbilling=http://terminology.hl7.org.au/CodeSystem/service-provision-conditions|FAP`

##### Availability

*  

| | |
| :--- | :--- |
| [`allday`](SearchParameter-allday.md)(HealthcareService.availableTime.allDay | PractitionerRole.availableTime.allDay) |

 
* Search for services/roles by whether they are available all day. Use token semantics for boolean values.
* Example: `GET /HealthcareService?allday=true`
* Example: `GET /PractitionerRole?allday=false`
*  

| | |
| :--- | :--- |
| [`daysofweek`](SearchParameter-daysofweek.md)(HealthcareService.availableTime.daysOfWeek | PractitionerRole.availableTime.daysOfWeek) |

 
* Search for services/roles by days of the week they are available. Supports multiple days using OR logic.
* Available day codes: mon, tue, wed, thu, fri, sat, sun
* Example: `GET /HealthcareService?daysofweek=mon`
* Example: `GET /HealthcareService?daysofweek=mon,tue,wed` (multiple days)
* Example: `GET /PractitionerRole?daysofweek=fri`

**Availability (Start/End Time)**

* Shared parameters: [starttime](SearchParameter-starttime.md) and [endtime](SearchParameter-endtime.md) work for both HealthcareService and PractitionerRole.
* Format: Numeric HHMM (e.g., 0800 for 8:00 AM, 1730 for 5:30 PM). Do not include colons in queries.
* Matching: Numeric comparisons with prefix operators.
* Prefix operators: `eq` (=), `ge` (>=), `gt` (>), `le` (<=), `lt` (<), `ne` (!=). When no prefix is specified, `eq` is implied.
* Examples:
* Exact start: GET /HealthcareService?starttime=0800
* Starts at or after 9 AM: GET /HealthcareService?starttime=ge0900
* Starts before 10 AM: GET /PractitionerRole?starttime=lt1000
* Exact end: GET /HealthcareService?endtime=1700
* Ends at or before 4 PM: GET /HealthcareService?endtime=le1600
* Ends after 6 PM: GET /PractitionerRole?endtime=gt1800

**Limitation:** Combination in a query cannot guarantee the correct pairing of `starttime` and `endtime` from the same availableTime block. Use of `daysofweek` can help filter, but may still return mixed results when multiple blocks exist for a day. At an implementation layer further filtering may be needed to ensure correct pairing.

**Note:** Support for _id is mandatory for a responder and optional for a requester. Where the expectation for a search parameter differs between actors, the table below will reflect the stronger conformance requirement.

* Parameter(s): _id
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): service-type (R4)
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): languages
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): hsbilling
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): service-type+languages
  * Conformance: **SHOULD**
  * Type(s): `token`+`string`
  * Requirements (when used alone or in combination): 
* Parameter(s): service-type+hsbilling
  * Conformance: **SHOULD**
  * Type(s): `token`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): languages+hsbilling
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): languages+daysofweek
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): hsbilling+daysofweek
  * Conformance: **SHOULD**
  * Type(s): `token`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): daysofweek+starttime+endtime
  * Conformance: **SHOULD**
  * Type(s): `token`+`number`+`number`
  * Requirements (when used alone or in combination): 

### Search include parameters

This implementation supports the following `_include` parameters when searching for HealthcareService resources:

* `_include=HealthcareService:location` - Include Location resources referenced by the `location` element
* `_include=HealthcareService:providedBy` - Include Organization resources referenced by the `providedBy` element
* `_include=HealthcareService:endpoint` - Include Endpoint resources referenced by the `endpoint` element

### Search reverse include parameters

This implementation supports the following `_revinclude` parameters when searching for HealthcareService resources:

* `_revinclude=PractitionerRole:service` - Include PractitionerRole resources that reference this HealthcareService
* `_revinclude=Provenance:target` - Include Provenance resources that track changes to this HealthcareService

#### Example usage

```
GET /HealthcareService/789?_include=HealthcareService:location&_include=HealthcareService:providedBy&_revinclude=PractitionerRole:healthcareService

```

This query returns the HealthcareService with its Location, providing Organization, and all associated PractitionerRoles.

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hc-healthcareservice",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-healthcareservice",
  "version" : "0.2.0-preview",
  "name" : "HCHealthcareService",
  "title" : "HC HealthcareService",
  "status" : "draft",
  "experimental" : false,
  "date" : "2026-01-20T04:27:33+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.digitalhealth.gov.au/"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile of HealthcareService represents a particular type of health or health related service offered by a healthcare organisation at a particular location i.e. a practice, clinic, facility, or hospital. The authoritative source for healthcare services is the healthcare provider organisation that provides the service(s).",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "HealthcareService",
  "baseDefinition" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-healthcareservice|2.0.0-ballot",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "HealthcareService",
        "path" : "HealthcareService",
        "definition" : "Health Connect entry for a healthcare service at a location by an organisation."
      },
      {
        "id" : "HealthcareService.extension",
        "path" : "HealthcareService.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "HealthcareService.extension:iar-levels-of-care",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.extension",
        "sliceName" : "iar-levels-of-care",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/iar-levels-of-care|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.extension:hc-accept-new-patient",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.extension",
        "sliceName" : "hc-accept-new-patient",
        "short" : "Indicates if Healthcare service is accepting new patients",
        "definition" : "Indicates if Healthcare service is accepting new patients. A value of True means the service is accepting new patients.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-accept-new-patient|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.extension:hc-referral-information-for-referrer",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.extension",
        "sliceName" : "hc-referral-information-for-referrer",
        "short" : "Referral information for referrers",
        "definition" : "Information for referrers about referral requirements for this healthcare service.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-referral-information-for-referrer|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.extension:hc-active-period",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.extension",
        "sliceName" : "hc-active-period",
        "short" : "The period during which the HealthcareService is active.",
        "definition" : "The time period during which the HealthcareService is considered active in the HealthConnect directory.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-active-period|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.providedBy",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.providedBy",
        "short" : "Providing organisation",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.type",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-healthcareservice|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-healthcareservice|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.type",
        "short" : "A high-level descriptor describing the type of healthcare service(s) offered by the organisation",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/service-type-1"
        }
      },
      {
        "id" : "HealthcareService.type.coding",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.type.coding",
        "short" : "Describes the service(s) offered. At least one coding is required",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.type.coding.code",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.type.coding.code",
        "short" : "The healthcare service type code from SNOMED-CT-AU",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.type.coding.display",
        "path" : "HealthcareService.type.coding.display",
        "short" : "The display name of the healthcare service type from SNOMED-CT-AU",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.location",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.location",
        "short" : "Single location for this service",
        "definition" : "The location where this healthcare service may be provided.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.comment",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.comment",
        "short" : "Additional description and/or any specific information about the healthcare service, not covered elsewhere",
        "definition" : "Additional details, that the service provider can add for their directory listing, as a free text, that is not covered by other available data elements.",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.telecom",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-healthcareservice|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-healthcareservice|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.telecom",
        "short" : "Phone number, fax number, email"
      },
      {
        "id" : "HealthcareService.coverageArea",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.coverageArea",
        "short" : "The location(s) that this healthcare service is available to",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-service-coverage-area|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.serviceProvisionCode",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.serviceProvisionCode",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://ns.electronichealth.net.au/hc/ValueSet/hc-service-provision-code-vs|0.2.0-preview"
        }
      },
      {
        "id" : "HealthcareService.eligibility",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.eligibility",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.eligibility.code",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.eligibility.code",
        "short" : "Eligibility requirements for the healthcare service.",
        "definition" : "Eligibility requirements for the healthcare service, bound to the HealthConnect Service Eligibility ValueSet.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/service-eligibility-1"
        }
      },
      {
        "id" : "HealthcareService.communication",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.communication",
        "short" : "The languages that this healthcare service is offered in",
        "definition" : "Including the languages that the service is offered in, will help assist the requester / searcher in making informed decision and choose the service that meet their requirement when seeking healthcare service.",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.appointmentRequired",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.appointmentRequired",
        "short" : "Whether an appointment is required for this service",
        "definition" : "Whether an appointment is required for this service, or walk-in accepted – Yes or No (Null value represent ‘no data available’).",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.availableTime",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.availableTime",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.availableTime.daysOfWeek",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.availableTime.daysOfWeek",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.availableTime.allDay",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.availableTime.allDay",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.availableTime.availableStartTime",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.availableTime.availableStartTime",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.availableTime.availableStartTime.extension:timeZone",
        "path" : "HealthcareService.availableTime.availableStartTime.extension",
        "sliceName" : "timeZone",
        "short" : "The date on which an organisation commences offering a service"
      },
      {
        "id" : "HealthcareService.availableTime.availableEndTime",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.availableTime.availableEndTime",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.availableTime.availableEndTime.extension:timeZone",
        "path" : "HealthcareService.availableTime.availableEndTime.extension",
        "sliceName" : "timeZone",
        "short" : "The date on which an organisation ceases to offer a service"
      },
      {
        "id" : "HealthcareService.notAvailable",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.notAvailable",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.notAvailable.description",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.notAvailable.description",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.notAvailable.during",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.notAvailable.during",
        "short" : "Date range that the service is not available - can be open-ended if service is closing",
        "definition" : "Date range that the service is not available - can be open-ended if service is closing.",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.endpoint",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "HealthcareService.endpoint",
        "short" : "Reference to all linked endpoints that are related to this healthcare service for electronic communication or exchange",
        "definition" : "This will provide the linked endpoints that are related to this healthcare service, that can be discovered by other organisations for system-to-system electronic communication.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
