# HC Organization Example: Home Care Support Service - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](artifacts.md)
* **HC Organization Example: Home Care Support Service**

## Example Organization: HC Organization Example: Home Care Support Service

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2025-09-15 14:20:00+0000

Profile: [HC Organization](StructureDefinition-hc-organization.md)

**identifier**: National Organisation Identifier/8003640000000003, ABN/98765432109, ACN/987654321

**active**: true

**name**: Caring Hands Home Support

**alias**: CHHS

**telecom**: ph: (02) 9555 1200(Work), ph: (02) 9555 1201(Work), [admin@caringhands.com.au](mailto:admin@caringhands.com.au), [support@caringhands.com.au](mailto:support@caringhands.com.au), [https://www.caringhands.com.au](https://www.caringhands.com.au), fax: +61 2 9555 1299(Work)

**address**: 

* Suite 15, 88 Liverpool Street Sydney NSW 2000 AU 
* PO Box 5678 Sydney NSW 1234 AU 

**partOf**: [Organization Example Aged Care Facility](Organization-example-healthconnect-organization-1.md)

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "example-healthconnect-organization-2",
  "meta" : {
    "lastUpdated" : "2025-09-15T14:20:00Z",
    "profile" : [
      "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization"
    ]
  },
  "identifier" : [
    {
      "extension" : [
        {
          "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-org-classification",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://ns.electronichealth.net.au/hc/CodeSystem/hc-org-classification-cs",
                "code" : "seed",
                "display" : "Seed"
              }
            ]
          }
        }
      ],
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "NOI"
          }
        ]
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/hspo/1.0",
      "value" : "8003640000000003"
    },
    {
      "type" : {
        "text" : "ABN"
      },
      "system" : "http://hl7.org.au/id/abn",
      "value" : "98765432109"
    },
    {
      "type" : {
        "text" : "ACN"
      },
      "system" : "http://hl7.org.au/id/acn",
      "value" : "987654321"
    }
  ],
  "active" : true,
  "name" : "Caring Hands Home Support",
  "alias" : ["CHHS"],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(02) 9555 1200",
      "use" : "work"
    },
    {
      "system" : "phone",
      "value" : "(02) 9555 1201",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "admin@caringhands.com.au",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "support@caringhands.com.au",
      "use" : "work"
    },
    {
      "system" : "url",
      "value" : "https://www.caringhands.com.au",
      "use" : "work"
    },
    {
      "system" : "fax",
      "value" : "+61 2 9555 1299",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "type" : "physical",
      "line" : ["Suite 15, 88 Liverpool Street"],
      "city" : "Sydney",
      "state" : "NSW",
      "postalCode" : "2000",
      "country" : "AU"
    },
    {
      "type" : "postal",
      "line" : ["PO Box 5678"],
      "city" : "Sydney",
      "state" : "NSW",
      "postalCode" : "1234",
      "country" : "AU"
    }
  ],
  "partOf" : {
    "reference" : "Organization/example-healthconnect-organization-1"
  }
}

```
